/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.concrete.measurement;

import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.measurement.CommandMeasurement;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class ConcreteMeasurement
extends CommandMeasurement
implements CommandListener {
    private boolean triggerOnSetValue = this.getBoolean("concretemeasurement.triggeronsetvalue", true);
    private boolean triggerOnReadCommand = this.getBoolean("concretemeasurement.triggeronreadcommand", true);

    public ConcreteMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal, CommandService readCommand, CommandService writeCommand) {
        super(key, value, units, transform, signal, readCommand, writeCommand);
        if (readCommand != null) {
            readCommand.addCommandListener((CommandListener)this);
        }
        if (writeCommand != null) {
            writeCommand.addCommandListener((CommandListener)this);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        Object value;
        SignalService signal;
        if (this.triggerOnReadCommand && source == this.getReadCommand() && (signal = this.getSignal()) != null && (value = this.getValue()) != null) {
            signal.trigger(value);
        }
        if (source == this.getWriteCommand() && data != null) {
            this.setRawValue(data, timestamp);
        }
    }

    public void executeWrite(Object value) {
        if (this.getWriteCommand() != null) {
            this.setValue(value);
        }
        super.executeWrite(value);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.getReadCommand() != null) {
            this.getReadCommand().removeCommandListener((CommandListener)this);
        }
        if (this.getWriteCommand() != null) {
            this.getWriteCommand().removeCommandListener((CommandListener)this);
        }
        super.finalize();
    }

    public void setTriggerOnReadCommand(boolean triggerOnReadCommand) {
        this.triggerOnReadCommand = triggerOnReadCommand;
    }

    public void setTriggerOnSetValue(boolean triggerOnSetValue) {
        this.triggerOnSetValue = triggerOnSetValue;
    }

    public void setValue(Object value, Object timestamp) {
        SignalService signal;
        super.setValue(value, timestamp);
        if (this.triggerOnSetValue && (signal = this.getSignal()) != null && value != null) {
            signal.trigger(value);
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
    }
}

