/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.control.profile.test.agent;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.control.profile.ControlProfile;
import org.eclipse.soda.dk.control.profile.test.agent.ControlProfileAbstractTestCase;
import org.eclipse.soda.dk.testagent.TestAgent;

public class ControlProfileBitsTestCase
extends ControlProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.control.profile.test.agent.ControlProfileBitsTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    public ControlProfileBitsTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("ControlProfile");
    }

    public void test000_ControlBitsCount() throws InterruptedException {
        long expectedValue = Long.parseLong(this.getString("expected.bits.count.value", "0"));
        long realValue = Long.parseLong(this.getMeasurement(this.controlProfileServiceBitsCountExternalKey).toString());
        ControlProfileBitsTestCase.assertEquals((long)expectedValue, (long)realValue);
    }

    public void test010_ControlBitsDefaultValues() throws InterruptedException {
        Map controlBits = this.GetBits();
        String[] bitNames = ControlProfile.BIT_NAMES;
        int i = 1;
        while (i < bitNames.length) {
            Boolean bit = (Boolean)controlBits.get(bitNames[i]);
            ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
            ++i;
        }
    }

    public void test020_ControlBitsSetAll() throws InterruptedException {
        String bitsToSet = this.getString("bitlist", "");
        String[] inputBits = ControlProfileBitsTestCase.parseDelimitedByToken((String)bitsToSet, (String)",");
        long numBits = Long.parseLong(this.getString("expected.bits.count.value", "0"));
        ControlProfileBitsTestCase.assertEquals((long)inputBits.length, (long)numBits);
        Hashtable<String, Boolean> bits = new Hashtable<String, Boolean>();
        String[] bitNames = ControlProfile.BIT_NAMES;
        int i = 1;
        while (i < bitNames.length) {
            bits.put(bitNames[i], Boolean.valueOf(inputBits[i - 1]));
            ++i;
        }
        this.WriteBits(bits);
        Map controlBits = this.GetBits();
        int i2 = 1;
        while (i2 < bitNames.length) {
            Boolean bit = (Boolean)controlBits.get(bitNames[i2]);
            ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.valueOf(inputBits[i2 - 1]));
            ++i2;
        }
    }

    public void test030_ControlBitsSetSome() throws InterruptedException {
        Hashtable<String, Boolean> bits = new Hashtable<String, Boolean>();
        String[] bitNames = ControlProfile.BIT_NAMES;
        int i = 1;
        while (i < bitNames.length) {
            bits.put(bitNames[i], Boolean.FALSE);
            ++i;
        }
        this.WriteBits(bits);
        Hashtable<String, Boolean> newBits = new Hashtable<String, Boolean>();
        newBits.put("b3", Boolean.TRUE);
        newBits.put("b4", Boolean.TRUE);
        this.WriteBits(newBits);
        Map controlBits = this.GetBits();
        int i2 = 1;
        while (i2 < bitNames.length) {
            Boolean bit = (Boolean)controlBits.get(bitNames[i2]);
            if (i2 == 3 || i2 == 4) {
                ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.TRUE);
            } else {
                ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
            }
            ++i2;
        }
    }

    public void test040_ControlBitsOrExpression() throws InterruptedException {
        Hashtable<String, Boolean> bits = new Hashtable<String, Boolean>();
        String[] bitNames = ControlProfile.BIT_NAMES;
        int i = 1;
        while (i < bitNames.length) {
            bits.put(bitNames[i], Boolean.FALSE);
            ++i;
        }
        this.WriteBits(bits);
        this.WriteB3Expression("(|(b1 = true)(b2 = true))");
        Map controlBits = this.GetBits();
        Boolean bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
        Hashtable<String, Boolean> newBits = new Hashtable<String, Boolean>();
        newBits.put("b1", Boolean.TRUE);
        this.WriteBits(newBits);
        controlBits = this.GetBits();
        bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.TRUE);
        newBits = new Hashtable();
        newBits.put("b1", Boolean.FALSE);
        this.WriteBits(newBits);
        controlBits = this.GetBits();
        bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
        this.WriteB3Expression("");
    }

    public void test050_ControlBitsAndExpression() throws InterruptedException {
        Hashtable<String, Boolean> bits = new Hashtable<String, Boolean>();
        String[] bitNames = ControlProfile.BIT_NAMES;
        int i = 1;
        while (i < bitNames.length) {
            bits.put(bitNames[i], Boolean.FALSE);
            ++i;
        }
        this.WriteBits(bits);
        this.WriteB3Expression("(&(b1 = true)(b2 = true))");
        Map controlBits = this.GetBits();
        Boolean bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
        Hashtable<String, Boolean> newBits = new Hashtable<String, Boolean>();
        newBits.put("b1", Boolean.TRUE);
        this.WriteBits(newBits);
        controlBits = this.GetBits();
        bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
        newBits = new Hashtable();
        newBits.put("b2", Boolean.TRUE);
        this.WriteBits(newBits);
        controlBits = this.GetBits();
        bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.TRUE);
        newBits = new Hashtable();
        newBits.put("b2", Boolean.FALSE);
        this.WriteBits(newBits);
        controlBits = this.GetBits();
        bit = (Boolean)controlBits.get("b3");
        ControlProfileBitsTestCase.assertEquals((Object)bit, (Object)Boolean.FALSE);
    }
}

