/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core.testcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class TableTestcase
extends TestCase {
    public static final int COUNT = 0x7FFFFF;
    public int dummyCount = 0;
    public volatile int dummyCountV = 0;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.core.testcase.TableTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public int getValue() {
        return this.dummyCount++;
    }

    public synchronized int getValueSync() {
        return this.dummyCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValueSyncInternal() {
        TableTestcase tableTestcase = this;
        synchronized (tableTestcase) {
            return this.dummyCount++;
        }
    }

    public void testHashMap01() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(101);
        Integer key = new Integer(0);
        Integer value = new Integer(1);
        long hashMapStart = System.currentTimeMillis();
        int i = 0;
        while (i < 0x7FFFFF) {
            hashMap.put(key, value);
            ++i;
        }
        long hashMapEnd = System.currentTimeMillis();
        System.out.println("time hashMap " + (hashMapEnd - hashMapStart));
        Hashtable<Integer, Integer> hashTable = new Hashtable<Integer, Integer>(101);
        long hashTableStart = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 0x7FFFFF) {
            hashTable.put(key, value);
            ++i2;
        }
        long hashTableEnd = System.currentTimeMillis();
        System.out.println("time hashTable " + (hashTableEnd - hashTableStart));
    }

    public void testHashMap02() {
        long hashMapStart = System.currentTimeMillis();
        int i = 0;
        while (i < 0x7FFFFF) {
            new HashMap(101);
            ++i;
        }
        long hashMapEnd = System.currentTimeMillis();
        System.out.println("time construct " + (hashMapEnd - hashMapStart));
        HashMap hashMapBase = new HashMap(101);
        long hashTableStart = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 0x7FFFFF) {
            hashMapBase.clone();
            ++i2;
        }
        long hashTableEnd = System.currentTimeMillis();
        System.out.println("time clone " + (hashTableEnd - hashTableStart));
    }

    public void testHashMap03() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Integer value = new Integer(1);
        arrayList.add(value);
        long hashMapStart = System.currentTimeMillis();
        int i = 0;
        while (i < 0x7FFFFF) {
            arrayList.get(0);
            ++i;
        }
        long hashMapEnd = System.currentTimeMillis();
        System.out.println("time arrayList " + (hashMapEnd - hashMapStart));
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(value);
        long hashTableStart = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 0x7FFFFF) {
            vector.get(0);
            ++i2;
        }
        long hashTableEnd = System.currentTimeMillis();
        System.out.println("time vector " + (hashTableEnd - hashTableStart));
    }

    public void testHashMap04() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(101);
        Object[] keys = new String[4096];
        int i = 0;
        while (i < 4096) {
            String key = Integer.toString(i);
            Integer value = new Integer(i);
            hashMap.put(key, value);
            keys[i] = "This is a very long string to see if this makes any diffence" + key;
            ++i;
        }
        Arrays.sort(keys);
        long start = System.currentTimeMillis();
        int j = 0;
        while (j < 127) {
            int i2 = 0;
            while (i2 < 4096) {
                Object key = keys[i2];
                hashMap.get(key);
                ++i2;
            }
            ++j;
        }
        long end = System.currentTimeMillis();
        System.out.println("time map lookup " + (end - start));
        long start2 = System.currentTimeMillis();
        int j2 = 0;
        while (j2 < 127) {
            int i3 = 0;
            while (i3 < 4096) {
                Object key = keys[i3];
                Arrays.binarySearch(keys, key);
                ++i3;
            }
            ++j2;
        }
        long end2 = System.currentTimeMillis();
        System.out.println("time binary search lookup " + (end2 - start2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSync() {
        long test0Start = System.currentTimeMillis();
        int i = 0;
        while (i < 0x7FFFFF) {
            this.getValue();
            ++i;
        }
        long test0End = System.currentTimeMillis();
        System.out.println("time no sync " + (test0End - test0Start));
        long test1Start = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 0x7FFFFF) {
            this.getValueSync();
            ++i2;
        }
        long test1End = System.currentTimeMillis();
        System.out.println("time sync " + (test1End - test1Start));
        long test2Start = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < 0x7FFFFF) {
            this.getValueSyncInternal();
            ++i3;
        }
        long test2End = System.currentTimeMillis();
        System.out.println("time sync internal " + (test2End - test2Start));
        long test3Start = System.currentTimeMillis();
        int i4 = 0;
        while (i4 < 0x7FFFFF) {
            TableTestcase tableTestcase = this;
            synchronized (tableTestcase) {
                this.getValue();
            }
            this.getValue();
            ++i4;
        }
        long test3End = System.currentTimeMillis();
        System.out.println("time sync block " + (test3End - test3Start));
    }
}

