/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.nls.testcase;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.nls.Nls;

public class NlsTestcase
extends TestCase {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.nls.testcase.NlsTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public NlsTestcase(String name) {
        super(name);
    }

    public void test02() {
        Hashtable table = Nls.getProperties(((Object)((Object)this)).getClass(), (String)"Test2");
        System.out.println(table.size());
        NlsTestcase.assertEquals((int)3, (int)table.size());
    }

    public void test03() {
        Hashtable table = Nls.getProperties(((Object)((Object)this)).getClass(), (String)"Test3");
        System.out.println(table.size());
        NlsTestcase.assertEquals((int)1, (int)table.size());
    }

    public void test04() {
        Properties table = System.getProperties();
        Object[] objects = new Object[]{table, table};
        String data = Nls.format((String)"data 0 = {0}\r\n\t data 1 = {1}", (Object[])objects);
        System.out.println(data);
    }

    public void test10() {
        String results = Nls.formatData((Object)"\tabc\r\n\"");
        NlsTestcase.assertEquals((String)"\"\\tabc\\r\\n\\\"\"", (String)results);
    }

    public void test11() {
        String results = Nls.formatData((Object)"\t,abc\r\n\"");
        NlsTestcase.assertEquals((String)"\"\\t,abc\\r\\n\\\"\"", (String)results);
    }

    public void testa() {
        String[] additions = Nls.getNlsAdditions();
        int i = 0;
        while (i < additions.length) {
            System.out.println(additions[i]);
            ++i;
        }
    }

    public void testFormat01() {
        byte[] bytes = new byte[]{1, 2};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"{1,2}", (String)results);
    }

    public void testFormat02() {
        byte[] bytes = new byte[]{13, 10};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"\"\\r\\n\"", (String)results);
    }

    public void testFormat03() {
        byte[] bytes = new byte[]{48, 49, 13, 10};
        String results = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
        System.out.println(results);
        NlsTestcase.assertEquals((String)"\"01\\r\\n\"", (String)results);
    }
}

