/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.AsciiCrlfMessage;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameters;
import org.eclipse.soda.dk.parameter.SimpleParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;
import org.eclipse.soda.dk.transform.IntegerTranslateTransform;
import org.eclipse.soda.dk.transform.service.TransformService;

public class SimpleParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public SimpleParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.SimpleParameterTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testAsciiDecode() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 112);
        AsciiMessage message = new AsciiMessage("0123");
        int i = 0;
        while (i < 100000) {
            parameter.decodeValue((MessageService)message);
            ++i;
        }
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testAsiiCrlfDecode() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 112);
        AsciiCrlfMessage message = new AsciiCrlfMessage("0123\r\n");
        int i = 0;
        while (i < 100000) {
            parameter.decodeValue((MessageService)message);
            ++i;
        }
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testBytes() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 84);
        Message message = new Message(new byte[1]);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new byte[]{1, 2, 3});
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        SimpleParameterTestcase.assertEquals((Object)new Message(byArray), (Object)result);
    }

    public void testBytesByte() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 84);
        Message message = new Message(new byte[1]);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Byte[]{new Byte(1), new Byte(2), new Byte(3)});
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        SimpleParameterTestcase.assertEquals((Object)new Message(byArray), (Object)result);
    }

    public void testBytesDecodeValue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 80);
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertTrue((boolean)(result instanceof byte[]));
        byte[] good = new byte[]{1, 2, 3};
        byte[] resultBytes = (byte[])result;
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testBytesEncode() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 80);
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] data = new byte[]{4, 3, 2};
        MessageService result = parameter.encodeValue((MessageService)message, (Object)data);
        byte[] byArray2 = new byte[4];
        byArray2[1] = 4;
        byArray2[2] = 3;
        byArray2[3] = 2;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testBytesShorterEncode() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 80);
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byte[] bytes = byArray;
        Message message = new Message(bytes);
        byte[] data = new byte[]{4};
        MessageService result = parameter.encodeValue((MessageService)message, (Object)data);
        byte[] byArray2 = new byte[4];
        byArray2[1] = 4;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testDecodeDouble() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 8, 176);
        long data = Double.doubleToLongBits(1.5);
        byte[] bytes = new byte[8];
        int i = 7;
        while (i >= 0) {
            bytes[i] = (byte)data;
            data >>= 8;
            --i;
        }
        Message message = new Message(bytes);
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Double(1.5), (Object)result);
        result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Double(1.5), (Object)result);
        result = parameter.decode((Object)bytes);
        SimpleParameterTestcase.assertEquals((Object)new Double(1.5), (Object)result);
    }

    public void testDecodeFloat() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 160);
        int data = Float.floatToIntBits(1.5f);
        byte[] bytes = new byte[4];
        int i = 3;
        while (i >= 0) {
            bytes[i] = (byte)data;
            data >>= 8;
            --i;
        }
        Message message = new Message(bytes);
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Float(1.5f), (Object)result);
        result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Float(1.5f), (Object)result);
        result = parameter.decode((Object)bytes);
        SimpleParameterTestcase.assertEquals((Object)new Float(1.5f), (Object)result);
    }

    public void testDecodeInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 0);
        byte[] bytes = new byte[]{1, 2, 3, 4};
        Message message = new Message(bytes);
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(16909060), (Object)result);
        result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(16909060), (Object)result);
        result = parameter.decode((Object)bytes);
        SimpleParameterTestcase.assertEquals((Object)new Integer(16909060), (Object)result);
    }

    public void testDecodeIntegerArray() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 8, 8);
        byte[] bytes = new byte[]{1, 2, 3, 4, 4, 3, 2, 1};
        Message message = new Message(bytes);
        int[] result = (int[])parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((int)16909060, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)67305985, (int)result[1]);
        result = (int[])parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((int)16909060, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)67305985, (int)result[1]);
        result = (int[])parameter.decode((Object)bytes);
        SimpleParameterTestcase.assertEquals((int)16909060, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)67305985, (int)result[1]);
    }

    public void testDecodeIntegerTransform() {
        IntegerTranslateTransform transform = new IntegerTranslateTransform(1);
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, (TransformService)transform, 0, 4, 128);
        AsciiMessage message = new AsciiMessage("1234");
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(1235), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, (TransformService)transform, 0, 4, 128);
        message = new AsciiMessage("0123");
        result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(124), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, (TransformService)transform, 0, 4, 128);
        message = new AsciiMessage("0x23");
        result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(36), (Object)result);
    }

    public void testDecodeShortArray() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 8, 40);
        byte[] bytes = new byte[]{1, 2, 3, 4, 4, 3, 2, 1};
        Message message = new Message(bytes);
        short[] result = (short[])parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((int)258, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)772, (int)result[1]);
        SimpleParameterTestcase.assertEquals((int)1027, (int)result[2]);
        SimpleParameterTestcase.assertEquals((int)513, (int)result[3]);
        result = (short[])parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((int)258, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)772, (int)result[1]);
        SimpleParameterTestcase.assertEquals((int)1027, (int)result[2]);
        SimpleParameterTestcase.assertEquals((int)513, (int)result[3]);
        result = (short[])parameter.decode((Object)bytes);
        SimpleParameterTestcase.assertEquals((int)258, (int)result[0]);
        SimpleParameterTestcase.assertEquals((int)772, (int)result[1]);
        SimpleParameterTestcase.assertEquals((int)1027, (int)result[2]);
        SimpleParameterTestcase.assertEquals((int)513, (int)result[3]);
    }

    public void testDecodeStringInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        AsciiMessage message = new AsciiMessage("1234");
        Object result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(1234), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        message = new AsciiMessage("0123");
        result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(123), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        message = new AsciiMessage("0x23");
        result = parameter.decode((Object)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(35), (Object)result);
        result = parameter.decode((Object)"0x23");
        SimpleParameterTestcase.assertEquals((Object)new Integer(35), (Object)result);
    }

    public void testDecodeValueInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        AsciiMessage message = new AsciiMessage("1234");
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(1234), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        message = new AsciiMessage("0123");
        result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(123), (Object)result);
        parameter = new SimpleParameter(EMPTY_STRING, null, 0, 4, 128);
        message = new AsciiMessage("0x23");
        result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(35), (Object)result);
    }

    public void testEncodeBytesInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        Object result = parameter.encode((Object)new byte[]{90, -1, -1}, (Object)new Integer(1));
        byte[] good = new byte[]{90, 1, -1};
        byte[] resultBytes = (byte[])result;
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeLong() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 225);
        byte[] byArray = new byte[9];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Long(Long.MAX_VALUE));
        byte[] good = new byte[]{90, 127, -1, -1, -1, -1, -1, -1, -1};
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeMessageInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        Object result = parameter.encode((Object)new Message(new byte[]{90, -1, -1}), (Object)new Integer(1));
        byte[] good = new byte[]{90, 1, -1};
        byte[] resultBytes = ((MessageService)result).getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueBytes() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 80);
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        byArray[2] = -1;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new byte[]{1, 2, 3, 4});
        byte[] byArray2 = new byte[7];
        byArray2[0] = -1;
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[6] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueHexAscii() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 9, 0, 212);
        AsciiMessage message = new AsciiMessage("output=0x\r\n");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(17));
        byte[] good = "output=0x11\r\n".getBytes();
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueHexString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 9, 0, 196);
        AsciiMessage message = new AsciiMessage("output=0x\r\n");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(17));
        byte[] good = "output=0x11\r\n".getBytes();
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(1));
        byte[] good = new byte[]{90, 1, -1};
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueInteger8() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        byte[] byArray2 = new byte[3];
        byArray2[0] = 90;
        byArray2[1] = 2;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueIntegerArray() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 9);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new int[]{1, 2});
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[4] = 1;
        byArray2[8] = 2;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueLongArray() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 16, 233);
        byte[] byArray = new byte[18];
        byArray[0] = 90;
        byArray[17] = -1;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new long[]{0x100000001L, 0x200000002L});
        byte[] byArray2 = new byte[18];
        byArray2[0] = 90;
        byArray2[4] = 1;
        byArray2[8] = 1;
        byArray2[12] = 2;
        byArray2[16] = 2;
        byArray2[17] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueNascii() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 132);
        AsciiMessage message = new AsciiMessage("023");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(1));
        byte[] good = "0123".getBytes();
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueShortArray() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 41);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new short[]{1, 2, 3, 4});
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[2] = 1;
        byArray2[4] = 2;
        byArray2[6] = 3;
        byArray2[8] = 4;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueShortArrayLittle() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 42);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new short[]{1, 2, 3, 4});
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[1] = 1;
        byArray2[3] = 2;
        byArray2[5] = 3;
        byArray2[7] = 4;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i = 0;
        while (i < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i], (byte)resultBytes[i]);
            ++i;
        }
    }

    public void testEncodeValueShortArrayLittleList() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 42);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        Vector<Short> list = new Vector<Short>();
        int i = 1;
        while (i <= 4) {
            list.add(new Short((short)i));
            ++i;
        }
        MessageService result = parameter.encodeValue((MessageService)message, list);
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[1] = 1;
        byArray2[3] = 2;
        byArray2[5] = 3;
        byArray2[7] = 4;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i2 = 0;
        while (i2 < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i2], (byte)resultBytes[i2]);
            ++i2;
        }
    }

    public void testEncodeValueShortArrayLittleListHexString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 42);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        Vector<String> list = new Vector<String>();
        int i = 1;
        while (i <= 4) {
            list.add("0x" + Integer.toString((short)i, 16));
            ++i;
        }
        MessageService result = parameter.encodeValue((MessageService)message, list);
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[1] = 1;
        byArray2[3] = 2;
        byArray2[5] = 3;
        byArray2[7] = 4;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i2 = 0;
        while (i2 < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i2], (byte)resultBytes[i2]);
            ++i2;
        }
    }

    public void testEncodeValueShortArrayLittleListString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 8, 42);
        byte[] byArray = new byte[10];
        byArray[0] = 90;
        byArray[9] = -1;
        Message message = new Message(byArray);
        Vector<String> list = new Vector<String>();
        int i = 1;
        while (i <= 4) {
            list.add(Integer.toString((short)i));
            ++i;
        }
        MessageService result = parameter.encodeValue((MessageService)message, list);
        byte[] byArray2 = new byte[10];
        byArray2[0] = 90;
        byArray2[1] = 1;
        byArray2[3] = 2;
        byArray2[5] = 3;
        byArray2[7] = 4;
        byArray2[9] = -1;
        byte[] good = byArray2;
        byte[] resultBytes = result.getBytes();
        int i2 = 0;
        while (i2 < good.length) {
            SimpleParameterTestcase.assertEquals((byte)good[i2], (byte)resultBytes[i2]);
            ++i2;
        }
    }

    public void testHexstring() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 196);
        Message message = new Message("0");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Long(291L));
        SimpleParameterTestcase.assertEquals((Object)new Message("0123"), (Object)result);
    }

    public void testInteger() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)new Integer(10), (Object)result);
    }

    public void testString() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 68);
        Message message = new Message("0");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"123");
        SimpleParameterTestcase.assertEquals((Object)new Message("0123"), (Object)result);
    }

    public void testString2() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 68);
        Message message = new Message("0");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"123");
        SimpleParameterTestcase.assertEquals((Object)new Message("0123"), (Object)result);
    }

    public void testStringBytes() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 68);
        Message message = new Message("0");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new byte[]{49, 50, 51});
        SimpleParameterTestcase.assertEquals((Object)new Message("0123"), (Object)result);
    }

    public void testStringDecode() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 3, 64);
        AsciiMessage message = new AsciiMessage("0123");
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testStringDecodeInsert() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 68);
        AsciiCrlfMessage message = new AsciiCrlfMessage("0123\r\n");
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testStringDecodeInsert2() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 0, 116);
        AsciiCrlfMessage message = new AsciiCrlfMessage("0123\r\n");
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)"123", (Object)result);
    }

    public void testStringMany() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 1, 68);
        Message message = new Message("09");
        MessageService result = parameter.encodeValue((MessageService)message, (Object)"123");
        SimpleParameterTestcase.assertEquals((Object)new Message("12309"), (Object)result);
    }

    public void testStringMany2() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 0, 1, 68);
        SimpleParameter parameter2 = new SimpleParameter(EMPTY_STRING, null, 1, 1, 68);
        Parameters parameters = new Parameters("", new ParameterService[]{parameter, parameter2});
        Message message = new Message("09");
        Object[] data = new Object[]{"123", "456"};
        MessageService result = parameters.encodeValue((MessageService)message, (Object)data);
        SimpleParameterTestcase.assertEquals((Object)new Message("12304569"), (Object)result);
    }

    public void testTrue() {
        SimpleParameter parameter = new SimpleParameter(EMPTY_STRING, null, 1, 1, 48);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        byArray[1] = 8;
        Message message = new Message(byArray);
        Object result = parameter.decodeValue((MessageService)message);
        SimpleParameterTestcase.assertEquals((Object)Boolean.TRUE, (Object)result);
    }
}

