/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.script.testcase;

import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.script.ScriptManager;
import org.eclipse.soda.dk.script.service.FilterScriptService;

public class FilterScriptTestcase
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.script.testcase.FilterScriptTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public FilterScriptTestcase() {
    }

    public FilterScriptTestcase(String name) {
        super(name);
    }

    public void test01() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("(\"false\" = \"true\")", "");
        Hashtable variables = new Hashtable();
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test02() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("(a = \"false\")", "");
        Hashtable<String, Boolean> variables = new Hashtable<String, Boolean>();
        variables.put("a", Boolean.FALSE);
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test03() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("(i = 3)", "");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)true, (boolean)result);
    }

    public void test11() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("false;", "js");
        Hashtable variables = new Hashtable();
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test12() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("a;", "js");
        Hashtable<String, Boolean> variables = new Hashtable<String, Boolean>();
        variables.put("a", Boolean.FALSE);
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)false, (boolean)result);
    }

    public void test13() {
        ScriptManager scriptManager = ScriptManager.getInstance();
        FilterScriptService filterScript = scriptManager.createFilterScript("i == 3;", "js");
        Hashtable<String, Integer> variables = new Hashtable<String, Integer>();
        variables.put("i", new Integer(3));
        boolean result = filterScript.evaluateFilter(variables);
        FilterScriptTestcase.assertEquals((boolean)true, (boolean)result);
    }
}

