/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.data.Degree;

public class LocationTestcase
extends TestCase {
    private Degree location;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        System.out.println(9223372036L);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.data.testcase.LocationTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public LocationTestcase(String name) {
        super(name);
    }

    public void test1() {
        this.location = new Degree("1.100000");
        LocationTestcase.assertEquals((String)"1.1", (String)this.location.toString());
    }

    public void test10() {
        System.out.println("Nmea string: " + Degree.toDegreeString((int)149477141, (String)""));
    }

    public void test11() {
        int bLocation = Degree.parseMetarDegree((String)"12-34-56");
        LocationTestcase.assertEquals((String)"12\u00ef\u00bf\u00bd34'56\"", (String)Degree.toDegreeString((int)bLocation, (String)""));
    }

    public void test12() {
        int bLocation = Degree.parseMetarDegree((String)"12-34-56.123");
        LocationTestcase.assertEquals((String)"12\u00ef\u00bf\u00bd34'56.123\"", (String)Degree.toDegreeString((int)bLocation, (String)""));
    }

    public void test13() {
        int bLocation = Degree.parseBillionDegree((String)"123.12345");
        LocationTestcase.assertEquals((String)"123.12345", (String)Degree.toString((int)bLocation));
    }

    public void test14() {
        Degree bLocation = new Degree("123.123456789");
        LocationTestcase.assertEquals((float)123.12346f, (float)bLocation.floatValue(), (float)0.0f);
    }

    public void test15() {
        Degree bLocation = new Degree(123, 30, 0);
        LocationTestcase.assertEquals((float)123.5f, (float)bLocation.floatValue(), (float)0.0f);
    }

    public void test16() {
        long bLocation = new Degree(123, 30, 0).longNumerator();
        double result = (double)bLocation / 3600000.0;
        System.out.println("test16 " + bLocation + ' ' + 3600000.0);
        System.out.println("Test16 answer: " + result);
    }

    public void test2() {
        this.location = new Degree(".1");
        LocationTestcase.assertEquals((String)".1", (String)this.location.toString());
    }

    public void test3() {
        this.location = new Degree("123.456");
        LocationTestcase.assertEquals((String)"123.456", (String)this.location.toString());
    }

    public void test4() {
        this.location = new Degree(".12345");
        LocationTestcase.assertEquals((String)".12345", (String)this.location.toString());
    }

    public void test5() {
        int bLocation = Degree.parseBillionDegree((String)"1230.0");
        System.out.println("Nmea answer: " + Degree.toString((int)bLocation));
    }

    public void test7() {
        LocationTestcase.assertEquals((String)"122\u00ef\u00bf\u00bd2'18.456\"", (String)Degree.toDegreeString((int)439338456, (String)""));
    }

    public void test8() {
        System.out.println("Nmea string: " + Degree.toDegreeString((int)0, (String)""));
        LocationTestcase.assertEquals((String)"0\u00ef\u00bf\u00bd", (String)Degree.toDegreeString((int)0, (String)""));
    }

    public void test9() {
        System.out.println("Nmea string: " + Degree.toDegreeString((int)1800000, (String)""));
        LocationTestcase.assertEquals((String)"0\u00ef\u00bf\u00bd30'", (String)Degree.toDegreeString((int)1800000, (String)""));
    }
}

