/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;

public class EscConfiguration
implements ConfigurationService {
    private static ConfigurationService Configuration = new EscConfiguration();
    public static final String[] FALSE_VALUES = new String[]{"0", "false"};
    private static final String NAME = "esc.properties";
    public static final String[] TRUE_VALUES = new String[]{"1", "true"};
    private Dictionary properties;

    public static final Boolean booleanObject(Object data) {
        if (EscConfiguration.booleanValue(data)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static final boolean booleanValue(Object data) {
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        if (data instanceof Number) {
            return ((Number)data).longValue() != 0L;
        }
        if (data != null) {
            String dataString = data.toString();
            int i = 0;
            while (i < TRUE_VALUES.length) {
                if (dataString.equals(TRUE_VALUES[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < FALSE_VALUES.length) {
                if (dataString.equals(FALSE_VALUES[i])) {
                    return false;
                }
                ++i;
            }
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final byte[] bytesValue(Object data) {
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof Number) {
            return new byte[]{((Number)data).byteValue()};
        }
        if (data != null) {
            String dataString = data.toString();
            StringTokenizer tokenizer = new StringTokenizer(dataString, " ");
            byte[] result = new byte[tokenizer.countTokens()];
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                result[index] = token.startsWith("0x") ? Byte.parseByte(token.substring(2), 16) : Byte.parseByte(token, 16);
            }
            return result;
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final byte byteValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).byteValue();
        }
        if (data != null) {
            String dataString = data.toString();
            if (dataString.startsWith("0x")) {
                return Byte.parseByte(dataString.substring(2), 16);
            }
            return Byte.parseByte(dataString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final double doubleValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data != null) {
            String dataString = data.toString();
            return Double.parseDouble(dataString);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final float floatValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).floatValue();
        }
        if (data != null) {
            String dataString = data.toString();
            return Float.parseFloat(dataString);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static ConfigurationService getConfiguration() {
        return Configuration;
    }

    public static final int intValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        if (data != null) {
            String dataString = data.toString();
            if (dataString.startsWith("0x")) {
                return Integer.parseInt(dataString.substring(2), 16);
            }
            return Integer.parseInt(dataString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final List listObject(Object data) {
        if (data != null) {
            if (data instanceof List) {
                return (List)data;
            }
            if (data instanceof Object[]) {
                Object[] objects = (Object[])data;
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < objects.length) {
                    list.add(objects[i]);
                    ++i;
                }
                return list;
            }
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final long longValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).longValue();
        }
        if (data != null) {
            String dataString = data.toString();
            if (dataString.startsWith("0x")) {
                return Long.parseLong(dataString.substring(2), 16);
            }
            return Long.parseLong(dataString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final Map mapObject(Object data) {
        if (data != null) {
            if (data instanceof Map) {
                return (Map)data;
            }
            Properties properties = new Properties();
            ByteArrayInputStream is = new ByteArrayInputStream(data.toString().getBytes());
            try {
                properties.load(is);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(String.valueOf(data));
            }
            return properties;
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static void setConfiguration(ConfigurationService configuration) {
        Configuration = configuration;
    }

    public static final short shortValue(Object data) {
        if (data instanceof Number) {
            return ((Number)data).shortValue();
        }
        if (data != null) {
            String dataString = data.toString();
            if (dataString.startsWith("0x")) {
                return Short.parseShort(dataString.substring(2), 16);
            }
            return Short.parseShort(dataString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public static final String stringObject(Object data) {
        if (data != null) {
            return data.toString();
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    public EscConfiguration() {
        this.properties = this.getDefaultProperties();
    }

    public EscConfiguration(Dictionary properties) {
        this.properties = properties;
    }

    public boolean getBoolean(String key, boolean defaultBoolean) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.booleanValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultBoolean;
    }

    public byte getByte(String key, byte defaultByte) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.byteValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultByte;
    }

    protected Properties getDefaultProperties() {
        Properties result = new Properties();
        try {
            FileInputStream stream = new FileInputStream(NAME);
            BufferedInputStream bstream = new BufferedInputStream(stream);
            result.load(bstream);
            bstream.close();
        }
        catch (Exception exception) {}
        return result;
    }

    public double getDouble(String key, double defaultDouble) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.doubleValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultDouble;
    }

    public float getFloat(String key, float defaultFloat) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.floatValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultFloat;
    }

    public int getInt(String key, int defaultInt) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.intValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultInt;
    }

    public long getLong(String key, long defaultLong) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.longValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultLong;
    }

    public Object getObject(String key, Object defaultObject) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value != null) {
                return value;
            }
            Object systemValue = System.getProperties().get(key);
            if (systemValue != null) {
                return systemValue;
            }
        }
        return defaultObject;
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = properties.get(key);
            if (value != null) {
                return value;
            }
            int index = key.indexOf(46, 0);
            if (index >= 0) {
                return this.getProperty(key.substring(index + 1));
            }
        }
        return null;
    }

    public short getShort(String key, short defaultShort) {
        Dictionary properties = this.getProperties();
        if (properties != null) {
            Object value = this.getProperty(key);
            if (value == null) {
                value = System.getProperties().get(key);
            }
            if (value != null) {
                try {
                    return EscConfiguration.shortValue(value);
                }
                catch (RuntimeException exception) {
                    EscObject.handleStaticException(exception);
                }
            }
        }
        return defaultShort;
    }

    public String getString(String key, String defaultString) {
        Object value;
        Dictionary properties = this.getProperties();
        if (properties != null && (value = this.getProperty(key)) != null) {
            return value.toString();
        }
        return System.getProperty(key, defaultString);
    }

    public void put(String key, Object value) {
        Dictionary properties = this.getProperties();
        if (properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
    }

    public String toString() {
        if (this.properties != null) {
            StringBuffer buffer = new StringBuffer(1024);
            Nls.formatData(buffer, this.properties);
            return buffer.toString();
        }
        return super.toString();
    }
}

