/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObjectResourceBundle;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.service.log.LogService;

public abstract class EscObject {
    public static final String ID_KEY = "id";
    public static final String ID_NAME_KEY = "idname";
    public static final String ID_FILTER_KEY = "idimportfilter";
    public static final String ID_KEY_ANY = "#";
    public static final String KEY_KEY = "key";
    public static final String PREFIX_KEY = "prefix";
    public static final String LOG_LEVEL_KEY = "loglevel";
    public static final String[] TO_STRING_CONFIGURATION_KEYS = new String[]{"id"};
    public static final int LOG_DEFAULT = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_TRACE = 5;
    public static final int TRACE_LEVEL_NONE = 0;
    public static final int TRACE_LEVEL_MIN = 1;
    public static final int TRACE_LEVEL_LOW = 3;
    public static final int TRACE_LEVEL_NORMAL = 5;
    public static final int TRACE_LEVEL_HIGH = 7;
    public static final int TRACE_LEVEL_MAX = 10;
    public static final String EMPTY_STRING = "";
    public static final String TRACELEVEL_KEY = "esc.tracelevel";
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int INTEGER_TABLE_SIZE = 512;
    public static final Integer[] INTEGER_TABLE = EscObject.createIntegerTable(512);
    public static final int LONG_TABLE_SIZE = 32;
    public static final Long[] LONG_TABLE = EscObject.createLongTable(32);
    private static final int[] LOG_LEVELS;
    private static final String VM_LIBRARY_VERSION;
    public static final int UNKNOWN_ERROR_RESOURCE = 0;
    public static final int ERROR_OCCURRED_EXCEPTION_RESOURCE = 1;
    public static final int SLEEP_EXCEPTION_RESOURCE = 2;
    public static final int CLONE_EXCEPTION_RESOURCE = 3;
    public static final int SYSTEM_INFO_RESOURCE = 4;
    public static final Map READONLY_EMPTY_MAP;
    public static final List READONLY_EMPTY_LIST;
    public static final List READONLY_EMPTY_COLLECTION;
    private static boolean Debug;
    private static ResourceBundle DefaultResourceBundle;
    private static LogService DefaultLogService;
    private static String[] LogLevelStrings;
    private static int LogLevel;
    private static int TraceLevel;
    private static Long CurrentTimestamp;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        LOG_LEVELS = nArray;
        VM_LIBRARY_VERSION = System.getProperty("com.ibm.oti.vm.library.version", "22");
        READONLY_EMPTY_MAP = Collections.unmodifiableMap(Collections.EMPTY_MAP);
        READONLY_EMPTY_LIST = Collections.unmodifiableList(Collections.EMPTY_LIST);
        READONLY_EMPTY_COLLECTION = Collections.unmodifiableList(Collections.EMPTY_LIST);
        Debug = EscObject.getStaticBoolean("esc.debug", false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.core.EscObjectResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle(clazz);
        DefaultLogService = EscObject.createDefaultLogService();
        LogLevelStrings = new String[]{"default", "error", "warning", "info", "debug", "trace"};
        LogLevel = EscObject.getDefaultLogLevel();
        TraceLevel = EscObject.getStaticInt(TRACELEVEL_KEY, 0);
        CurrentTimestamp = EscObject.startupEscStatic();
    }

    public static LogService createDefaultLogService() {
        return LogUtility.getInstance().getLog();
    }

    public static Integer createInteger(int value) {
        if (value < 512 && value >= -512) {
            return INTEGER_TABLE[value + 512];
        }
        return new Integer(value);
    }

    protected static final Integer[] createIntegerTable(int size) {
        Integer[] table = new Integer[size << 1];
        int i = 0;
        while (i < size << 1) {
            table[i] = new Integer(i - size);
            ++i;
        }
        return table;
    }

    public static Long createLong(long value) {
        if (value < 32L && value >= -32L) {
            return LONG_TABLE[(int)value + 32];
        }
        return new Long(value);
    }

    protected static final Long[] createLongTable(int size) {
        Long[] table = new Long[size << 1];
        int i = 0;
        while (i < size << 1) {
            table[i] = new Long(i - size);
            ++i;
        }
        return table;
    }

    public static Number createNumber(long value) {
        if (value < 512L && value >= -512L) {
            return INTEGER_TABLE[(int)value + 512];
        }
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new Integer((int)value);
        }
        return new Long(value);
    }

    public static Object getCurrentTimestamp() {
        long time = System.currentTimeMillis();
        if (time != CurrentTimestamp) {
            CurrentTimestamp = new Long(time);
        }
        return CurrentTimestamp;
    }

    private static int getDefaultLogLevel() {
        String log = EscObject.getStaticString("esc.loglevel", "default");
        int i = 0;
        while (i < LogLevelStrings.length) {
            if (log.equals(LogLevelStrings[i])) {
                return LOG_LEVELS[i];
            }
            ++i;
        }
        return 0;
    }

    public static LogService getDefaultLogService() {
        return DefaultLogService;
    }

    public static String getDefaultResource(int resourceId) {
        return DefaultResourceBundle.getString(Integer.toString(resourceId));
    }

    public static String getLoadLibraryName(String baseName) {
        int length = baseName.length() + 2;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(baseName);
        buffer.append(EscObject.getVmLibraryVersion());
        return buffer.toString();
    }

    public static final Collection getReadOnlyEmptyCollection() {
        return READONLY_EMPTY_COLLECTION;
    }

    public static final List getReadOnlyEmptyList() {
        return READONLY_EMPTY_LIST;
    }

    public static final Map getReadOnlyEmptyMap() {
        return READONLY_EMPTY_MAP;
    }

    public static boolean getStaticBoolean(String key, boolean defaultBoolean) {
        return EscConfiguration.getConfiguration().getBoolean(key, defaultBoolean);
    }

    public static float getStaticFloat(String key, float defaultFloat) {
        return EscConfiguration.getConfiguration().getFloat(key, defaultFloat);
    }

    public static int getStaticInt(String key, int defaultInt) {
        return EscConfiguration.getConfiguration().getInt(key, defaultInt);
    }

    public static long getStaticLong(String key, long defaultLong) {
        return EscConfiguration.getConfiguration().getLong(key, defaultLong);
    }

    public static Object getStaticObject(String key, Object defaultObject) {
        return EscConfiguration.getConfiguration().getObject(key, defaultObject);
    }

    public static String getStaticString(String key, String defaultString) {
        return EscConfiguration.getConfiguration().getString(key, defaultString);
    }

    public static int getTraceLevel() {
        return TraceLevel;
    }

    public static String getVmLibraryVersion() {
        return VM_LIBRARY_VERSION;
    }

    public static void handleStaticError(String string) {
        EscObject.getDefaultLogService().log(1, string);
    }

    public static void handleStaticException(Throwable exception) {
        EscObject.getDefaultLogService().log(1, exception.getMessage(), exception);
    }

    public static boolean isDebug() {
        return Debug;
    }

    public static boolean isTrace() {
        return TraceLevel > 0;
    }

    public static Object loadService(String serviceName, String defaultClassName) throws RuntimeException {
        try {
            String className = EscObject.getStaticString(serviceName, defaultClassName);
            Class<?> implementationClass = Class.forName(className);
            return implementationClass.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void setDebug(boolean debug) {
        Debug = debug;
    }

    public static void setDefaultLogService(LogService defaultLogService) {
        DefaultLogService = defaultLogService == null ? LogUtility.getInstance().getLog() : defaultLogService;
    }

    public static void setTraceLevel(int traceLevel) {
        TraceLevel = traceLevel;
    }

    public static boolean shouldLog(int code) {
        int logLevel = LogLevel;
        if (logLevel == 0) {
            logLevel = LogUtility.getLoggingLevel();
        }
        if (code <= logLevel) {
            return Math.min(code, 4) <= LogUtility.getLoggingLevel();
        }
        return false;
    }

    public static Long startupEscStatic() {
        ConfigurableObject object = new ConfigurableObject();
        object.setConfigurationService(EscConfiguration.getConfiguration());
        object.reportSystemInfo();
        return new Long(System.currentTimeMillis());
    }

    protected EscObject() {
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        return true;
    }

    public RuntimeException createException(int resourceId) {
        return new RuntimeException(this.getResource(resourceId));
    }

    public RuntimeException createException(int resourceId, Object[] objects) {
        return new RuntimeException(Nls.format(this.getResource(resourceId), objects));
    }

    public String format(int resourceId, Object object) {
        return Nls.format(this.getResource(resourceId), new Object[]{object});
    }

    public boolean getBoolean(String key, boolean defaultBoolean) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getBoolean(key, EscObject.getStaticBoolean(key, defaultBoolean));
        }
        return EscObject.getStaticBoolean(key, defaultBoolean);
    }

    public ConfigurationService getConfigurationService() {
        return null;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 0: 
            case 1: 
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 3;
    }

    public float getFloat(String key, float defaultFloat) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getFloat(key, EscObject.getStaticFloat(key, defaultFloat));
        }
        return EscObject.getStaticFloat(key, defaultFloat);
    }

    public String getId() {
        return this.getString(ID_KEY, EMPTY_STRING);
    }

    public String getIdName() {
        return this.getString(ID_NAME_KEY, this.getId());
    }

    public int getInt(String key, int defaultInt) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getInt(key, EscObject.getStaticInt(key, defaultInt));
        }
        return EscObject.getStaticInt(key, defaultInt);
    }

    public Object[] getLogDetails(Throwable error, Object details, Object details1, Object details2, Object details3) {
        return new Object[]{this.getLogDetails0(), this.getLogDetails1(), this.getLogDetails2(), this.getLogDetails3(), this.getLogDetails4(), this.getLogDetails5(), this.getLogDetails6(), this.getLogDetails7(), error, details, details1, details2, details3};
    }

    public Object getLogDetails0() {
        return String.valueOf(this);
    }

    public Object getLogDetails1() {
        return String.valueOf(this.getClass().getName());
    }

    public Object getLogDetails2() {
        return null;
    }

    public Object getLogDetails3() {
        return null;
    }

    public Object getLogDetails4() {
        return null;
    }

    public Object getLogDetails5() {
        return null;
    }

    public Object getLogDetails6() {
        return this.getConfigurationService();
    }

    public Object getLogDetails7() {
        return System.getProperties();
    }

    public int getLogLevel() {
        int logLevel = LogLevel;
        if (logLevel == 0) {
            return LogUtility.getLoggingLevel();
        }
        return LogLevel;
    }

    public LogService getLogService() {
        return EscObject.getDefaultLogService();
    }

    public long getLong(String key, long defaultLong) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getLong(key, EscObject.getStaticLong(key, defaultLong));
        }
        return EscObject.getStaticLong(key, defaultLong);
    }

    public Object getObject(String key, Object defaultObject) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getObject(key, EscObject.getStaticObject(key, defaultObject));
        }
        return EscObject.getStaticObject(key, defaultObject);
    }

    public String getOutputName() {
        String outputName = super.toString();
        int index = outputName.lastIndexOf(46);
        if (index > 0) {
            return outputName.substring(index + 1);
        }
        return outputName;
    }

    public String getResource(int resourceId) {
        return DefaultResourceBundle.getString(EscObjectResourceBundle.getKey(resourceId));
    }

    public String getSimpleClassName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index > 0) {
            return className.substring(index + 1);
        }
        return className;
    }

    public String getString(String key, String defaultString) {
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null) {
            return configurationService.getString(key, EscObject.getStaticString(key, defaultString));
        }
        return EscObject.getStaticString(key, defaultString);
    }

    public void handleError(Throwable error, int resourceId) {
        this.handleErrorInternal(error, resourceId, this.getLogDetails(error, null, null, null, null));
    }

    public void handleError(Throwable error, int resourceId, Object details) {
        this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details, null, null, null));
    }

    public void handleError(Throwable error, int resourceId, Object details, Object details2) {
        this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details, details2, null, null));
    }

    protected void handleError(Throwable error, int resourceId, Object[] details) {
        if (details == null) {
            this.handleError(error, resourceId);
            return;
        }
        int size = details.length;
        switch (size) {
            case 0: {
                this.handleError(error, resourceId);
                return;
            }
            case 1: {
                this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details[0], null, null, null));
                return;
            }
            case 2: {
                this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details[0], details[1], null, null));
                return;
            }
            case 3: {
                this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details[0], details[1], details[2], null));
                return;
            }
            case 4: {
                this.handleErrorInternal(error, resourceId, this.getLogDetails(error, details[0], details[1], details[2], details[3]));
                return;
            }
        }
    }

    protected void handleErrorInternal(Throwable error, int resourceId, Object[] objects) {
        this.reportError(resourceId, error, objects);
    }

    public boolean isLogging(int severity) {
        int logLevel = this.getLogLevel();
        if (severity <= logLevel) {
            return Math.min(severity, 4) <= LogUtility.getLoggingLevel();
        }
        return false;
    }

    public void log(int severity, String message) {
        if (this.isLogging(severity)) {
            this.log(severity, message, null);
        }
    }

    public void log(int severity, String message, Throwable exception) {
        if (this.isLogging(severity)) {
            LogService logService = this.getLogService();
            if (logService != null) {
                try {
                    logService.log(severity, message, exception);
                }
                catch (RuntimeException runtimeException) {}
            } else if (EscObject.isDebug() && exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public void log(Throwable error, int resourceId) {
        int severity = this.getErrorSeverity(resourceId, error);
        if (this.isLogging(severity)) {
            Object[] errorObjects = this.getLogDetails(error, null, null, null, null);
            String message = Nls.format(this.getResource(resourceId), errorObjects);
            this.log(severity, message, error);
        }
    }

    public void report(int reportNumber, Object[] errorObjects) {
        int severity = this.getErrorSeverity(reportNumber, null);
        if (this.isLogging(severity)) {
            if (severity > 4) {
                this.log(4, Nls.format(this.getResource(reportNumber), errorObjects), null);
            } else {
                this.log(severity, Nls.format(this.getResource(reportNumber), errorObjects), null);
            }
            return;
        }
    }

    public void report(Throwable error, int resourceId) {
        this.report(resourceId, this.getLogDetails(error, null, null, null, null));
    }

    public void report(Throwable error, int resourceId, Object details) {
        this.report(resourceId, this.getLogDetails(error, details, null, null, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1) {
        this.report(resourceId, this.getLogDetails(error, details, details1, null, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1, Object details2) {
        this.report(resourceId, this.getLogDetails(error, details, details1, details2, null));
    }

    public void report(Throwable error, int resourceId, Object details, Object details1, Object details2, Object details3) {
        this.report(resourceId, this.getLogDetails(error, details, details1, details2, details3));
    }

    protected void reportError(int errorNumber, Throwable error, Object[] errorObjects) throws RuntimeException {
        int errorSeverity = this.getErrorSeverity(errorNumber, error);
        if (this.attemptRecoveryFromError(errorNumber, error)) {
            if (this.isLogging(errorSeverity)) {
                this.log(this.getErrorSeverity(errorNumber, error), Nls.format(this.getResource(errorNumber), errorObjects), error);
            }
            return;
        }
        String message = Nls.format(this.getResource(errorNumber), errorObjects);
        this.log(errorSeverity, message, error);
        if (error != null) {
            throw new RuntimeException(error.getMessage());
        }
        throw new RuntimeException(message);
    }

    public void reportSystemInfo() {
        this.report(null, 4);
    }

    public void setLogService(LogService logService) {
        EscObject.setDefaultLogService(logService);
    }

    public void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getOutputName());
        this.toStringInfo(buffer);
        return buffer.toString();
    }

    public String[] toStringConfigurationKeys() {
        return TO_STRING_CONFIGURATION_KEYS;
    }

    public void toStringInfo(StringBuffer buffer) {
        Dictionary configuration;
        ConfigurationService configurationService = this.getConfigurationService();
        if (configurationService != null && (configuration = configurationService.getProperties()) != null) {
            String[] configurationKeys = this.toStringConfigurationKeys();
            if (configurationKeys == null) {
                buffer.append(configuration);
            } else {
                int count = 0;
                int i = 0;
                while (i < configurationKeys.length) {
                    String key = configurationKeys[i];
                    Object value = configuration.get(key);
                    if (value != null) {
                        buffer.append(',');
                        buffer.append(key);
                        buffer.append('=');
                        buffer.append(value);
                        ++count;
                    }
                    ++i;
                }
                if (count == 0) {
                    Nls.formatData(buffer, configuration);
                }
            }
        }
    }
}

