/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.interest;

import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.message.service.MessageService;

public class InterestMasks
extends InterestMask {
    public static final InterestService[] EMPTY_INTEREST_SERVICE_ARRAY = new InterestService[0];
    private InterestService[] interestMasks = EMPTY_INTEREST_SERVICE_ARRAY;

    public InterestMasks() {
    }

    public InterestMasks(InterestService interestService) {
        this.add(interestService);
    }

    public InterestMasks(InterestService[] interestServices) {
        this.setInterestMasks(interestServices);
    }

    public void add(InterestService interestService) {
        InterestService[] oldList = this.interestMasks;
        InterestService[] objects = new InterestService[oldList.length + 1];
        System.arraycopy(oldList, 0, objects, 0, oldList.length);
        objects[oldList.length] = interestService;
        this.interestMasks = objects;
        this.computeMasks();
    }

    public void computeMasks() {
        int length = this.interestMasks.length;
        switch (length) {
            case 0: {
                this.setPatternMask(DEFAULT_MASK);
                this.setCareMask(DEFAULT_MASK);
                break;
            }
            case 1: {
                byte[] patternMask = this.interestMasks[0].getPatternMask();
                byte[] careMask = this.interestMasks[0].getCareMask();
                this.setPatternMask(patternMask);
                this.setCareMask(careMask);
                break;
            }
            default: {
                int size = this.interestMasks[0].getPatternMask().length;
                int i = 1;
                while (i < length) {
                    int tsize = this.interestMasks[i].getPatternMask().length;
                    if (tsize < size) {
                        size = tsize;
                    }
                    ++i;
                }
                byte[] orMask = new byte[size];
                byte[] andMask = new byte[size];
                int i2 = 1;
                while (i2 < size) {
                    andMask[i2] = -1;
                    ++i2;
                }
                int byteLength = orMask.length;
                int i3 = 0;
                while (i3 < length) {
                    byte[] patternMask = this.interestMasks[i3].getPatternMask();
                    byte[] careMask = this.interestMasks[i3].getCareMask();
                    int j = 0;
                    while (j < byteLength) {
                        andMask[j] = (byte)(andMask[j] & patternMask[j]);
                        orMask[j] = (byte)(orMask[j] | (patternMask[j] | ~careMask[j]));
                        ++j;
                    }
                    ++i3;
                }
                int j = 0;
                while (j < byteLength) {
                    orMask[j] = (byte)(orMask[j] ^ andMask[j]);
                    orMask[j] = ~orMask[j];
                    ++j;
                }
                int newLength = byteLength - 1;
                while (newLength >= 0) {
                    if (orMask[newLength] != 0) break;
                    --newLength;
                }
                if (newLength > 0 && newLength < byteLength - 1) {
                    byte[] newList = new byte[newLength + 1];
                    System.arraycopy(andMask, 0, newList, 0, newLength + 1);
                    andMask = newList;
                    newList = new byte[newLength + 1];
                    System.arraycopy(orMask, 0, newList, 0, newLength + 1);
                    orMask = newList;
                }
                this.setPatternMask(andMask);
                this.setCareMask(orMask);
            }
        }
    }

    public InterestService[] getInterestMasks() {
        return this.interestMasks;
    }

    public boolean isInterested(MessageService message) {
        boolean result = super.isInterested(message);
        int length = this.interestMasks.length;
        if (result && length > 1) {
            int i = 0;
            while (i < length) {
                if (this.interestMasks[i].isInterested(message)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return result;
    }

    public boolean isInterested(byte[] bytes) {
        boolean result = super.isInterested(bytes);
        int length = this.interestMasks.length;
        if (result && length > 1) {
            int i = 0;
            while (i < length) {
                if (this.interestMasks[i].isInterested(bytes)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return result;
    }

    public void remove(InterestService interestService) {
        InterestService[] oldList = this.interestMasks;
        int index = oldList.length - 1;
        while (index >= 0) {
            if (oldList[index] == interestService) {
                InterestService[] newList = new InterestService[oldList.length - 1];
                if (index == oldList.length - 1) {
                    System.arraycopy(oldList, 0, newList, 0, newList.length);
                } else {
                    if (index > 0) {
                        System.arraycopy(oldList, 0, newList, 0, index);
                    }
                    System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                }
                this.interestMasks = newList;
            }
            --index;
        }
        this.computeMasks();
    }

    public void setInterestMasks(InterestService[] interestMasks) {
        this.interestMasks = interestMasks;
        this.computeMasks();
    }
}

