/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.message;

import java.util.Arrays;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class Message
implements MessageService,
Cloneable {
    public static final char[] POINTER_CHARS = " <- ".toCharArray();
    private byte[] bytes;

    public static int getIntByte(byte[] buffer, int offset) {
        return buffer[offset] & 0xFF;
    }

    public static long getLittleEndianInt(byte[] buffer, int offset) {
        return Message.getIntByte(buffer, offset) + (Message.getIntByte(buffer, offset + 1) << 8) + (Message.getIntByte(buffer, offset + 2) << 16) + (Message.getIntByte(buffer, offset + 3) << 24);
    }

    public static long getLittleEndianLong(byte[] buffer, int offset) {
        return Message.getLongByte(buffer, offset) + (Message.getLongByte(buffer, offset + 1) << 8) + (Message.getLongByte(buffer, offset + 2) << 16) + (Message.getLongByte(buffer, offset + 3) << 24) + (Message.getLongByte(buffer, offset + 4) << 32) + (Message.getLongByte(buffer, offset + 5) << 40) + (Message.getLongByte(buffer, offset + 6) << 48) + (Message.getLongByte(buffer, offset + 7) << 56);
    }

    public static long getLongByte(byte[] buffer, int offset) {
        return Message.getIntByte(buffer, offset);
    }

    public static String toString(byte[] bytes) {
        int length = bytes.length;
        StringBuffer buffer = new StringBuffer(length << 3);
        Nls.formatHexBytes(bytes, 0, length, buffer);
        return buffer.toString();
    }

    public Message() {
        this((byte[])null);
    }

    public Message(byte[] data) {
        this.setBytes(data);
    }

    public Message(byte[] data, int offset, int length) {
        byte[] target = new byte[length];
        System.arraycopy(data, offset, target, 0, length);
        this.setBytes(target);
    }

    public Message(String data) {
        this(data.getBytes());
    }

    public Object clone() throws CloneNotSupportedException {
        Message message = (Message)super.clone();
        if (this.bytes != null) {
            message.setBytes((byte[])this.getBytes().clone());
        }
        return message;
    }

    public Object decodeMessage(MessageService message) {
        return message;
    }

    public Object decodeMessage(MessageService message, ParameterService parameter) {
        if (parameter != null) {
            return parameter.decodeValue(message);
        }
        return message;
    }

    public MessageService encodeMessage(MessageService message, Object value) {
        return message;
    }

    public MessageService encodeMessage(MessageService message, ParameterService parameter, Object value) {
        if (parameter != null) {
            return parameter.encodeValue(message, value);
        }
        return message;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass().equals(object.getClass())) {
            Message m1 = (Message)object;
            return Arrays.equals(m1.bytes, this.bytes);
        }
        return false;
    }

    public Object get(Object key) {
        return null;
    }

    public boolean getBoolean(int offset) {
        return this.getBytes()[offset] != 0;
    }

    public byte getByte(int offset) {
        return this.getBytes()[offset];
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Object getData() {
        return this;
    }

    public byte[] getDataBytes() {
        int dataLength = this.getDataLength();
        int dataOffset = this.getDataOffset();
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        if (dataOffset == 0 && dataLength == length << 3) {
            return this.getBytes();
        }
        int dataIndex = dataOffset >> 3;
        int dataSize = dataLength >> 3;
        byte[] dataBytes = new byte[dataSize];
        System.arraycopy(bytes, dataIndex, dataBytes, 0, dataBytes.length);
        return dataBytes;
    }

    public int getDataLength() {
        return this.getBytes().length << 3;
    }

    public int getDataOffset() {
        return 0;
    }

    public int getInt(int offset) {
        if (this.isBigEndian()) {
            return (this.getIntByte(offset) << 24) + (this.getIntByte(offset + 1) << 16) + (this.getIntByte(offset + 2) << 8) + this.getIntByte(offset + 3);
        }
        return this.getIntByte(offset) + (this.getIntByte(offset + 1) << 8) + (this.getIntByte(offset + 2) << 16) + (this.getIntByte(offset + 3) << 24);
    }

    public int getIntByte(int offset) {
        return this.getBytes()[offset] & 0xFF;
    }

    public String getKey() {
        return this.toString();
    }

    public long getLong(int offset) {
        if (this.isBigEndian()) {
            return (this.getLongByte(offset) << 56) + (this.getLongByte(offset + 1) << 48) + (this.getLongByte(offset + 2) << 40) + (this.getLongByte(offset + 3) << 32) + (this.getLongByte(offset + 4) << 24) + (this.getLongByte(offset + 5) << 16) + (this.getLongByte(offset + 6) << 8) + this.getLongByte(offset + 7);
        }
        return this.getLongByte(offset) + (this.getLongByte(offset + 1) << 8) + (this.getLongByte(offset + 2) << 16) + (this.getLongByte(offset + 3) << 24) + (this.getLongByte(offset + 4) << 32) + (this.getLongByte(offset + 5) << 40) + (this.getLongByte(offset + 6) << 48) + (this.getLongByte(offset + 7) << 56);
    }

    public long getLongByte(int offset) {
        return this.getIntByte(offset);
    }

    public ParameterService getParameter() {
        return null;
    }

    public int getPriority() {
        return 5;
    }

    public short getShort(int offset) {
        if (this.isBigEndian()) {
            return (short)((this.getByte(offset) << 8) + this.getIntByte(offset + 1));
        }
        return (short)(this.getIntByte(offset) + (this.getByte(offset + 1) << 8));
    }

    public int hashCode() {
        int length;
        int value = 0;
        if (this.bytes != null && (length = this.bytes.length) > 0) {
            int shift = 32 / length;
            if (shift < 2) {
                shift = 2;
            }
            int i = 0;
            while (i < length) {
                value <<= shift;
                value += this.bytes[i];
                ++i;
            }
        }
        return value;
    }

    public boolean isBigEndian() {
        return true;
    }

    public int length() {
        return this.getBytes().length;
    }

    public ParameterService lookup(ParameterService parameter) {
        return parameter;
    }

    public MessageService matches(MessageService message) {
        if (message != null && Arrays.equals(message.getBytes(), this.bytes)) {
            return this;
        }
        return null;
    }

    public void put(Object key, Object value) {
    }

    public void setBoolean(int offset, boolean value) {
        this.getBytes()[offset] = (byte)(!value ? 1 : 0);
    }

    public void setByte(int offset, byte value) {
        this.getBytes()[offset] = value;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setData(Object data) {
    }

    public void setInt(int offset, int value) {
        if (this.isBigEndian()) {
            this.setByte(offset, (byte)(value >> 24));
            this.setByte(offset + 1, (byte)(value >> 16));
            this.setByte(offset + 2, (byte)(value >> 8));
            this.setByte(offset + 3, (byte)(value & 0xFF));
        } else {
            this.setByte(offset, (byte)(value & 0xFF));
            this.setByte(offset + 1, (byte)(value >> 8));
            this.setByte(offset + 2, (byte)(value >> 16));
            this.setByte(offset + 3, (byte)(value >> 24));
        }
    }

    public void setLong(int offset, long value) {
        if (this.isBigEndian()) {
            this.setByte(offset, (byte)(value >> 56));
            this.setByte(offset + 1, (byte)(value >> 48));
            this.setByte(offset + 2, (byte)(value >> 40));
            this.setByte(offset + 3, (byte)(value >> 32));
            this.setByte(offset + 4, (byte)(value >> 24));
            this.setByte(offset + 5, (byte)(value >> 16));
            this.setByte(offset + 6, (byte)(value >> 8));
            this.setByte(offset + 7, (byte)(value & 0xFFL));
        } else {
            this.setByte(offset, (byte)(value & 0xFFL));
            this.setByte(offset + 1, (byte)(value >> 8));
            this.setByte(offset + 2, (byte)(value >> 16));
            this.setByte(offset + 3, (byte)(value >> 24));
            this.setByte(offset + 4, (byte)(value >> 32));
            this.setByte(offset + 5, (byte)(value >> 40));
            this.setByte(offset + 6, (byte)(value >> 48));
            this.setByte(offset + 7, (byte)(value >> 56));
        }
    }

    public void setShort(int offset, short value) {
        if (this.isBigEndian()) {
            this.setByte(offset, (byte)(value >> 8));
            this.setByte(offset + 1, (byte)(value & 0xFF));
        } else {
            this.setByte(offset, (byte)(value & 0xFF));
            this.setByte(offset + 1, (byte)(value >> 8));
        }
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        return Message.toString(bytes);
    }
}

