/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.servlet.BundleComparator;
import org.eclipse.soda.dk.device.servlet.ServiceReferenceComparator;
import org.eclipse.soda.dk.device.servlet.TemplateInputStream;
import org.eclipse.soda.dk.nls.Nls;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DeviceServletContext {
    public static final char[] HEX_CHAR_LOWER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] HEX_CHAR_UPPER_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String TXT_CONTENT_TYPE = "text/plain;charset=UTF-8";
    public static final String XML_CONTENT_TYPE = "text/xml;charset=UTF-8";
    public Map contentTypes = this.createContentTypes();
    private Map icons = new Hashtable();
    private Map resourceLocations = new Hashtable();
    protected String serverAlias;
    private Map entities = new Hashtable();
    private Hashtable factoryMetadata = new Hashtable();
    private Hashtable pidMetadata = new Hashtable();
    private String language = "en";
    private PrintWriter writer;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String path = "";
    protected String firstItem = "";
    protected String filePath = "";
    protected String simpleFilePath = "";
    protected String fileName = "";
    protected String fileExtension = "";
    protected long idStart = 0L;
    protected long idEnd = -1L;
    protected boolean filterId = false;
    private BundleContext bundleContext = null;
    static /* synthetic */ Class class$0;

    public DeviceServletContext(HttpServletRequest request, HttpServletResponse response, String serverAlias) {
        this.setRequest(request);
        this.setResponse(response);
        this.setServerAlias(serverAlias);
        String path = request.getPathInfo();
        if (path != null && path.length() > 1) {
            String firstItem;
            this.setPath(path);
            int index = path.indexOf(47, 1);
            if (index > 1) {
                firstItem = path.substring(1, index);
                String filePath = path.substring(index + 1);
                this.setFilePath(filePath);
                index = filePath.lastIndexOf(46);
                if (index >= 0) {
                    String fileExtension = filePath.substring(index + 1);
                    this.setFileExtension(fileExtension.toLowerCase());
                    int endIndex = filePath.length() - (fileExtension.length() + 1);
                    this.setSimpleFilePath(filePath.substring(0, endIndex));
                } else {
                    this.setSimpleFilePath(filePath);
                }
                index = filePath.lastIndexOf(47);
                String fileName = filePath;
                if (index >= 0) {
                    fileName = filePath.substring(index + 1);
                }
                this.setFileName(fileName);
            } else {
                firstItem = path.substring(1);
            }
            if (Character.isDigit(firstItem.charAt(0))) {
                index = firstItem.indexOf(45);
                if (index > 0) {
                    try {
                        long starting = Long.parseLong(firstItem.substring(0, index));
                        this.setIdStart(starting);
                        long ending = Long.parseLong(firstItem.substring(index + 1));
                        this.setIdEnd(ending);
                        this.setFilterId(true);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        long starting = Long.parseLong(firstItem);
                        this.setIdStart(starting);
                        this.setIdEnd(starting);
                        this.setFilterId(true);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            this.setFirstItem(firstItem);
        }
    }

    public void addEntities(Dictionary map) {
        Enumeration enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = map.get(key);
            this.addEntity(String.valueOf(key).trim(), value);
        }
    }

    public void addEntities(Map map) {
        this.getEntities().putAll(map);
    }

    public void addEntity(String key, Object value) {
        this.getEntities().put(key, String.valueOf(value));
        this.getEntities().put(key.toLowerCase(), String.valueOf(value).toLowerCase());
        this.getEntities().put(key.toUpperCase(), String.valueOf(value).toUpperCase());
    }

    public void addEntityBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        this.addEntities(headers);
        this.addEntity("BundleId", EscObject.createNumber((long)bundle.getBundleId()));
        int state = bundle.getState();
        String stateString = "";
        switch (state) {
            case 32: {
                stateString = "active";
                break;
            }
            case 2: {
                stateString = "installed";
                break;
            }
            case 4: {
                stateString = "resolved";
                break;
            }
            case 8: {
                stateString = "starting";
                break;
            }
            case 16: {
                stateString = "stopping";
                break;
            }
            case 1: {
                stateString = "uninstalled";
            }
        }
        this.addEntity("BundleState", stateString);
        this.addEntity("BundleLocation", bundle.getLocation());
    }

    public void addEntityIcon(String key, String iconName) {
        if (iconName.length() == 0) {
            this.addEntity(key, iconName);
        } else {
            Object value = this.getIcons().get(iconName);
            if (value == null) {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append("<img src=\"");
                buffer.append(this.findIcon(iconName));
                buffer.append('/');
                buffer.append(iconName);
                buffer.append("\" alt=\"");
                buffer.append(this.niceIconNane(iconName));
                buffer.append("\"/>");
                value = buffer.toString();
                this.getIcons().put(iconName, value);
            }
            this.addEntity(key, value);
        }
    }

    public void addEntityServiceReference(ServiceReference serviceReference) {
        Object[] objectClasses;
        Object name = serviceReference.toString();
        Object objectClass = serviceReference.getProperty("objectClass");
        if (objectClass instanceof Object[] && (objectClasses = (Object[])objectClass).length > 0) {
            name = objectClasses[0];
        }
        this.addEntity("ServiceName", this.formatData(name));
        this.addEntity("ServiceNameShort", this.formatDataShort(name));
        this.addEntity("ServiceId", this.formatData(serviceReference.getProperty("service.id")));
    }

    public void begin() {
        this.setupResponse(this.getResponse());
        this.setupRequest(this.getRequest());
        this.setupEntities();
        this.template("begin");
        this.template("warning");
    }

    private Hashtable createContentTypes() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put(".xml", XML_CONTENT_TYPE);
        table.put(".txt", TXT_CONTENT_TYPE);
        table.put(".mf", TXT_CONTENT_TYPE);
        table.put(".properties", TXT_CONTENT_TYPE);
        return table;
    }

    public void end() {
        this.template("end");
    }

    public boolean filter(Bundle bundle) {
        boolean result = this.filter(bundle.getBundleId());
        if (!result) {
            Object name = bundle.getHeaders().get("Bundle-Name");
            result = this.filter(String.valueOf(name));
        }
        return result;
    }

    public Bundle[] filter(Bundle[] bundles) {
        int length = bundles.length;
        ArrayList<Bundle> list = new ArrayList<Bundle>(length);
        int i = 0;
        while (i < length) {
            Bundle bundle = bundles[i];
            if (this.filter(bundle)) {
                list.add(bundle);
            }
            ++i;
        }
        Bundle[] filteredBundles = new Bundle[list.size()];
        filteredBundles = list.toArray(filteredBundles);
        return filteredBundles;
    }

    public boolean filter(long id) {
        if (this.isFilterId()) {
            return id >= this.getIdStart() && id <= this.getIdEnd();
        }
        return false;
    }

    public boolean filter(ServiceReference serviceReference) {
        String name;
        Object objectClass;
        Object idString = serviceReference.getProperty("ID");
        boolean result = false;
        if (idString != null) {
            try {
                long id = Long.parseLong(String.valueOf(idString));
                result = this.filter(id);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!result && (objectClass = serviceReference.getProperty("objectClass")) != null && !(result = this.filter(name = String.valueOf(objectClass)))) {
            result = this.filter(this.getShort(name));
        }
        return result;
    }

    public ServiceReference[] filter(ServiceReference[] serviceReferences) {
        int length = serviceReferences.length;
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>(length);
        int i = 0;
        while (i < length) {
            ServiceReference serviceReference = serviceReferences[i];
            if (this.filter(serviceReference)) {
                list.add(serviceReference);
            }
            ++i;
        }
        ServiceReference[] filteredServiceReferences = new ServiceReference[list.size()];
        filteredServiceReferences = list.toArray(filteredServiceReferences);
        return filteredServiceReferences;
    }

    public boolean filter(String url) {
        String filter = this.getFirstItem();
        if (filter != null && filter.length() > 0) {
            if (filter.startsWith("*")) {
                return url.endsWith(filter.substring(1));
            }
            if (filter.endsWith("*")) {
                return url.startsWith(filter.substring(0, filter.length() - 1));
            }
            return filter.equals(url);
        }
        return true;
    }

    public int findBestLanguage(String language, String[] languages) {
        int i = 0;
        while (i < languages.length) {
            if (language.equals(languages[i])) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < languages.length) {
            if (languages[i].startsWith(language) || language.startsWith(languages[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public String findIcon(String iconName) {
        return "/device/resource";
    }

    public String formatData(Object data) {
        return Nls.formatData((Object)data);
    }

    public void formatData(StringBuffer buffer, Object data) {
        Nls.formatData((StringBuffer)buffer, (Object)data);
    }

    public String formatDataShort(Object data) {
        String stringData = String.valueOf(data);
        StringBuffer buffer = new StringBuffer(1024);
        int index = stringData.lastIndexOf(46);
        if (index > 0) {
            this.formatData(buffer, stringData.substring(index + 1));
        } else {
            this.formatData(buffer, data);
        }
        return buffer.toString();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getBundleDescription() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-Description")) != null) {
            return this.formatData(value);
        }
        return this.getBundleName();
    }

    public String getBundleName() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-Name")) != null) {
            return this.formatData(value);
        }
        return this.getBundleSymbolicName();
    }

    public String getBundleSymbolicName() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-SymbolicName")) != null) {
            return this.formatData(value);
        }
        return "";
    }

    public String getCopyright() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-Copyright")) != null) {
            return this.formatData(value);
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Copyright (c) ");
        buffer.append(this.getVendors());
        buffer.append(this.getYears());
        buffer.append('.');
        return buffer.toString();
    }

    public Map getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        return (String)this.getEntities().get(key);
    }

    public Hashtable getFactoryMetadata() {
        return this.factoryMetadata;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFirstItem() {
        return this.firstItem;
    }

    public String getHostAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            String name = address.getHostName();
            if (name.equals("localhost")) {
                return address.getHostAddress();
            }
            return name;
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public Map getIcons() {
        return this.icons;
    }

    public long getIdEnd() {
        return this.idEnd;
    }

    public long getIdStart() {
        return this.idStart;
    }

    public String getInputDirectory() {
        return "templates/";
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPath() {
        return this.path;
    }

    public Hashtable getPidMetadata() {
        return this.pidMetadata;
    }

    public String getProvider() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-Vendor")) != null) {
            return this.formatData(value);
        }
        return "Eclipse.org";
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Map getResourceLocations() {
        return this.resourceLocations;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getServerAlias() {
        return this.serverAlias;
    }

    public String getShort(Object data) {
        String stringData = String.valueOf(data);
        int index = stringData.lastIndexOf(46);
        if (index > 0) {
            return stringData.substring(index + 1);
        }
        return stringData;
    }

    public String getSimpleFilePath() {
        return this.simpleFilePath;
    }

    public Object getTitle() {
        return this.getServerAlias();
    }

    public Object getVendor() {
        return "IBM";
    }

    public Object getVendors() {
        return "IBM and others";
    }

    public String getVersion() {
        Dictionary headers;
        Object value;
        if (this.bundleContext != null && (value = (headers = this.bundleContext.getBundle().getHeaders()).get("Bundle-Version")) != null) {
            return this.formatData(value);
        }
        return "1.1.0";
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public String getYear() {
        Calendar calendar = Calendar.getInstance();
        String year = Integer.toString(calendar.get(1));
        return year;
    }

    public String getYears() {
        return this.getYear();
    }

    public boolean isFilterId() {
        return this.filterId;
    }

    public String niceIconNane(String name) {
        if (name.endsWith(".gif")) {
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    public void print(int data) {
        this.getWriter().print(data);
    }

    public void print(String data) {
        this.getWriter().print(data);
    }

    public void println(String data) {
        this.getWriter().println(data);
    }

    public boolean respondWith(URL url) {
        try {
            if (url != null) {
                InputStream is = url.openStream();
                BufferedInputStream bis = new BufferedInputStream(is);
                ServletOutputStream os = this.getResponse().getOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
                byte[] data = new byte[1024];
                boolean ok = true;
                while (ok) {
                    int count = bis.read(data);
                    if (count > 0) {
                        bos.write(data, 0, count);
                        continue;
                    }
                    ok = false;
                }
                bis.close();
                bos.flush();
                Object contentType = this.contentTypes.get(this.getFileExtension());
                if (contentType == null) {
                    contentType = TXT_CONTENT_TYPE;
                }
                this.getResponse().setContentType(String.valueOf(contentType));
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.begin();
        this.getResponse().setStatus(400);
        this.print("problem getting file(s).");
        this.end();
        return false;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setEntities(Hashtable entities) {
        this.entities = entities;
    }

    public void setFactoryMetadata(Hashtable factoryMetadata) {
        this.factoryMetadata = factoryMetadata;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFilterId(boolean filterId) {
        this.filterId = filterId;
    }

    public void setFirstItem(String firstItem) {
        this.firstItem = firstItem;
    }

    public void setIcons(Hashtable icons) {
        this.icons = icons;
    }

    public void setIdEnd(long idEnd) {
        this.idEnd = idEnd;
    }

    public void setIdStart(long idStart) {
        this.idStart = idStart;
    }

    public void setLanguage(String lanuguage) {
        this.language = lanuguage;
    }

    public void setPath(String path) {
        if (path != null && path.length() > 0) {
            this.path = path.substring(1);
        }
    }

    public void setPidMetadata(Hashtable pidMetadata) {
        this.pidMetadata = pidMetadata;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResourceLocations(Hashtable resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setServerAlias(String serverAlias) {
        this.serverAlias = serverAlias;
    }

    public void setSimpleFilePath(String simpleFilePath) {
        this.simpleFilePath = simpleFilePath;
    }

    public void setupEntities() {
        this.addEntity("Title", this.getTitle());
        this.addEntity("Language", this.getLanguage());
        this.addEntity("Version", this.getVersion());
        this.addEntity("Provider", this.getProvider());
        this.addEntity("Vendor", this.getVendor());
        this.addEntity("Vendors", this.getVendors());
        Calendar calendar = Calendar.getInstance();
        this.addEntity("Copyright", this.getCopyright());
        this.addEntity("BundleDescription", this.getBundleDescription());
        this.addEntity("BundleName", this.getBundleName());
        this.addEntity("BundleSymbolicName", this.getBundleSymbolicName());
        this.addEntity("Year", this.getYear());
        this.addEntity("Years", this.getYears());
        this.addEntity("Date", calendar.getTime().toString());
        StringBuffer bufferAddress = new StringBuffer(64);
        String hostAddress = this.getHostAddress();
        bufferAddress.append(hostAddress);
        if (this.request != null) {
            int serverPort = this.request.getServerPort();
            bufferAddress.append(':');
            bufferAddress.append(serverPort);
        }
        this.addEntity("HostAddress", bufferAddress.toString());
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("http://");
        buffer.append(hostAddress);
        if (this.request != null) {
            int serverPort = this.request.getServerPort();
            buffer.append(':');
            buffer.append(serverPort);
        }
        this.addEntity("HttpAddress", buffer.toString());
        buffer.append(this.getServerAlias());
        this.addEntity("ServerAddress", buffer.toString());
        buffer.append("/resource");
        this.addEntity("ResourceAddress", buffer.toString());
        this.addEntityIcon("VendorIcon", "vendor.gif");
        this.addEntityIcon("ManifestEntryIcon", "mf_entry_obj.gif");
        this.addEntityIcon("BundleIcon", "bundle.gif");
        this.addEntityIcon("ServiceIcon", "service.gif");
    }

    public void setupRequest(HttpServletRequest request) {
        Object object = request.getAttribute("ACCEPT-LANGUAGE");
        if (object != null) {
            String language = object.toString();
            this.setLanguage(language);
        }
    }

    public void setupResponse(HttpServletResponse response) {
        if (this.getFileExtension().equals("txt")) {
            response.setContentType(TXT_CONTENT_TYPE);
        } else {
            response.setContentType(HTML_CONTENT_TYPE);
        }
        try {
            this.setWriter(response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void sort(Bundle[] bundles) {
        Arrays.sort(bundles, BundleComparator.getInstance());
    }

    public void sort(ServiceReference[] serviceReferences) {
        Arrays.sort(serviceReferences, ServiceReferenceComparator.getInstance());
    }

    public void sort(String[] strings) {
        Arrays.sort(strings);
    }

    public void template(String name) {
        block5: {
            String extension = this.getFileExtension();
            try {
                int data;
                StringBuffer buffer = new StringBuffer(64);
                buffer.append(this.getInputDirectory());
                buffer.append(name);
                if (extension.equals("txt")) {
                    buffer.append(extension);
                }
                buffer.append(".txt");
                InputStream rin = this.templateInputStream(buffer.toString());
                if (rin == null) {
                    throw new IllegalArgumentException(name);
                }
                BufferedInputStream in = new BufferedInputStream(rin);
                TemplateInputStream ssiStream = new TemplateInputStream(in);
                ssiStream.setEntities(this.getEntities());
                TemplateInputStream ssiStream2 = new TemplateInputStream(ssiStream);
                ssiStream2.setEntities(this.getEntities());
                while ((data = ssiStream2.read()) != -1) {
                    this.getWriter().print((char)data);
                }
                ssiStream2.close();
                ssiStream.close();
                in.close();
                this.getWriter().println();
            }
            catch (Exception exception) {
                if (extension.equals("txt")) break block5;
                System.out.print(">>");
                System.out.println(exception);
                exception.printStackTrace(System.out);
            }
        }
    }

    public InputStream templateInputStream(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.device.servlet.DeviceServletContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream(name);
    }
}

