/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Container;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.device.NotificationQueue;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.osgi.framework.BundleContext;

public class NotificationController
implements NotificationService,
NotificationListener,
SignalListener,
MeasurementListener,
CommandListener,
Runnable {
    private Thread thread;
    private boolean running = false;
    private NotificationQueue queue = new NotificationQueue();
    protected char idSperator = (char)47;
    private NotificationService notificationService = null;
    private Map controlsExternal;
    private String id = null;
    private Container container = null;
    private BundleContext bundleContext;
    private String symbolicName = "";
    private Dictionary receivedData = null;
    private String receivedExternalKey = null;

    public NotificationController() {
        this(null, null, null);
    }

    public NotificationController(NotificationService notificationService, Container container) {
        this(notificationService, container, null);
    }

    public NotificationController(NotificationService notificationService, Container container, String id) {
        this.setRunning(true);
        this.thread = new Thread((Runnable)this, String.valueOf((Object)container));
        this.thread.setPriority(6);
        this.thread.setDaemon(true);
        this.thread.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        this.setId(id);
        this.setContainer(container);
        this.setNotificationService(notificationService);
    }

    public void addData(String externalKey, Dictionary data) {
        if (data.get("timestamp") == null) {
            data.put("timestamp", EscObject.getCurrentTimestamp());
        }
        if (this.bundleContext != null && data.get("bundle.symbolicName") == null) {
            data.put("bundle.symbolicName", this.symbolicName);
        }
    }

    public void addQualifiedKeys(String id) {
        this.setId(id);
        this.removeQualifiedKeys();
        Hashtable controls = this.getContainer().getControls();
        int controlsSize = controls.size();
        int idLength = id != null ? id.length() : 0;
        StringBuffer buffer = new StringBuffer(idLength + 65);
        if (id != null) {
            buffer.append(id);
            buffer.append(this.idSperator);
        }
        int baseLength = buffer.length();
        buffer.append(this.container.getKey());
        String externalKeyDevice = buffer.toString().intern();
        buffer.delete(baseLength, buffer.length());
        this.container.setQualifiedKey(externalKeyDevice);
        HashMap capabilities = new HashMap((controlsSize << 2) + 1);
        HashMap controlMap = new HashMap(13);
        if (this.notificationService != null) {
            MeasurementService measurementCapabilities;
            MeasurementService measurementConfiguration;
            Measurement measurementMetrics;
            Iterator iterator = controls.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = String.valueOf(entry.getKey());
                Control control = (Control)((Object)entry.getValue());
                buffer.append(key);
                String externalKey = buffer.toString().intern();
                control.setQualifiedKey(externalKey);
                buffer.delete(baseLength, buffer.length());
                capabilities.put(key, controlMap);
                if (control instanceof SignalService) {
                    SignalService signal = (SignalService)control;
                    signal.addSignalListener((SignalListener)this);
                    String triggerKey = (String.valueOf(externalKey) + "/trigger").intern();
                    this.controlsExternal.put(triggerKey, control);
                    capabilities.put(String.valueOf(key) + "/execute", controlMap);
                }
                if (control instanceof MeasurementService) {
                    MeasurementService measurementService = (MeasurementService)control;
                    measurementService.addMeasurementListener((MeasurementListener)this);
                    String readKey = (String.valueOf(externalKey) + "/read").intern();
                    this.controlsExternal.put(readKey, control);
                    String setKey = (String.valueOf(externalKey) + "/set").intern();
                    this.controlsExternal.put(setKey, control);
                    String writeKey = (String.valueOf(externalKey) + "/write").intern();
                    this.controlsExternal.put(writeKey, control);
                    String getKey = (String.valueOf(externalKey) + "/get").intern();
                    this.controlsExternal.put(getKey, control);
                    capabilities.put(String.valueOf(key) + "/get", controlMap);
                    capabilities.put(String.valueOf(key) + "/read", controlMap);
                    capabilities.put(String.valueOf(key) + "/write", controlMap);
                    capabilities.put(String.valueOf(key) + "/set", controlMap);
                }
                if (!(control instanceof CommandService)) continue;
                CommandService commandService = (CommandService)control;
                commandService.addCommandListener((CommandListener)this);
                String executeKey = (String.valueOf(externalKey) + "/execute").intern();
                this.controlsExternal.put(executeKey, control);
                capabilities.put(String.valueOf(key) + "/execute", controlMap);
            }
            MeasurementService measurementStatus = this.container.getStatus();
            if (measurementStatus != null) {
                this.controlsExternal.put("Status/read", measurementStatus);
                this.controlsExternal.put("Status/get", measurementStatus);
                capabilities.put("Status/read", controlMap);
                capabilities.put("Status/get", controlMap);
            }
            if ((measurementMetrics = this.container.getMetrics()) != null) {
                this.controlsExternal.put("Metrics/get", measurementMetrics);
                capabilities.put("Metrics/get", controlMap);
            }
            if ((measurementConfiguration = this.container.getConfiguration()) != null) {
                this.controlsExternal.put("Configuration/get", measurementConfiguration);
                this.controlsExternal.put("Configuration/read", measurementConfiguration);
                capabilities.put("Configuration/get", controlMap);
                capabilities.put("Configuration/read", controlMap);
            }
            if ((measurementCapabilities = this.container.getCapabilities()) != null) {
                this.controlsExternal.put("Capabilities/read", measurementCapabilities);
                this.controlsExternal.put("Capabilities/get", measurementCapabilities);
                capabilities.put("Capabilities/read", controlMap);
                capabilities.put("Capabilities/get", controlMap);
            }
            Set keySet = this.controlsExternal.keySet();
            String[] topics = new String[keySet.size()];
            topics = keySet.toArray(topics);
            this.notificationService.register(topics, (NotificationListener)this);
            this.container.capabilities.setValue(capabilities, EscObject.getCurrentTimestamp());
        }
    }

    public void addReceivedData(String externalKey, Dictionary notifyData) {
        String receivedExternalKey;
        Dictionary receivedData = this.getReceivedData();
        if (receivedData != null && (receivedExternalKey = this.getReceivedExternalKey()) != null && receivedExternalKey.startsWith(externalKey)) {
            notifyData.put("received.event", receivedData);
        }
    }

    public void broadcast(String externalKey, Dictionary data) {
        if (data != null) {
            this.addData(externalKey, data);
        }
        this.getNotificationService().broadcast(externalKey, data);
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(23);
        String key = source.getKey();
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            Object tdata = this.publishValue(data);
            notifyData.put("value", tdata);
        }
        notifyData.put("source", source.getKey());
        notifyData.put("keys", new String[]{key});
        String externalKey = source.toString();
        this.addReceivedData(externalKey, notifyData);
        this.notificationService.broadcast(source.toString(), notifyData);
        this.container.updateBroadcastCommandCount();
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(23);
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            notifyData.put("value", data);
        }
        if (data instanceof Exception) {
            notifyData.put("exception", data);
            notifyData.put("message", data.toString());
        }
        notifyData.put("source", source.toString());
        String sourceName = this.container.getQualifiedKey();
        if (source instanceof Control) {
            sourceName = ((Control)((Object)source)).getQualifiedKey();
        }
        this.addReceivedData(sourceName, notifyData);
        this.notificationService.broadcast(String.valueOf(sourceName) + "/error", notifyData);
    }

    public void exit() {
        this.setRunning(false);
        if (this.queue != null) {
            this.queue.clear();
        }
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.thread = null;
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getId() {
        return this.id;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public NotificationQueue getQueue() {
        return this.queue;
    }

    public Dictionary getReceivedData() {
        return this.receivedData;
    }

    public String getReceivedExternalKey() {
        return this.receivedExternalKey;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(23);
        String key = source.getKey();
        String externalKey = source.toString();
        notifyData.put("timestamp", timestamp);
        if (newValue != null) {
            Object tnewValue = this.publishValue(newValue);
            notifyData.put("value", tnewValue);
            notifyData.put(key, tnewValue);
        }
        if (oldValue != null) {
            Object toldValue = this.publishValue(oldValue);
            notifyData.put("value_old", toldValue);
        }
        notifyData.put("source", source.getKey());
        notifyData.put("keys", new String[]{key});
        this.addReceivedData(externalKey, notifyData);
        this.notificationService.broadcast(source.toString(), notifyData);
        this.container.updateBroadcastMeasurementCount();
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        this.queue.enqueue(externalKey, data);
    }

    public void process(String externalKey, Dictionary data) {
        Control control = (Control)((Object)this.controlsExternal.get(externalKey));
        if (control == null) {
            this.container.notificationReceived(externalKey, data);
            return;
        }
        this.setReceivedExternalKey(externalKey);
        this.setReceivedData(data);
        Object value = null;
        if (data != null && (value = data.get("value")) == null) {
            value = data.get(control.getKey());
        }
        if (control instanceof SignalService) {
            SignalService signal = (SignalService)control;
            if (value == null) {
                signal.trigger();
            } else {
                signal.trigger(value);
            }
        }
        if (control instanceof MeasurementService) {
            MeasurementService measurement = (MeasurementService)control;
            if (externalKey.endsWith("/get")) {
                Hashtable<String, Object> notifyData = new Hashtable<String, Object>(23);
                Object measurementValue = measurement.getValue();
                if (measurementValue != null) {
                    notifyData.put("value", measurementValue);
                    notifyData.put(measurement.getKey(), measurementValue);
                    notifyData.put("timestamp", measurement.getTimestamp());
                } else {
                    notifyData.put("timestamp", EscObject.getCurrentTimestamp());
                }
                notifyData.put("source", measurement.getKey());
                notifyData.put("received_key", externalKey);
                if (data != null) {
                    notifyData.put("received.event", data);
                }
                this.notificationService.broadcast(measurement.toString(), notifyData);
            } else if (externalKey.endsWith("/write")) {
                measurement.executeWrite(value);
            } else if (externalKey.endsWith("/read")) {
                measurement.executeRead();
            } else if (externalKey.endsWith("/set")) {
                measurement.setValue(value);
            }
        }
        if (control instanceof CommandService) {
            CommandService commandService = (CommandService)control;
            if (value == null) {
                commandService.execute();
            } else {
                commandService.execute(value);
            }
        }
        this.setReceivedExternalKey(null);
        this.setReceivedData(null);
    }

    public Object publishValue(Object value) {
        Collection tvalue = value;
        if (value instanceof Map) {
            Map map = value;
            if (map.isEmpty()) {
                tvalue = EscObject.getReadOnlyEmptyMap();
            } else if (!EscObject.getReadOnlyEmptyMap().getClass().isInstance(value)) {
                tvalue = Collections.unmodifiableMap(map);
            }
        } else if (value instanceof List) {
            List list = (List)((Object)value);
            if (list.isEmpty()) {
                tvalue = EscObject.getReadOnlyEmptyList();
            } else if (!EscObject.getReadOnlyEmptyList().getClass().isInstance(value)) {
                tvalue = Collections.unmodifiableList(list);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)((Object)value);
            if (collection.isEmpty()) {
                tvalue = EscObject.getReadOnlyEmptyCollection();
            } else if (!EscObject.getReadOnlyEmptyCollection().getClass().isInstance(value)) {
                tvalue = Collections.unmodifiableCollection(collection);
            }
        }
        return tvalue;
    }

    public void register(String externalKey) {
        this.getNotificationService().register(externalKey, (NotificationListener)this);
    }

    public void register(String externalKey, NotificationListener listener) {
        this.getNotificationService().register(externalKey, (NotificationListener)this);
    }

    public void register(String[] externalKeys) {
        this.getNotificationService().register(externalKeys, (NotificationListener)this);
    }

    public void register(String[] externalKeys, NotificationListener listener) {
        this.getNotificationService().register(externalKeys, (NotificationListener)this);
    }

    public void removeQualifiedKeys() {
        if (this.controlsExternal == null) {
            this.controlsExternal = new HashMap((this.container.getControlCapacity() << 2) + 1);
        } else {
            Collection collection = this.controlsExternal.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object control = iterator.next();
                if (control instanceof CommandService) {
                    ((CommandService)control).removeCommandListener((CommandListener)this);
                }
                if (control instanceof SignalService) {
                    ((SignalService)control).removeSignalListener((SignalListener)this);
                }
                if (!(control instanceof MeasurementService)) continue;
                ((MeasurementService)control).removeMeasurementListener((MeasurementListener)this);
            }
            this.controlsExternal.clear();
        }
    }

    public void run() {
        Object[] entry = new Object[2];
        while (this.isRunning()) {
            this.queue.dequeue(0L, entry);
            if (entry == null || entry[0] == null) continue;
            String externalKey = entry[0].toString();
            this.process(externalKey, (Dictionary)entry[1]);
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        if (this.bundleContext != null) {
            this.setSymbolicName(this.bundleContext.getBundle().getSymbolicName());
        }
    }

    public void setContainer(Container container) {
        this.container = container;
        if (this.container != null) {
            this.bundleContext = this.container.getBundleContext();
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNotificationService(NotificationService notificationService) {
        if (this.notificationService != null) {
            this.unregister();
            this.removeQualifiedKeys();
        }
        this.notificationService = notificationService;
        if (this.notificationService != null) {
            this.addQualifiedKeys(this.getId());
        }
    }

    public void setQueue(NotificationQueue queue) {
        this.queue = queue;
    }

    public void setReceivedData(Dictionary data) {
        this.receivedData = data;
    }

    public void setReceivedExternalKey(String receivedExternalKey) {
        this.receivedExternalKey = receivedExternalKey;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        Hashtable<String, Object> notifyData = new Hashtable<String, Object>(23);
        String key = source.getKey();
        notifyData.put("timestamp", timestamp);
        if (data != null) {
            Object tdata = this.publishValue(data);
            notifyData.put("value", tdata);
            notifyData.put(source.getKey(), tdata);
        }
        notifyData.put("keys", new String[]{key});
        notifyData.put("source", key);
        String externalKey = source.toString();
        this.addReceivedData(externalKey, notifyData);
        this.notificationService.broadcast(source.toString(), notifyData);
        this.container.updateBroadcastSignalCount();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.toString());
        buffer.append('{');
        buffer.append((Object)this.container);
        buffer.append('{');
        return buffer.toString();
    }

    public void unregister() {
        this.unregister(this);
    }

    public void unregister(NotificationListener listener) {
        this.notificationService.unregister(listener);
    }
}

