/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.measurement.SignalMeasurement;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class ReadMeasurement
extends SignalMeasurement {
    protected CommandService readCommand;

    public ReadMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal, CommandService readCommand) {
        super(key, value, units, transform, signal);
        this.setReadCommand(readCommand);
    }

    public ReadMeasurement(String key, UnitsService units, TransformService transform, SignalService signal) {
        super(key, units, transform, signal);
    }

    public ReadMeasurement(String key, TransformService transform, SignalService signal) {
        super(key, transform, signal);
    }

    public ReadMeasurement(String key, SignalService signal) {
        super(key, signal);
    }

    public void executeRead() {
        CommandService readCommand = this.getReadCommand();
        if (readCommand != null) {
            readCommand.execute();
        } else {
            super.executeRead();
        }
    }

    public CommandService getReadCommand() {
        return this.readCommand;
    }

    public synchronized Object read(long timeout) throws RuntimeException {
        if (this.getReadCommand() != null) {
            Object currentStamp = this.getTimestamp();
            this.sleep(1L);
            this.executeRead();
            try {
                ((Object)((Object)this)).wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
            if (currentStamp == this.getTimestamp()) {
                throw new RuntimeException(this.format(3019, (Object)this));
            }
            return this.getValue();
        }
        return super.read(timeout);
    }

    public void setReadCommand(CommandService readCommand) {
        this.readCommand = readCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(Object timestamp) {
        super.setTimestamp(timestamp);
        ReadMeasurement readMeasurement = this;
        synchronized (readMeasurement) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

