/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class SignalListeners
extends EscObject
implements SignalListener {
    private SignalListener[] objects;

    public static SignalListener add(SignalListener currentObject, SignalListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new SignalListeners(currentObject, newObject);
    }

    public static SignalListener remove(SignalListener currentObject, SignalListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof SignalListeners) {
            return ((SignalListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public SignalListeners(SignalListener currentObject, SignalListener newObject) {
        if (currentObject instanceof SignalListeners) {
            SignalListeners currentMulticaster = (SignalListeners)currentObject;
            SignalListener[] oldList = currentMulticaster.getObjects();
            this.objects = new SignalListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new SignalListener[]{currentObject, newObject};
        }
    }

    public SignalListeners(SignalListener[] objects) {
        this.setObjects(objects);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public SignalListener[] getObjects() {
        return this.objects;
    }

    protected SignalListener remove(SignalListener removeHandler) {
        SignalListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        SignalListener[] newList = new SignalListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new SignalListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(SignalListener[] objects) {
        this.objects = objects;
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].signalOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }
}

