/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.IReaderCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.capabilities.ReaderCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.AbstractDisplayElement;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPDefStore;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;

public class ParameterDisplay
extends AbstractDisplayElement {
    public static final char SEPERATOR = '_';
    public static final char CHOICE_SEPERATOR = ':';
    private List historyChain;
    private IReaderCapabilities readerCapabilities;

    public ParameterDisplay(String name, Object paramObj) {
        this(name, paramObj, new ArrayList());
    }

    public ParameterDisplay(String name, Object paramObj, List historyChain) {
        this(name, paramObj, new ArrayList(), new ReaderCapabilities());
    }

    public ParameterDisplay(String name, Object paramObj, List historyChain, IReaderCapabilities readerCapabilities) {
        super(name, paramObj, 3);
        this.historyChain = historyChain != null ? historyChain : new ArrayList();
        this.readerCapabilities = readerCapabilities != null ? readerCapabilities : new ReaderCapabilities();
    }

    public ParameterDisplay(String name, Object paramObj, int type, List historyChain, IReaderCapabilities readerCapabilities) {
        super(name, paramObj, type);
        this.historyChain = historyChain != null ? historyChain : new ArrayList();
        this.readerCapabilities = readerCapabilities != null ? readerCapabilities : new ReaderCapabilities();
    }

    public static String addSerialNumToPath(String path, int serialNum) {
        return String.valueOf(path) + '_' + serialNum;
    }

    public static String getChoiceId(String choiceParamPath) {
        int index = choiceParamPath.indexOf(58);
        if (index != -1) {
            return choiceParamPath.substring(0, index);
        }
        return choiceParamPath;
    }

    public static String getChoiceParamId(String choiceParamPath) {
        int index = choiceParamPath.indexOf(58);
        if (index != -1) {
            return choiceParamPath.substring(index + 1);
        }
        return choiceParamPath;
    }

    public static String getElementPath(String elementId) {
        return elementId;
    }

    public static String getElementPath(String choiceId, String elementId) {
        if (!choiceId.equals(elementId)) {
            return String.valueOf(choiceId) + ':' + elementId;
        }
        return elementId;
    }

    public static String getParamId(String name) {
        int seperator_index = name.indexOf(95);
        if (seperator_index != -1) {
            return name.substring(0, seperator_index);
        }
        return name;
    }

    public static int getSerialNo(String name) {
        int seperator_index = name.indexOf(95);
        if (seperator_index != -1) {
            return Integer.valueOf(name.substring(seperator_index + 1));
        }
        return -1;
    }

    public static boolean isChoiceParamPath(String path) {
        int index = path.indexOf(58);
        return index != -1;
    }

    protected String getFormHeader(String servletPath) {
        StringBuffer result = new StringBuffer();
        result.append("<form method=post id=\"" + this.getName() + "\" action=" + servletPath + ">\n");
        return result.toString();
    }

    protected String getFormTail() {
        StringBuffer result = new StringBuffer();
        result.append("<tr><td colspan=\"3\"><hr size=\"1\"></td></tr>\n");
        result.append("<tr><td>&nbsp;</td>\n");
        result.append("<td align=\"left\">");
        result.append("<input type=\"hidden\" name=\"Action\" id=\"Action\" value=\"\"/>\n");
        result.append("<input type=\"hidden\" name=\"Path\" id=\"Path\" value=\"\"/>\n");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        result.append("<tr>");
        result.append("<td align=\"left\">");
        result.append(ParameterDisplay.getButton("OK", 1, ""));
        result.append("</td>");
        result.append("<td align=\"left\">");
        result.append(ParameterDisplay.getButton("Cancel", 6, ""));
        result.append("</td>");
        result.append("</tr>");
        result.append("</table>");
        result.append("</td><td>&nbsp;</td></tr>\n");
        result.append("</form>\n");
        return result.toString();
    }

    public List getHistoryChain() {
        if (this.historyChain == null) {
            this.historyChain = new ArrayList();
        }
        return this.historyChain;
    }

    public String getHtml(String servletPath) {
        StringBuffer result = new StringBuffer();
        List paramDefElements = LLRPDefStore.getParamElements(this.getParamId());
        if (paramDefElements == null || paramDefElements.size() == 0) {
            return "LLRP Definition for " + this.getParamId() + " can not be found.";
        }
        if (this.getParamObj() == null) {
            return "Error: " + this.getParamId() + " is null";
        }
        result.append(this.getNavigatorHtml(servletPath));
        result.append(this.getFormHeader(servletPath));
        result.append("<table border=\"0\" width=\"80\">\n");
        if (this.getComment() != null && this.getComment().length() > 0) {
            result.append("<tr>");
            result.append("<td>&nbsp;</td>\n");
            result.append("<td colspan=\"2\" align=\"left\"><font color=\"red\">");
            result.append(this.getComment());
            result.append("</font></td></tr>\n");
        }
        result.append("<tr><td colspan=\"3\">&nbsp;</td></tr>\n");
        int i = 0;
        while (i < paramDefElements.size()) {
            Map elementDef = (Map)paramDefElements.get(i);
            String elementId = (String)elementDef.get("id");
            int elementType = (Integer)elementDef.get("type");
            Object value = ((Map)this.getParamObj()).get(elementId);
            switch (elementType) {
                case 0: 
                case 6: {
                    String[] numberEnums = LLRPDefStore.getEnumItems(elementId);
                    if (numberEnums == null || numberEnums.length == 0) {
                        result.append("<tr>\n");
                        result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                        result.append("<td align=\"left\" valign=\"top\">");
                        result.append("<input type=\"text\" name=\"" + elementId + "\" value=\"" + (value != null ? value : "") + "\"/>");
                        result.append("</td>\n");
                        result.append("<td>&nbsp;</td>\n");
                        result.append("</tr>\n");
                        break;
                    }
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    result.append("<td align=\"left\" valign=\"top\">\n");
                    result.append("<select name=\"" + elementId + "\">\n");
                    int j = 0;
                    while (j < numberEnums.length) {
                        result.append("<option value=\"" + j + "\" ");
                        result.append(j == (Integer)value ? "selected=\"selected\">" : ">");
                        result.append(String.valueOf(numberEnums[j]) + "</option>\n");
                        ++j;
                    }
                    result.append("</select>\n");
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("</tr>\n");
                    break;
                }
                case 2: {
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    result.append("<td align=\"left\" valign=\"top\">");
                    result.append("<input type=\"text\" name=\"" + elementId + "\" id=\"" + elementId + "\" value=\"" + (value != null ? value : "") + "\"/>");
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("</tr>\n");
                    break;
                }
                case 10: {
                    int variableLengthType = LLRPDefStore.getVariableLengthType(elementId);
                    if (variableLengthType != 11) break;
                    byte[] byteArray = (byte[])value;
                    String byteArrayStr = LLRPUtils.byteArray2Str((byte[])byteArray);
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    result.append("<td align=\"left\" valign=\"top\">");
                    result.append("<input type=\"text\" name=\"" + elementId + "\" value=\"" + byteArrayStr + "\"/>");
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("</tr>\n");
                    break;
                }
                case 9: {
                    int listType = LLRPDefStore.getListType(elementId);
                    if (listType != 0 || value == null) break;
                    List array = (List)value;
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    if (array.size() > 0) {
                        result.append("<td align=\"left\">");
                        result.append("<input type=\"text\" name=\"" + elementId + "\" value=\"" + array.get(0) + "\">");
                        result.append("</td>\n");
                    } else {
                        result.append("<td>&nbsp;</td>\n");
                    }
                    result.append("<td align=\"left\">\n");
                    result.append(ParameterDisplay.getButton("Add", 2, ParameterDisplay.getElementPath(elementId)));
                    result.append("</td>\n");
                    result.append("</tr>\n");
                    int j = 1;
                    while (j < array.size()) {
                        result.append("<tr>\n");
                        result.append("<td>&nbsp;</td>\n");
                        result.append("<td align=\"left\">");
                        result.append("<input type=\"text\" name=\"" + elementId + "\" value=\"" + array.get(j) + "\">");
                        result.append("</td>\n");
                        result.append("<td align=\"left\">");
                        result.append(ParameterDisplay.getButton("Delete", 3, ParameterDisplay.addSerialNumToPath(ParameterDisplay.getElementPath(elementId), j)));
                        result.append("</td>\n");
                        result.append("</tr>\n");
                        ++j;
                    }
                    break;
                }
                case 8: {
                    String[] booleanEnums = LLRPDefStore.getEnumItems(elementId);
                    if (booleanEnums == null || booleanEnums.length == 0) {
                        booleanEnums = new String[]{"False", "True"};
                    }
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    result.append("<td align=\"left\" valign=\"top\">\n");
                    result.append("<select name=\"" + elementId + "\">\n");
                    result.append("<option value=\"1\" ");
                    result.append((Integer)value == 1 ? "selected=\"selected\">" : ">");
                    result.append(String.valueOf(booleanEnums[1]) + "</option>\n");
                    result.append("<option value=\"0\" ");
                    result.append((Integer)value == 0 ? "selected=\"selected\">" : ">");
                    result.append(String.valueOf(booleanEnums[0]) + "</option>\n");
                    result.append("</select>\n");
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("</tr>\n");
                    break;
                }
                case 3: 
                case 4: {
                    int maxCapability;
                    if (i >= 1) {
                        result.append("<tr><td>&nbsp;</td><td colspan=\"2\"><hr size=\"1\"></td></tr>\n");
                    }
                    result.append("<tr>\n");
                    result.append("<td align=\"right\" valign=\"top\">" + elementId + ':' + "</td>\n");
                    int minOccur = Integer.valueOf((String)elementDef.get("occursminimum"));
                    String maxOccurStr = (String)elementDef.get("occursmaximum");
                    int maxOccur = maxOccurStr.equals("n") ? -1 : Integer.valueOf(maxOccurStr);
                    ArrayList paramList = new ArrayList();
                    if (maxOccur > 1 || maxOccur == -1 || 4 == elementType) {
                        if (value != null) {
                            paramList.addAll((List)value);
                        }
                    } else if (value != null) {
                        paramList.add(value);
                    }
                    if ((maxCapability = this.readerCapabilities.getParameterMaxSupported(elementId)) != 0) {
                        maxOccur = maxCapability;
                    }
                    result.append("<td align=\"left\" valign=\"top\">(" + minOccur + ',' + (maxOccur == -1 ? "n" : String.valueOf(maxOccur)) + ")</td>\n");
                    if (paramList.size() < maxOccur || maxOccur == -1) {
                        result.append("<td align=\"left\" valign=\"top\">");
                        if (this.readerCapabilities.isParameterSupported(elementId)) {
                            result.append(ParameterDisplay.getButton("Add", 2, ParameterDisplay.getElementPath(elementId)));
                        } else {
                            result.append("(not supported)");
                        }
                        result.append("</td>\n");
                    } else {
                        result.append("<td>&nbsp;</td>\n");
                    }
                    result.append("</tr>\n");
                    if (4 == elementType) {
                        String[] choices = LLRPDefStore.getChoiceItems(elementId);
                        result.append("<tr>\n");
                        result.append("<td>&nbsp;</td>\n");
                        result.append("<td align=\"left\">\n");
                        result.append("<table frame=\"box\" cellpadding=\"0\" cellspacing=\"0\">\n");
                        int j = 0;
                        while (j < choices.length) {
                            String choice = choices[j];
                            result.append("<tr>\n");
                            result.append("<td align=\"center\"><input type=\"radio\" name=\"" + elementId + "\" value=\"" + choice + '\"' + (j == 0 ? " checked=\"checked\"" : ""));
                            if (!this.readerCapabilities.isParameterSupported(choice)) {
                                result.append(" disabled=\"disabled\"");
                            }
                            result.append("></td>\n");
                            result.append("<td align=\"left\">" + choice + "</td>\n");
                            result.append("</tr>\n");
                            ++j;
                        }
                        result.append("</table></td>\n");
                        result.append("<td>&nbsp;</td>\n");
                        result.append("</tr>\n");
                    }
                    int j = 0;
                    while (j < paramList.size()) {
                        result.append("<tr>\n");
                        Map param = (Map)paramList.get(j);
                        result.append("<td align=\"right\">" + (j + 1) + ".</td>\n");
                        String paramId = 4 == elementType ? (String)param.keySet().iterator().next() : elementId;
                        result.append("<td align=\"left\">" + paramId + "</td>\n");
                        result.append("<td align=\"left\">");
                        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>\n");
                        result.append("<td align=\"left\">" + ParameterDisplay.getButton("Edit", 4, ParameterDisplay.addSerialNumToPath(ParameterDisplay.getElementPath(elementId, paramId), j)) + "</td>\n");
                        if (minOccur == 1 && j == 0 && paramList.size() == 1) {
                            result.append("<td>&nbsp;</td>\n");
                        } else {
                            result.append("<td align=\"left\">" + ParameterDisplay.getButton("Delete", 3, ParameterDisplay.addSerialNumToPath(ParameterDisplay.getElementPath(elementId), j)) + "</td>\n");
                        }
                        result.append("</tr></table></td>\n");
                        result.append("</tr>\n");
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        result.append(this.getFormTail());
        result.append("</table>\n");
        return result.toString();
    }

    protected String getNavigatorHtml(String servletPath) {
        ArrayList<String> links = new ArrayList<String>();
        links.add(this.getParamId());
        int i = 0;
        while (i < this.historyChain.size()) {
            int backLevel = i + 1;
            StringBuffer link = new StringBuffer();
            link.append("<a href=\"" + servletPath + '?' + "Action" + '=' + 5);
            link.append("&Path=" + backLevel + "\">");
            link.append(this.historyChain.get(i) + "</a>&nbsp;>&nbsp;");
            links.add(link.toString());
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append("<table frame=\"below\">\n");
        String tab = "";
        int i2 = links.size() - 1;
        while (i2 > 0) {
            result.append("<tr><td>" + tab);
            int j = 0;
            while (j < 3) {
                result.append((String)links.get(i2));
                if (--i2 <= 0) break;
                ++j;
            }
            result.append("</td></tr>\n");
            tab = String.valueOf(tab) + "&nbsp;&nbsp;&nbsp;";
        }
        if (links.size() > 1) {
            result.append("<tr><td>&nbsp;</td></tr>\n");
        }
        result.append("<tr><td>" + (String)links.get(0) + "</td></tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    public String getParamId() {
        return ParameterDisplay.getParamId(this.getName());
    }

    public IReaderCapabilities getReaderCapabilities() {
        return this.readerCapabilities;
    }

    public int getSerialNo() {
        return ParameterDisplay.getSerialNo(this.getName());
    }

    public boolean setParamValues(HttpServletRequest request) {
        if (this.getType() != 3) {
            return false;
        }
        Map currentParamObj = (Map)this.getParamObj();
        String paramId = this.getParamId();
        List paramDefElements = LLRPDefStore.getParamElements(paramId);
        boolean isValidValue = true;
        this.clearComment();
        int i = 0;
        while (i < paramDefElements.size()) {
            Map elementDef = (Map)paramDefElements.get(i);
            String elementId = (String)elementDef.get("id");
            int elementType = (Integer)elementDef.get("type");
            try {
                switch (elementType) {
                    case 2: {
                        currentParamObj.put(elementId, request.getParameter(elementId));
                        break;
                    }
                    case 8: {
                        currentParamObj.put(elementId, Integer.valueOf(request.getParameter(elementId)));
                        break;
                    }
                    case 0: {
                        int number = Integer.parseInt(request.getParameter(elementId));
                        if (number >= 0) {
                            Integer maxPriority;
                            if ("Priority".equals(elementId) && (maxPriority = (Integer)this.readerCapabilities.getCapabilityValue("MaxNumPriorityLevelsSupported")) != null && number > maxPriority) {
                                isValidValue = false;
                                this.addComment("Invalid priority: " + number + ", max: " + maxPriority);
                                break;
                            }
                            currentParamObj.put(elementId, EscObject.createInteger((int)number));
                            break;
                        }
                        isValidValue = false;
                        this.addComment("Invalid number for " + elementId + ':' + number);
                        break;
                    }
                    case 6: {
                        long longNumber = Long.parseLong(request.getParameter(elementId));
                        if (longNumber >= 0L) {
                            currentParamObj.put(elementId, new Long(longNumber));
                            break;
                        }
                        isValidValue = false;
                        this.addComment("Invalid number for " + elementId + ':' + longNumber);
                        break;
                    }
                    case 9: {
                        String[] numbers;
                        int listType = LLRPDefStore.getListType(elementId);
                        if (listType != 0 || (numbers = request.getParameterValues(elementId)) == null) break;
                        ArrayList<Integer> value = new ArrayList<Integer>(numbers.length);
                        boolean isValidArray = true;
                        int j = 0;
                        while (j < numbers.length) {
                            try {
                                int arrayNumber = Integer.parseInt(numbers[j]);
                                if (arrayNumber >= 0) {
                                    value.add(EscObject.createInteger((int)arrayNumber));
                                } else {
                                    isValidArray = false;
                                    this.addComment("Invalid number for " + elementId + ':' + arrayNumber);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                isValidArray = false;
                                this.addComment("Invalid number for " + elementId + ':' + numbers[j]);
                            }
                            ++j;
                        }
                        if (isValidArray) {
                            currentParamObj.put(elementId, value);
                            break;
                        }
                        isValidValue = false;
                        break;
                    }
                    case 10: {
                        int variableLengthType = LLRPDefStore.getVariableLengthType(elementId);
                        if (variableLengthType != 11) break;
                        String byteArrayStr = request.getParameter(elementId);
                        byte[] byteArray = LLRPUtils.str2byteArray((String)byteArrayStr);
                        currentParamObj.put(elementId, byteArray);
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                isValidValue = false;
                this.addComment("Invalid number for " + elementId + ':' + request.getParameter(elementId));
            }
            ++i;
        }
        return isValidValue;
    }
}

