/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.WriteProfileConsole;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.BlockErase;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.BlockWrite;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.Filter;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.History;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.IOperation;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.IncrementWrite;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.Kill;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.Lock;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.Read;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.Write;

public class WriteProfileServlet
extends DeviceServlet {
    private static final long serialVersionUID = 1L;
    private static final String SERVLET_ALIAS = "/device/WriteProfileConsole";
    private static final String PREFIX = "prefix";
    private WriteProfileConsole writeProfileConsole;
    private String writeProfileID = "R1";
    private Hashtable operations = new Hashtable();
    private String selectedOperation;
    private String operationLine = "";
    private boolean updateOnly;
    private String reportsHtml = "";
    private IOperation history;

    public WriteProfileServlet() {
        Filter filter = new Filter();
        this.selectedOperation = filter.getName();
        this.operations.put(filter.getName(), filter);
        Write write = new Write();
        this.operations.put(write.getName(), write);
        IncrementWrite incrementWrite = new IncrementWrite();
        this.operations.put(incrementWrite.getName(), incrementWrite);
        Read read = new Read();
        this.operations.put(read.getName(), read);
        Kill kill = new Kill();
        this.operations.put(kill.getName(), kill);
        Lock lock = new Lock();
        this.operations.put(lock.getName(), lock);
        BlockErase blockErase = new BlockErase();
        this.operations.put(blockErase.getName(), blockErase);
        BlockWrite blockWrite = new BlockWrite();
        this.operations.put(blockWrite.getName(), blockWrite);
        this.history = new History();
        this.operations.put(this.history.getName(), this.history);
    }

    private void addOperation(String opLine) {
        this.operationLine = String.valueOf(this.operationLine) + opLine;
    }

    public void bind(WriteProfileConsole writeProfileConsole) {
        this.writeProfileConsole = writeProfileConsole;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private String getConfigOutput(String servletPath) {
        StringBuffer result = new StringBuffer();
        result.append("<form method=get action=");
        result.append(String.valueOf(servletPath) + ">\n");
        result.append("<br/>\n");
        result.append("Write Profile Prefix: <input type=\"text\" name=\"prefix\" value=\"" + this.writeProfileID + "\"/>\n");
        result.append("<input type=\"hidden\" name=\"Action\" value=\"0\"/>\n");
        result.append("<input type=\"submit\" name=\"Set\" value=\"Set\">\n");
        result.append("</form>\n");
        return result.toString();
    }

    protected String getHtml(HttpServletRequest request) {
        StringBuffer result = new StringBuffer(1024);
        String queryStr = request.getQueryString();
        if (queryStr != null) {
            this.processRequest(request);
        }
        result.append("<h1> LLRP Write Profile Console </h1>");
        result.append("<br/>");
        result.append(this.getConfigOutput(request.getServletPath()));
        result.append("<br/>");
        result.append("<table border=\"0\">");
        result.append("<tr><td align=\"left\" valign=\"top\">");
        result.append("<table border=\"0\">");
        result.append("<tr><td align=\"left\" valign=\"top\">");
        Iterator ops = this.operations.values().iterator();
        while (ops.hasNext()) {
            IOperation op = (IOperation)ops.next();
            if (op.getName().equals(this.history.getName())) continue;
            result.append(op.linkOutput(request.getServletPath()));
            result.append("<br/>");
        }
        result.append("</td></tr>");
        result.append("<tr><td>&nbsp;</td></tr>");
        result.append("<tr><td align=\"left\" valign=\"bottom\">");
        result.append(this.history.linkOutput(request.getServletPath()));
        result.append("</td></tr>");
        result.append("</table>");
        result.append("</td>");
        result.append("<td align=\"left\">");
        result.append("<table frame=\"border\"><tr><td align=\"left\">");
        result.append(this.getSelectedOperation(request.getServletPath()));
        result.append("</td></tr></table>");
        result.append("</td>");
        result.append("</tr>");
        result.append("<tr>");
        result.append("<td colspan=\"2\">&nbsp;</td>");
        result.append("</tr>");
        result.append("<tr>");
        result.append("<td>&nbsp;</td>");
        result.append("<td");
        result.append(this.getOperationLineOutput(request.getServletPath()));
        result.append("</td></tr>");
        result.append("</table>");
        return result.toString();
    }

    private String getOperationLineOutput(String servletPath) {
        StringBuffer result = new StringBuffer();
        result.append("<table border=\"0\">\n");
        result.append("<form method=get action=");
        result.append(String.valueOf(servletPath) + ">\n");
        result.append("<tr><td colspan=\"5\" align=\"left\">\n");
        result.append("<h4>Operations:</h4>\n");
        result.append("</td></tr>\n");
        result.append("<tr><td colspan=\"5\" align=\"left\">\n");
        result.append("<input type=\"text\" name=\"CurrOperations\" value=\"" + this.operationLine + "\" size=\"100\" />\n");
        result.append("</td></tr>\n");
        result.append("<tr>\n");
        result.append("<td align=\"left\">");
        result.append("<table border=\"0\"\n");
        result.append("<tr>");
        result.append("<td align=\"left\">");
        result.append("<input type=\"checkbox\" name=\"sendOnly\" value=\"true\"" + (this.updateOnly ? "checked=\"checked\"" : "") + "/>");
        result.append("</td>\n");
        result.append("<td align=\"left\">Update Only</td>\n");
        result.append("</tr></table>\n");
        result.append("<td align=\"left\" colspan=\"4\">&nbsp;</td>");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("<td align=\"left\" valign=\"top\">\n");
        result.append("<input type=\"hidden\" name=\"Action\" value=\"3\"/>\n");
        result.append("<input type=\"submit\" name=\"Go\" value=\"Go\">\n");
        result.append("</td>\n");
        result.append("</form>\n");
        result.append("<td align=\"left\">\n");
        result.append("<form method=get action=");
        result.append(String.valueOf(servletPath) + ">\n");
        result.append("<input type=\"hidden\" name=\"Action\" value=\"4\"/>\n");
        result.append("<input type=\"submit\" name=\"Stop\" value=\"Stop\">\n");
        result.append("</form>\n");
        result.append("</td>\n");
        result.append("<td align=\"left\">\n");
        result.append("<form method=get action=");
        result.append(String.valueOf(servletPath) + ">\n");
        result.append("<input type=\"hidden\" name=\"Action\" value=\"5\"/>\n");
        result.append("<input type=\"submit\" name=\"Clean\" value=\"Clean\">\n");
        result.append("</form>\n");
        result.append("</td>\n");
        result.append("<td align=\"left\">\n");
        result.append("<form method=get action=");
        result.append(String.valueOf(servletPath) + ">\n");
        result.append("<input type=\"hidden\" name=\"Action\" value=\"6\"/>\n");
        result.append("<input type=\"submit\" name=\"Get Report\" value=\"Get Report\">\n");
        result.append("</form>\n");
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("<td colspan=\"5\">&nbsp;</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("<td colspan=\"5\" align=\"left\">\n");
        result.append(this.reportsHtml);
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    private String getSelectedOperation(String servletPath) {
        IOperation operation = (IOperation)this.operations.get(this.selectedOperation);
        return operation.htmlOutput(servletPath);
    }

    public String getServletAlias() {
        return SERVLET_ALIAS;
    }

    private void processReports() {
        List reports = this.writeProfileConsole.getReports();
        StringBuffer result = new StringBuffer();
        result.append("<table border=\"0\">\n");
        result.append("<tr>\n");
        result.append("<th>&nbsp;</th>\n");
        result.append("<th>&nbsp;</th>\n");
        result.append("<th>Tag</th>\n");
        result.append("<th>&nbsp;</th>\n");
        result.append("<th>OperationId</th>\n");
        result.append("<th>&nbsp;</th>\n");
        result.append("<th>Result Code</th>\n");
        result.append("<th>&nbsp;</th>\n");
        result.append("<th>Read Result</th>\n");
        result.append("</tr>\n");
        int num = 0;
        int i = 0;
        while (i < reports.size()) {
            result.append("<tr>\n");
            Map tags = (Map)reports.get(i);
            Iterator tagIds = tags.entrySet().iterator();
            while (tagIds.hasNext()) {
                Map.Entry entry1 = tagIds.next();
                String tagId = (String)entry1.getKey();
                Map tagOpResult = (Map)entry1.getValue();
                result.append("<td>" + ++num + ".</td>\n");
                result.append("<td>&nbsp;</td>\n");
                result.append("<td align=\"center\">");
                result.append(tagId);
                result.append("</td>\n");
                result.append("<td>&nbsp;</td>\n");
                Iterator opIds = tagOpResult.entrySet().iterator();
                while (opIds.hasNext()) {
                    Map.Entry entry2 = opIds.next();
                    String opId = (String)entry2.getKey();
                    Map opResult = (Map)entry2.getValue();
                    Number result_code = (Number)opResult.get("resultCode");
                    byte[] readData = (byte[])opResult.get("readData");
                    result.append("<td align=\"center\">");
                    result.append(opId);
                    result.append("</td>\n");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("<td align=\"center\">");
                    if (result_code != null) {
                        result.append(result_code);
                    }
                    result.append("</td>");
                    result.append("<td>&nbsp;</td>\n");
                    result.append("<td align=\"center\">");
                    if (readData != null) {
                        String readDataStr = LLRPUtils.byteArray2Str((byte[])readData);
                        result.append(readDataStr);
                    }
                    result.append("</td>");
                }
            }
            result.append("</tr>\n");
            ++i;
        }
        result.append("</table>\n");
        this.reportsHtml = result.toString();
    }

    public void processRequest(DeviceServletContext context) {
        HttpServletRequest request = context.getRequest();
        context.println(this.getHtml(request));
    }

    private void processRequest(HttpServletRequest request) {
        String action = request.getParameter("Action");
        if (action == null) {
            return;
        }
        int actionId = Integer.valueOf(action);
        switch (actionId) {
            case 0: {
                this.writeProfileID = request.getParameter(PREFIX);
                break;
            }
            case 1: {
                this.selectedOperation = request.getParameter("OPName");
                break;
            }
            case 2: {
                String opName = request.getParameter("OPName");
                IOperation op = (IOperation)this.operations.get(opName);
                op.setValues(request);
                this.addOperation(op.opOutput());
                break;
            }
            case 7: {
                String opName = request.getParameter("OPName");
                IOperation op = (IOperation)this.operations.get(opName);
                op.setValues(request);
                break;
            }
            case 3: {
                this.history.setValues(request);
                this.operationLine = request.getParameter("CurrOperations");
                this.updateOnly = Boolean.valueOf(request.getParameter("sendOnly"));
                this.writeProfileConsole.sendWriteOperationsRequest(this.writeProfileID, this.operationLine);
                if (this.updateOnly) break;
                this.writeProfileConsole.sendWriteOperationsExecuteRequest(this.writeProfileID, "");
                break;
            }
            case 4: {
                this.writeProfileConsole.sendWriteOperationsStopRequest(this.writeProfileID, "");
                break;
            }
            case 5: {
                this.operationLine = "";
                break;
            }
            case 6: {
                this.processReports();
            }
        }
    }
}

