/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileOutputTestCase
extends GpioProfileAbstractTestCase {
    private long outputCount;
    static /* synthetic */ Class class$0;

    public GpioProfileOutputTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileOutputTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
        this.outputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceOutputCountExternalKey).toString());
    }

    public void test010_ClearOutputExpressions() throws InterruptedException {
        if (this.outputCount < 1L) {
            return;
        }
        long counter = 1L;
        while (counter <= this.outputCount) {
            String preTopic = "Gpio/Output" + counter + "Expression";
            String topic = this.prependPrefix(preTopic);
            String filter = "";
            this.writeMeasurement(topic, filter);
            ++counter;
        }
    }

    public void test020_TurnAllOn() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.outputCount) {
            data.put(new String("o" + i), Boolean.TRUE);
            expectedValue.put(new String("o" + i), Boolean.TRUE);
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7508))));
    }

    public void test030_TurnAllOff() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.outputCount) {
            data.put(new String("o" + i), Boolean.FALSE);
            expectedValue.put(new String("o" + i), Boolean.FALSE);
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7509))));
    }

    public void test040_TurnFirstOn() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        data.put(new String("o1"), Boolean.TRUE);
        expectedValue.put(new String("o1"), Boolean.TRUE);
        int i = 2;
        while ((long)i <= this.outputCount) {
            data.put(new String("o" + i), Boolean.FALSE);
            expectedValue.put(new String("o" + i), Boolean.FALSE);
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7510))));
    }

    public void test050_TurnFirstOff() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        data.put(new String("o1"), Boolean.FALSE);
        expectedValue.put(new String("o1"), Boolean.FALSE);
        int i = 2;
        while ((long)i <= this.outputCount) {
            data.put(new String("o" + i), Boolean.TRUE);
            expectedValue.put(new String("o" + i), Boolean.TRUE);
            ++i;
        }
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7511))));
    }

    public void test060_TurnLastOn() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < this.outputCount) {
            data.put(new String("o" + i), Boolean.FALSE);
            expectedValue.put(new String("o" + i), Boolean.FALSE);
            ++i;
        }
        data.put(new String("o" + this.outputCount), Boolean.TRUE);
        expectedValue.put(new String("o" + this.outputCount), Boolean.TRUE);
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7512))));
    }

    public void test070_TurnLastOff() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < this.outputCount) {
            data.put(new String("o" + i), Boolean.TRUE);
            expectedValue.put(new String("o" + i), Boolean.TRUE);
            ++i;
        }
        data.put(new String("o" + this.outputCount), Boolean.FALSE);
        expectedValue.put(new String("o" + this.outputCount), Boolean.FALSE);
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7513))));
    }

    public void test080_Turn_0_On() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.outputCount) {
            expectedValue.put(new String("o" + i), Boolean.TRUE);
            ++i;
        }
        data.put(new String("o0"), Boolean.TRUE);
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7508))));
    }

    public void test090_Turn_0_Off() throws InterruptedException, IOException {
        if (this.outputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> data = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.outputCount) {
            expectedValue.put(new String("o" + i), Boolean.FALSE);
            ++i;
        }
        data.put(new String("o0"), Boolean.FALSE);
        this.executeCommand(this.gpioProfileServiceOutputRequestExternalKey, data);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceOutputExternalKey);
        GpioProfileOutputTestCase.assertEquals(expectedValue, (Object)realValue);
        GpioProfileOutputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7509))));
    }
}

