/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.simulator;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.SocketException;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.matrix.lcd.simulator.Queue;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.MatrixCorpLcdSimulatorAwtView;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.LcdViewListener;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.MatrixCorpSimulatorView;
import org.eclipse.soda.dk.tcpip.server.connection.TcpipServerConnection;

public class MatrixCorpLcdSimulator
implements LcdViewListener {
    private static final int DEFAULT_PORT = 9234;
    private Connection connection;
    private MatrixCorpSimulatorView ui;
    private Queue processingQueue = new Queue();
    private int port;
    private boolean power = false;
    private boolean connected = false;
    private boolean waitingForConnection = false;
    private boolean connectionProcessing = false;
    private boolean eventProcessing = false;

    public MatrixCorpLcdSimulator() {
        this(9234);
    }

    public MatrixCorpLcdSimulator(int port) {
        this.port = port;
    }

    public void buttonPressed(int button) {
        byte byteToSend = 0;
        switch (button) {
            case 2: {
                byteToSend = 74;
                break;
            }
            case 5: {
                byteToSend = 72;
                break;
            }
            case 6: {
                byteToSend = 78;
                break;
            }
            case 7: {
                byteToSend = 77;
                break;
            }
            case 3: {
                byteToSend = 79;
                break;
            }
            case 4: {
                byteToSend = 69;
                break;
            }
            case 1: {
                byteToSend = 73;
                break;
            }
            case 0: {
                boolean bl = this.power = !this.power;
                if (this.power) {
                    this.turnOn();
                    break;
                }
                this.turnOff();
            }
        }
        if (byteToSend != 0) {
            this.sendBytes(new byte[]{byteToSend});
        }
    }

    private void closeConnection() {
        this.setConnected(false);
        this.setConnectionProcessing(false);
        try {
            this.getConnection().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    private int getLength(byte identifier) {
        switch (identifier) {
            case 58: 
            case 71: {
                return 4;
            }
            case 66: 
            case 80: 
            case 85: 
            case 86: 
            case 126: {
                return 3;
            }
        }
        return 2;
    }

    protected Queue getProcessingQueue() {
        return this.processingQueue;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected boolean isConnectionProcessing() {
        return this.connectionProcessing;
    }

    protected boolean isEventProcessing() {
        return this.eventProcessing;
    }

    private boolean isPrintable(byte b) {
        return b == 10 || b == 13 || b >= 32 && b <= 126;
    }

    protected boolean isWaitingForConnection() {
        return this.waitingForConnection;
    }

    private MatrixCorpSimulatorView makeUI() {
        MatrixCorpLcdSimulatorAwtView view = new MatrixCorpLcdSimulatorAwtView();
        view.setListener(this);
        return view;
    }

    private void processEvents() {
        this.setEventProcessing(true);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    while (MatrixCorpLcdSimulator.this.isEventProcessing()) {
                        byte[] command = (byte[])MatrixCorpLcdSimulator.this.getProcessingQueue().remove();
                        MatrixCorpLcdSimulator.this.uiAction(command);
                    }
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread thread = new Thread(runnable, "Event Processing Thread");
        thread.start();
    }

    protected void processTcpipData() {
        byte[] bytes = new byte[10000];
        int bytesRead = 0;
        while (this.isConnectionProcessing() && this.isConnected()) {
            try {
                try {
                    bytesRead = this.getConnection().read(bytes, 0, bytes.length);
                }
                catch (InterruptedIOException interruptedIOException) {
                    bytesRead = 0;
                }
                catch (SocketException socketException) {
                    bytesRead = 0;
                    this.closeConnection();
                    if (this.power) {
                        this.waitForConnection();
                    }
                }
                catch (IOException e) {
                    bytesRead = 0;
                    e.printStackTrace();
                }
                if (bytesRead > 0) {
                    int current = 0;
                    while (current < bytesRead) {
                        if (bytes[current] == -2) {
                            int length = this.getLength(bytes[current + 1]);
                            byte[] messageBytes = new byte[length];
                            System.arraycopy(bytes, current, messageBytes, 0, length);
                            this.getProcessingQueue().add(messageBytes);
                            current += length;
                            continue;
                        }
                        byte[] messageBytes = new byte[]{bytes[current]};
                        this.processingQueue.add(messageBytes);
                        ++current;
                    }
                    continue;
                }
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setConnectionProcessing(false);
            }
        }
    }

    private void sendBytes(byte[] bytes) {
        if (this.isConnected()) {
            try {
                this.getConnection().write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setConnected(boolean connected) {
        this.connected = connected;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected void setConnectionProcessing(boolean connectionProcessing) {
        this.connectionProcessing = connectionProcessing;
    }

    protected void setEventProcessing(boolean eventProcessing) {
        this.eventProcessing = eventProcessing;
    }

    protected void setProcessingQueue(Queue processingQueue) {
        this.processingQueue = processingQueue;
    }

    protected void setWaitingForConnection(boolean waitingForConnection) {
        this.waitingForConnection = waitingForConnection;
    }

    public void shutdown() {
        this.setConnectionProcessing(false);
        this.setEventProcessing(false);
        this.closeConnection();
        this.ui.shutdown();
        System.out.println("Program Finished.");
        System.exit(0);
    }

    public void simulatorClosed() {
        this.power = false;
        this.shutdown();
    }

    protected void startTcpipProcessing() {
        this.setConnectionProcessing(true);
        Runnable processor = new Runnable(){

            public void run() {
                MatrixCorpLcdSimulator.this.processTcpipData();
            }
        };
        Thread thread = new Thread(processor, "Tcpip Processing Thread");
        thread.start();
    }

    public void startup() {
        this.ui = this.makeUI();
        this.ui.startup();
        this.setConnection((Connection)new TcpipServerConnection(this.port, 1, 200));
    }

    private void stopEventProcessing() {
        this.setEventProcessing(false);
    }

    private void stopTcpipProcessing() {
        this.setConnectionProcessing(false);
    }

    private void turnOff() {
        this.setWaitingForConnection(false);
        this.closeConnection();
        this.stopTcpipProcessing();
        this.stopEventProcessing();
        this.ui.togglePower(false);
    }

    private void turnOn() {
        this.waitForConnection();
        this.processEvents();
        this.ui.togglePower(true);
    }

    protected void uiAction(byte[] command) {
        if (command[0] == -2) {
            switch (command[1]) {
                case 71: {
                    this.ui.goToPosition(command[2], command[3]);
                    break;
                }
                case 72: {
                    this.ui.goToPosition(0, 0);
                    break;
                }
                case 76: {
                    this.ui.decrementPosition();
                    break;
                }
                case 77: {
                    this.ui.incrementPosition();
                    break;
                }
                case 88: {
                    this.ui.clearDisplay();
                    break;
                }
                case 66: {
                    this.ui.backlightOn();
                    break;
                }
                case 70: {
                    this.ui.backlightOff();
                }
            }
        } else if (this.isPrintable(command[0]) && command.length == 1) {
            this.ui.printCharacter(command[0]);
        }
    }

    private void waitForConnection() {
        this.setWaitingForConnection(true);
        Runnable runnable = new Runnable(){

            public void run() {
                MatrixCorpLcdSimulator.this.setConnected(false);
                while (MatrixCorpLcdSimulator.this.isWaitingForConnection()) {
                    try {
                        MatrixCorpLcdSimulator.this.getConnection().open();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        try {
                            MatrixCorpLcdSimulator.this.getConnection().close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    catch (BindException bindException) {
                        try {
                            MatrixCorpLcdSimulator.this.setWaitingForConnection(false);
                            MatrixCorpLcdSimulator.this.getConnection().close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        MatrixCorpLcdSimulator.this.setWaitingForConnection(false);
                        e.printStackTrace();
                    }
                    if (!MatrixCorpLcdSimulator.this.getConnection().isOpen()) continue;
                    MatrixCorpLcdSimulator.this.setWaitingForConnection(false);
                    MatrixCorpLcdSimulator.this.setConnected(true);
                    MatrixCorpLcdSimulator.this.startTcpipProcessing();
                }
            }
        };
        Thread thread = new Thread(runnable, "Connection Waiting Thread");
        thread.start();
    }
}

