/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.simulator.view;

import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.SimulatorPanel;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.Constants;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.LcdDisplayPanelConstants;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.LcdViewListener;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.MatrixCorpSimulatorView;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.interfaces.SimulatorPanelListener;

public class MatrixCorpLcdSimulatorAwtView
extends Frame
implements MatrixCorpSimulatorView,
Constants,
SimulatorPanelListener,
WindowListener {
    private static final long serialVersionUID = 49549769767248817L;
    private SimulatorPanel panel;
    private LcdViewListener listener;

    public static void main(String[] args) {
        new MatrixCorpLcdSimulatorAwtView().startup();
    }

    public void backlightOff() {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().turnOffBacklight();
        }
    }

    public void backlightOn() {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().turnOnBacklight();
        }
    }

    public void clearDisplay() {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().clearText();
        }
    }

    public void decrementPosition() {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().decrementCursorPosition();
        }
    }

    protected void disableButtons() {
        this.getPanel().getUpButton().setEnabled(false);
        this.getPanel().getLeftButton().setEnabled(false);
        this.getPanel().getDownButton().setEnabled(false);
        this.getPanel().getRightButton().setEnabled(false);
        this.getPanel().getF1Button().setEnabled(false);
        this.getPanel().getF2Button().setEnabled(false);
        this.getPanel().getEnterButton().setEnabled(false);
    }

    protected void enableButtons() {
        this.getPanel().getUpButton().setEnabled(true);
        this.getPanel().getLeftButton().setEnabled(true);
        this.getPanel().getDownButton().setEnabled(true);
        this.getPanel().getRightButton().setEnabled(true);
        this.getPanel().getF1Button().setEnabled(true);
        this.getPanel().getF2Button().setEnabled(true);
        this.getPanel().getEnterButton().setEnabled(true);
    }

    public SimulatorPanel getPanel() {
        return this.panel;
    }

    public void goToPosition(int x, int y) {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().sendCursorToPosition(x, y);
        }
    }

    public void incrementPosition() {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().incrementCursorPosition();
        }
    }

    protected void initialize() {
        this.addWindowListener(this);
        if (this.getPanel() != null) {
            this.disableButtons();
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (this.getPanel() != null && this.listener != null) {
            if (event.getSource().equals(this.getPanel().getUpButton())) {
                this.listener.buttonPressed(1);
            } else if (event.getSource().equals(this.getPanel().getDownButton())) {
                this.listener.buttonPressed(2);
            } else if (event.getSource().equals(this.getPanel().getLeftButton())) {
                this.listener.buttonPressed(3);
            } else if (event.getSource().equals(this.getPanel().getRightButton())) {
                this.listener.buttonPressed(4);
            } else if (event.getSource().equals(this.getPanel().getF1Button())) {
                this.listener.buttonPressed(6);
            } else if (event.getSource().equals(this.getPanel().getF2Button())) {
                this.listener.buttonPressed(7);
            } else if (event.getSource().equals(this.getPanel().getEnterButton())) {
                this.listener.buttonPressed(5);
            } else if (event.getSource().equals(this.getPanel().getPowerButton())) {
                this.listener.buttonPressed(0);
            }
        }
    }

    protected void populate() {
        this.setTitle("Matrix Lcd Simulator");
        this.panel = new SimulatorPanel();
        this.panel.setSimulatorPanelListener(this);
        this.add(this.panel);
    }

    public void printCharacter(byte c) {
        if (this.getPanel() != null) {
            this.getPanel().getLcdDisplayPanel().printCharacter(c);
        }
    }

    public void setListener(LcdViewListener listener) {
        this.listener = listener;
    }

    public void setPanel(SimulatorPanel panel) {
        this.panel = panel;
    }

    public void shutdown() {
        this.dispose();
    }

    public void startup() {
        this.setSize(758, 183);
        this.populate();
        this.initialize();
        this.show();
    }

    public void togglePower(boolean state) {
        if (this.getPanel() != null) {
            if (state) {
                this.enableButtons();
                this.getPanel().getPowerButton().toggleState();
                this.getPanel().getLcdDisplayPanel().turnOnBacklight();
                this.getPanel().getLcdDisplayPanel().printString(LcdDisplayPanelConstants.DEFAULT_BUFFER_CONTENTS.toString());
                this.getPanel().getLcdDisplayPanel().sendCursorToPosition(0, 0);
            } else {
                this.disableButtons();
                this.getPanel().getPowerButton().toggleState();
                this.getPanel().getLcdDisplayPanel().turnOffBacklight();
                this.getPanel().getLcdDisplayPanel().clearText();
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.listener != null) {
            this.listener.simulatorClosed();
        } else {
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

