/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.multiplex.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.MultiplexConnection;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public abstract class ChannelBinding
extends EscObject
implements ChannelService {
    public static final String[] STATE_STRINGS = new String[]{"DEAD", "CREATED", "ALIVE", "CONNECTED", "ACTIVE", "STARTED"};
    private ChannelListener listener;
    private int state;
    protected String id;
    private String externalId;
    private Map sessionData = new HashMap();

    protected ChannelBinding(String id) {
        this.id = id;
    }

    public void close() {
        this.setState(1);
    }

    public void exit() {
        this.close();
        this.setState(0);
    }

    public Map getChannelData() {
        return this.sessionData;
    }

    public ConfigurationService getConfigurationService() {
        return this.listener.getConfigurationService();
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getId() {
        return this.id;
    }

    public ChannelListener getListener() {
        return this.listener;
    }

    public Object getLogDetails4() {
        return this.listener;
    }

    public String getResource(int resourceId) {
        return MultiplexConnection.getDefaultResource((int)resourceId);
    }

    public int getState() {
        return this.state;
    }

    public void open() {
        if (this.state < 3) {
            this.setState(3);
        }
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
        this.listener.channelChanged((ChannelService)this, this.state, this.state);
    }

    public void setListener(ChannelListener listener) {
        this.listener = listener;
    }

    public void setState(int newState) {
        int oldState = this.state;
        this.state = newState;
        this.listener.channelChanged((ChannelService)this, newState, oldState);
        this.report(null, MultiplexConnection.CHANNEL_STATE_RESOURCE_TABLE[newState], STATE_STRINGS[oldState]);
    }

    public void start() {
        if (this.state == 3) {
            this.setState(4);
        }
    }

    public void stop() {
        if (this.state > 3) {
            this.setState(3);
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(",id=");
        buffer.append(this.getId());
        buffer.append(",externalId=");
        buffer.append(this.getExternalId());
    }
}

