/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.multiplex.connection;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.connection.Connection;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionService;

public abstract class MultiplexConnection
extends Connection
implements MultiplexConnectionService,
ChannelListener {
    protected static final int[] CHANNEL_STATE_RESOURCE_TABLE = new int[]{1008, 1009, 1010, 1011, 1012, 1013};
    private MultiplexConnectionListener connectionListener;
    private long nextChannelId;
    private Map channels = Collections.synchronizedMap(new HashMap());

    public void channelChanged(ChannelService channel, int newState, int oldState) {
        if (oldState == 0) {
            this.channels.put(channel.getId(), channel);
        }
        this.connectionListener.channelChanged(channel, newState, oldState);
        if (newState == 0) {
            this.channels.remove(channel.getId());
        }
    }

    protected synchronized String createChannelId() {
        return Long.toString(this.nextChannelId++);
    }

    public synchronized ChannelService getChannel(String channelId) {
        return (ChannelService)this.channels.get(channelId);
    }

    public Map getChannels() {
        return this.channels;
    }

    public MultiplexConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        switch (errorNumber) {
            case 1017: 
            case 1018: {
                return 5;
            }
            case 1016: {
                return 3;
            }
            case 1014: 
            case 1015: {
                return 4;
            }
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public int read(ChannelService channel, byte[] bytes) throws IOException {
        return this.read(channel, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionListener(MultiplexConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        Map map = this.channels;
        synchronized (map) {
            Iterator iterator = this.channels.values().iterator();
            while (iterator.hasNext()) {
                ChannelService channel = (ChannelService)iterator.next();
                connectionListener.channelChanged(channel, channel.getState(), channel.getState());
            }
        }
    }

    public void write(ChannelService channel, byte[] bytes) throws IOException {
        this.write(channel, bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return 0;
    }
}

