/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.multiplex.connection;

import java.io.IOException;
import java.util.Map;
import org.eclipse.soda.dk.connection.TraceConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionService;
import org.eclipse.soda.dk.nls.Nls;

public class TraceMultiplexConnection
extends TraceConnection
implements MultiplexConnectionService {
    public TraceMultiplexConnection(ConnectionService connection) {
        super(connection);
    }

    public ChannelService getChannel(String channelId) {
        return this.getMultiplexConnectionService().getChannel(channelId);
    }

    public Map getChannels() {
        return this.getMultiplexConnectionService().getChannels();
    }

    public MultiplexConnectionListener getConnectionListener() {
        return this.getMultiplexConnectionService().getConnectionListener();
    }

    public MultiplexConnectionService getMultiplexConnectionService() {
        return (MultiplexConnectionService)this.getConnectionService();
    }

    public ChannelService openChannel(String channelSpec) throws IOException {
        if (TraceMultiplexConnection.getTraceLevel() >= 7) {
            this.report(null, 1016, channelSpec);
        }
        return this.getMultiplexConnectionService().openChannel(channelSpec);
    }

    public int read(ChannelService channel, byte[] bytes) throws IOException {
        int result = this.getMultiplexConnectionService().read(channel, bytes);
        if (result > 0 && TraceMultiplexConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)result);
            this.report(null, 1017, channel, details);
        }
        return result;
    }

    public int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        int result = this.getMultiplexConnectionService().read(channel, bytes, offset, length);
        if (result > 0 && TraceMultiplexConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)result);
            this.report(null, 1017, channel, details);
        }
        return result;
    }

    public void setConnectionListener(MultiplexConnectionListener listener) {
        this.getMultiplexConnectionService().setConnectionListener(listener);
    }

    public void write(ChannelService channel, byte[] bytes) throws IOException {
        this.getMultiplexConnectionService().write(channel, bytes);
        if (TraceMultiplexConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)0, (int)bytes.length);
            this.report(null, 1018, channel, details);
        }
    }

    public void write(ChannelService channel, byte[] bytes, int offset, int count) throws IOException {
        this.getMultiplexConnectionService().write(channel, bytes, offset, count);
        if (TraceMultiplexConnection.getTraceLevel() >= 7) {
            String details = Nls.formatHexBytes((byte[])bytes, (int)offset, (int)count);
            this.report(null, 1018, channel, details);
        }
    }

    public void processEvents() throws Exception {
        this.getMultiplexConnectionService().processEvents();
    }
}

