/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.net.InetAddress;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.service.ConfigurableService;
import org.eclipse.soda.dk.notification.NotificationDataExtension;
import org.eclipse.soda.dk.notification.NotificationExtensions;
import org.eclipse.soda.dk.notification.NotificationMonitor;
import org.eclipse.soda.dk.notification.NotificationMonitors;
import org.eclipse.soda.dk.notification.NotificationResourceBase;
import org.eclipse.soda.dk.notification.NotificationResourceBundle;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;

public abstract class NotificationBase
extends NotificationResourceBase {
    protected static long NotifyThresholdDefault = NotificationBase.getNotifyThresholdDefault();
    protected static long BroadcastThresholdDefault = NotificationBase.getBroadcastThresholdDefault();
    protected static long NotificationId = 0L;
    protected static String NotificationHost = NotificationBase.getHost();
    protected long notifyThreshold = NotificationBase.getNotifyThresholdDefault();
    protected long notifyCount = 0L;
    protected long notifyThresholdCount = 0L;
    protected String prefixStatus = "Status";
    protected long broadcastThreshold = NotificationBase.getBroadcastThresholdDefault();
    protected long broadcastCount = 0L;
    protected NotificationExtensionService notificationExtension = null;
    protected NotificationMonitorService notificationMonitor = null;
    protected long broadcastThresholdCount = 0L;
    protected int level = 5;
    protected int levelMinimum = 0;
    protected int levelMaximum = 10;

    public static long getBroadcastThresholdDefault() {
        try {
            long value = NotificationBase.getStaticLong((String)"notification.broadcastthreshold", (long)-1L);
            return value;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String getHost() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            if (address != null) {
                String name = address.getHostName();
                if (name.equals("localhost")) {
                    return address.getHostAddress();
                }
                return name;
            }
        }
        catch (Exception exception) {}
        return "localhost";
    }

    public static long getNotifyThresholdDefault() {
        try {
            long value = NotificationBase.getStaticLong((String)"notification.notifythreshold", (long)-1L);
            return value;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static void setBroadcastThresholdDefault(long broadcastThreshold) {
        BroadcastThresholdDefault = broadcastThreshold;
    }

    public static void setNotifyThresholdDefault(long threshold) {
        NotifyThresholdDefault = threshold;
    }

    protected NotificationBase() {
    }

    public synchronized void addNotificationExtension(NotificationExtensionService notificationExtension) {
        this.setNotificationExtension(NotificationExtensions.add(this.getNotificationExtension(), notificationExtension));
    }

    public synchronized void addNotificationMonitor(NotificationMonitorService notificationMonitor) {
        this.setNotificationMonitor(NotificationMonitors.add(this.getNotificationMonitor(), notificationMonitor));
    }

    public void broadcast(String key, Dictionary value) {
    }

    public void broadcastStatus() {
        Dictionary map = this.getStatusInfo();
        this.broadcast(this.prefixStatus, map);
    }

    public void exit() {
        this.broadcastStatus();
    }

    public long getBroadcastThreshold() {
        return this.broadcastThreshold;
    }

    public Dictionary getConfigurationInformation() {
        Dictionary configuration = super.getConfigurationInformation();
        if (configuration == null) {
            this.putConfigurationInformation("broadcastthreshold", NotificationBase.createNumber((long)this.getBroadcastThreshold()));
            this.putConfigurationInformation("notifythreshold", NotificationBase.createNumber((long)this.getNotifyThreshold()));
            this.putConfigurationInformation("level", NotificationBase.createInteger((int)this.getLevel()));
        }
        return configuration;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLevelMaximum() {
        return this.levelMaximum;
    }

    public int getLevelMinimum() {
        return this.levelMinimum;
    }

    public NotificationExtensionService getNotificationExtension() {
        return this.notificationExtension;
    }

    public NotificationMonitorService getNotificationMonitor() {
        return this.notificationMonitor;
    }

    public long getNotifyThreshold() {
        return this.notifyThreshold;
    }

    public String getResource(int resourceId) {
        return NotificationResourceBase.DefaultResourceBundle.getString(NotificationResourceBundle.getKey(resourceId));
    }

    public Dictionary getStatusInfo() {
        Hashtable<String, Dictionary> map = new Hashtable<String, Dictionary>();
        Dictionary configuration = this.getConfigurationInformation();
        if (configuration != null) {
            ((Dictionary)map).put("configuration", configuration);
        }
        return map;
    }

    public void putConfigurationInformation(String propertyName, Object value) {
        super.putConfigurationInformation(propertyName, value);
    }

    public synchronized void removeNotificationExtension(NotificationExtensionService notificationExtension) {
        this.setNotificationExtension(NotificationExtensions.remove(this.getNotificationExtension(), notificationExtension));
    }

    public synchronized void removeNotificationMonitor(NotificationMonitorService notificationMonitor) {
        this.setNotificationMonitor(NotificationMonitors.remove(this.getNotificationMonitor(), notificationMonitor));
    }

    public void setBroadcastThreshold(long broadcastThreshold) {
        this.broadcastThreshold = broadcastThreshold;
        this.putConfigurationInformation("broadcastthreshold", NotificationBase.createNumber((long)broadcastThreshold));
    }

    public void setConfigurationInformation(Dictionary configurationInformation) {
        super.setConfigurationInformation(configurationInformation);
        this.setLevel(this.getInt("level", 5));
        this.setBroadcastThreshold(this.getLong("broadcastthreshold", BroadcastThresholdDefault));
        this.setNotifyThreshold(this.getLong("notifythreshold", NotifyThresholdDefault));
        this.updateConfiguration();
    }

    public void setLevel(int level) {
        this.level = level;
        this.putConfigurationInformation("level", NotificationBase.createInteger((int)level));
    }

    public void setLevelMaximum(int levelMaximum) {
        this.levelMaximum = levelMaximum;
    }

    public void setLevelMinimum(int levelMinimum) {
        this.levelMinimum = levelMinimum;
    }

    public void setNotificationExtension(NotificationExtensionService notificationExtension) {
        this.notificationExtension = notificationExtension;
        this.updateConfiguration(notificationExtension);
    }

    public void setNotificationMonitor(NotificationMonitorService notificationMonitor) {
        this.notificationMonitor = notificationMonitor;
        this.updateConfiguration(notificationMonitor);
    }

    public void setNotifyThreshold(long notifyThreshold) {
        this.notifyThreshold = notifyThreshold;
        this.putConfigurationInformation("notifythreshold", NotificationBase.createNumber((long)notifyThreshold));
    }

    public void setup() {
        NotificationDataExtension notificationExtension = new NotificationDataExtension();
        this.addNotificationExtension(notificationExtension);
        NotificationMonitor notificationMonitor = new NotificationMonitor();
        this.addNotificationMonitor(notificationMonitor);
    }

    public void start() {
        this.updateConfiguration();
        this.handleError(null, 100);
    }

    public void updateConfiguration() {
        NotificationExtensionService extensionService = this.getNotificationExtension();
        this.updateConfiguration(extensionService);
        NotificationMonitorService notificationMonitor = this.getNotificationMonitor();
        this.updateConfiguration(notificationMonitor);
        this.broadcastStatus();
    }

    public void updateConfiguration(Object object) {
        if (object instanceof ConfigurableService) {
            ConfigurableService configurableObject = (ConfigurableService)object;
            configurableObject.setConfigurationInformation(this.getConfigurationInformation());
        }
    }
}

