/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.event.admin;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.event.admin.NotificationEvent;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventAdminHandler
extends NotificationBase
implements EventHandler {
    protected NotificationListener notificationListener = null;
    protected ServiceRegistration serviceRegistration = null;
    protected String[] topics = new String[0];

    public EventAdminHandler(NotificationListener notificationListener, String[] topics) {
        this(notificationListener, topics, null);
    }

    public EventAdminHandler(NotificationListener notificationListener, String[] topics, NotificationExtensionService notificationExtension) {
        this.notificationListener = notificationListener;
        this.topics = topics;
        this.setNotificationExtension(notificationExtension);
    }

    public void addTopics(String[] externalKeys) {
        int size = this.topics.length;
        String[] newTopics = new String[size + externalKeys.length];
        System.arraycopy(this.topics, 0, newTopics, 0, size);
        System.arraycopy(externalKeys, 0, newTopics, size, externalKeys.length);
        this.topics = newTopics;
        if (this.serviceRegistration != null) {
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>(3);
            properties.put("event.topics", this.topics);
            this.serviceRegistration.setProperties(properties);
        }
    }

    public ServiceRegistration getServiceRegistration() {
        return this.serviceRegistration;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void handleEvent(Event event) {
        if (this.notificationListener != null) {
            String[] topics = event.getPropertyNames();
            if (topics.length == 0) {
                this.notify(event, null);
            } else if (event instanceof NotificationEvent) {
                NotificationEvent notificationEvent = (NotificationEvent)event;
                Dictionary data = notificationEvent.getDictionary();
                this.notify(event, data);
            } else {
                Hashtable<String, Object> data = new Hashtable<String, Object>((topics.length << 1) - 1);
                int i = 0;
                while (i < topics.length) {
                    String key = topics[i];
                    Object value = event.getProperty(key);
                    data.put(key, value);
                    ++i;
                }
                this.notify(event, data);
            }
        }
    }

    public void notify(Event event, Dictionary data) {
        int level = this.getLevel();
        ++this.notifyCount;
        String topic = event.getTopic();
        if (level > 0) {
            NotificationExtensionService notificationExtensionService;
            int receive = 0;
            if (level >= 2 && (notificationExtensionService = this.getNotificationExtension()) != null) {
                receive = notificationExtensionService.receiving(topic, data);
            }
            if (receive == 0) {
                NotificationMonitorService notificationMonitor = this.getNotificationMonitor();
                if (level >= 4 && notificationMonitor != null) {
                    long startTime = System.currentTimeMillis();
                    this.notificationListener.notificationReceived(topic, data);
                    long endTime = System.currentTimeMillis();
                    long delta = endTime - startTime;
                    notificationMonitor.notified(this.notificationListener, topic, data, delta);
                } else {
                    this.notificationListener.notificationReceived(topic, data);
                }
            }
        } else {
            this.notificationListener.notificationReceived(topic, data);
        }
    }

    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public void setTopics(String[] topics) {
        this.topics = topics;
    }
}

