/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification.event.admin;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.event.admin.EventAdminHandler;
import org.eclipse.soda.dk.notification.event.admin.NotificationEvent;
import org.eclipse.soda.dk.notification.service.NotificationExtendableService;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class NotificationEventAdmin
extends NotificationBase
implements NotificationExtendableService {
    protected EventAdmin eventAdmin;
    protected BundleContext bundleContext;
    protected Map notificationListeners = new Hashtable();
    static /* synthetic */ Class class$0;

    public void broadcast(String externalKey, Dictionary data) {
        if (this.eventAdmin != null) {
            int level = this.getLevel();
            Event event = null;
            int send = 0;
            if (data == null) {
                event = new Event(externalKey, null);
            } else {
                NotificationExtensionService notificationExtensionService;
                Notification.addData(externalKey, data, this.getLevel());
                if (level >= 2 && (notificationExtensionService = this.getNotificationExtension()) != null) {
                    send = notificationExtensionService.sending(externalKey, data);
                }
                event = new NotificationEvent(externalKey, data);
            }
            if (send == 0) {
                ++this.broadcastCount;
                NotificationMonitorService notificationMonitor = this.getNotificationMonitor();
                if (level >= 4 && notificationMonitor != null) {
                    long startTime = System.currentTimeMillis();
                    this.eventAdmin.postEvent(event);
                    long endTime = System.currentTimeMillis();
                    long delta = endTime - startTime;
                    notificationMonitor.sent(externalKey, data, delta);
                } else {
                    this.eventAdmin.postEvent(event);
                }
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public NotificationExtensionService getNotificationExtension() {
        return this.notificationExtension;
    }

    public void register(String externalKey, NotificationListener listener) {
        this.register(new String[]{externalKey}, listener);
    }

    public void register(String[] externalKeys, NotificationListener listener) {
        EventAdminHandler eventAdminHandler = (EventAdminHandler)((Object)this.notificationListeners.get(listener));
        if (this.bundleContext != null) {
            if (eventAdminHandler == null) {
                EventAdminHandler eventAdminHandlerNew = new EventAdminHandler(listener, externalKeys);
                this.notificationListeners.put(listener, eventAdminHandlerNew);
                Hashtable<String, String[]> properties = new Hashtable<String, String[]>(3);
                properties.put("event.topics", externalKeys);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ServiceRegistration serviceRegistration = this.bundleContext.registerService(clazz.getName(), (Object)eventAdminHandlerNew, properties);
                eventAdminHandlerNew.setServiceRegistration(serviceRegistration);
            } else {
                eventAdminHandler.addTopics(externalKeys);
            }
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setNotificationExtension(NotificationExtensionService notificationExtension) {
        this.notificationExtension = notificationExtension;
    }

    public void unregister(NotificationListener listener) {
        EventAdminHandler eventAdminHandler = (EventAdminHandler)((Object)this.notificationListeners.get(listener));
        if (this.bundleContext != null && eventAdminHandler != null) {
            ServiceRegistration serviceRegistration = eventAdminHandler.getServiceRegistration();
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
            this.notificationListeners.remove(listener);
        }
    }
}

