/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;

public class NotificationMonitor
extends NotificationBase
implements NotificationMonitorService {
    protected long notifyThresholdCurrent = NotificationMonitor.getNotifyThresholdDefault();

    public long getNotifyThresholdCurrent() {
        return this.notifyThresholdCurrent;
    }

    public int notified(NotificationListener notificationListener, String topic, Dictionary data, long time) {
        long notifyThresholdCurrent = this.getNotifyThresholdCurrent();
        if (notifyThresholdCurrent >= 0L && time >= notifyThresholdCurrent) {
            ++this.notifyThresholdCount;
            Object[] objects = new Object[]{topic, data, NotificationMonitor.createLong((long)time), notificationListener};
            this.handleError(null, 103, objects);
        }
        return 0;
    }

    public int sent(String topic, Dictionary data, long time) {
        if (this.broadcastThreshold >= 0L && time >= this.broadcastThreshold) {
            ++this.broadcastThresholdCount;
            Object[] objects = new Object[]{topic, data, NotificationMonitor.createLong((long)time)};
            this.handleError(null, 102, objects);
        }
        return 0;
    }

    public void setNotifyThreshold(long notifyThreshold) {
        super.setNotifyThreshold(notifyThreshold);
        this.setNotifyThresholdCurrent(notifyThreshold);
    }

    public void setNotifyThresholdCurrent(long notifyThresholdCurrent) {
        long notifyThreshold = this.getNotifyThreshold();
        this.notifyThresholdCurrent = notifyThreshold < 0L ? 500L : notifyThresholdCurrent;
    }
}

