/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import org.eclipse.soda.dk.notification.service.NotificationListener;

public class NotificationListeners
implements NotificationListener {
    private NotificationListener[] objects;

    public NotificationListeners(NotificationListener[] objects) {
        this.setObjects(objects);
    }

    public NotificationListeners(NotificationListener currentObject, NotificationListener newObject) {
        if (currentObject instanceof NotificationListeners) {
            NotificationListeners currentMulticaster = (NotificationListeners)currentObject;
            NotificationListener[] oldList = currentMulticaster.getObjects();
            this.objects = new NotificationListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new NotificationListener[]{currentObject, newObject};
        }
    }

    public static NotificationListener add(NotificationListener currentObject, NotificationListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new NotificationListeners(currentObject, newObject);
    }

    public static NotificationListener remove(NotificationListener currentObject, NotificationListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof NotificationListeners) {
            return ((NotificationListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public NotificationListener[] getObjects() {
        return this.objects;
    }

    public void notificationReceived(String topic, Dictionary data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].notificationReceived(topic, data);
            }
            catch (RuntimeException exception) {
                exception.printStackTrace();
                throw exception;
            }
            ++i;
        }
    }

    protected NotificationListener remove(NotificationListener removeHandler) {
        NotificationListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        NotificationListener[] newList = new NotificationListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new NotificationListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(NotificationListener[] objects) {
        this.objects = objects;
    }
}

