/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;

public class NotificationMonitors
extends EscObject
implements NotificationMonitorService {
    private NotificationMonitorService[] objects;

    public static NotificationMonitorService add(NotificationMonitorService currentObject, NotificationMonitorService newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new NotificationMonitors(currentObject, newObject);
    }

    public static NotificationMonitorService remove(NotificationMonitorService currentObject, NotificationMonitorService removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof NotificationMonitors) {
            return ((NotificationMonitors)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public NotificationMonitors(NotificationMonitorService currentObject, NotificationMonitorService newObject) {
        if (currentObject instanceof NotificationMonitors) {
            NotificationMonitors currentMulticaster = (NotificationMonitors)currentObject;
            NotificationMonitorService[] oldList = currentMulticaster.getObjects();
            this.objects = new NotificationMonitorService[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new NotificationMonitorService[2];
            this.objects[0] = currentObject;
            this.objects[1] = newObject;
        }
    }

    public NotificationMonitors(NotificationMonitorService[] objects) {
        this.setObjects(objects);
    }

    public NotificationMonitorService[] getObjects() {
        return this.objects;
    }

    public int notified(NotificationListener notificationListener, String topic, Dictionary data, long time) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].notified(notificationListener, topic, data, time);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
        return 0;
    }

    protected NotificationMonitorService remove(NotificationMonitorService removeHandler) {
        NotificationMonitorService[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        NotificationMonitorService[] newList = new NotificationMonitorService[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new NotificationMonitors(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    public int sent(String topic, Dictionary data, long time) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].sent(topic, data, time);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
        return 0;
    }

    public void setConfigurationInformation(Dictionary dictionary) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                NotificationMonitorService extensionService = this.objects[i];
                if (extensionService instanceof ConfigurableObject) {
                    ConfigurableObject configurableObject = (ConfigurableObject)extensionService;
                    configurableObject.setConfigurationInformation(dictionary);
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    private void setObjects(NotificationMonitorService[] objects) {
        this.objects = objects;
    }
}

