/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.checker;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.platform.validation.test.checker.DeclarationInfo;

public abstract class MemberInfo
extends DeclarationInfo {
    private static final long serialVersionUID = 5557080597081390489L;
    private static Map primitiveTypes = new HashMap();
    private String typeDescriptor;

    static {
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("void", Void.TYPE);
    }

    public MemberInfo() {
    }

    public MemberInfo(String name, int accessFlags, String typeDescriptor) {
        super(name, accessFlags);
        this.typeDescriptor = typeDescriptor;
    }

    public static Class getType(String typeDescriptor) throws ClassNotFoundException {
        Class<?> cls;
        if (typeDescriptor == null) {
            cls = null;
        } else {
            cls = (Class<?>)primitiveTypes.get(typeDescriptor);
            if (cls == null) {
                cls = Class.forName(typeDescriptor);
            }
        }
        return cls;
    }

    public Class getType() throws ClassNotFoundException {
        return MemberInfo.getType(this.typeDescriptor);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }
}

