/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.random.access.file.connection;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.random.access.file.connection.service.RandomAccessFileConnectionService;

public class RandomAccessFileConnection
extends StreamConnection
implements ConnectionService,
RandomAccessFileConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.random.access.file.connection.RandomAccessFileConnection";
    private RandomAccessFile randomAccessFile = null;

    public RandomAccessFileConnection() {
        this("", "filename", "rw");
    }

    public RandomAccessFileConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    public RandomAccessFileConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public RandomAccessFileConnection(RandomAccessFile randomAccessFile) {
        this.setRandomAccessFile(randomAccessFile);
    }

    public RandomAccessFileConnection(String path, String filename, String mode) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("path", path);
        table.put("name", filename);
        table.put("mode", mode);
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        super.close();
        if (randomAccessFile != null) {
            Exception exception = null;
            try {
                randomAccessFile.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.setRandomAccessFile(null);
            this.handleError(exception, 1002, this.toString());
        }
    }

    public void exit() throws IOException {
        try {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        this.randomAccessFile = null;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public synchronized void open() throws IOException {
        String mode = this.getString("mode", "rw");
        if (this.getRandomAccessFile() == null) {
            String filename = this.getString("name", "filename");
            String path = this.getString("path", "");
            if (filename != null) {
                if (path != null && path.length() > 0) {
                    this.setRandomAccessFile(new RandomAccessFile(new File(path, filename), mode));
                } else {
                    this.setRandomAccessFile(new RandomAccessFile(new File(filename), mode));
                }
            }
        }
        super.open();
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        return randomAccessFile.read(bytes, offset, length);
    }

    public void setRandomAccessFile(RandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        String path = this.getString("path", "");
        if (path.length() > 0) {
            buffer.append(path);
            buffer.append(File.separatorChar);
        }
        String filename = this.getString("name", "filename");
        buffer.append(filename);
    }

    public void write(byte[] bytes, int offset, int count) throws IOException {
        RandomAccessFile randomAccessFile = this.getRandomAccessFile();
        randomAccessFile.write(bytes, offset, count);
    }
}

