/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.base.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.rfid.inventory.profile.service.RfidInventoryProfileService;
import org.eclipse.soda.dk.script.service.ScriptService;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidBaseProfile
extends Profile
implements RfidInventoryProfileService {
    public static final int REPORT_LEVEL_MINIMUM = 1;
    public static final int REPORT_LEVEL_READERS = 2;
    public static final int REPORT_LEVEL_ANTENNAS = 3;
    public static final int REPORT_LEVEL_SUMMARY = 5;
    public static final int REPORT_LEVEL_REPORTS = 8;
    public static final int REPORT_LEVEL_MAXIMUM = 10;
    public static final int REPORT_LEVEL_NORMAL = 5;
    public static final int REPORT_LEVEL_DEFAULT = 5;
    public static final int LEVEL_TOP = 0;
    public static final int LEVEL_READER = 1;
    public static final int LEVEL_ANTENNA = 2;
    public static final int LEVEL_REPORT = 3;
    public static final Number StandardScoreDefault = new Float(0.0);
    protected ScriptService confidenceScriptService;
    protected Map cachedTags = new Hashtable(1031);
    protected Map superCache = new Hashtable();
    protected Hashtable ldapMap = new Hashtable(67);

    public static Map buildSummary(Map tags) {
        HashMap<String, Number> summary = new HashMap<String, Number>(1031);
        long totalCount = 0L;
        long peakRssiMaximumOverall = Long.MIN_VALUE;
        long peakRssiMinimumOverall = Long.MAX_VALUE;
        long timestampFirstOverall = Long.MAX_VALUE;
        long timestampLastOverall = Long.MIN_VALUE;
        Set entrySet = tags.entrySet();
        long tagCount = entrySet.size();
        int[] peakRssiMaximumValues = new int[512];
        int[] peakRssiMinimumValues = new int[512];
        summary.put("tagCount", RfidBaseProfile.createNumber((long)tagCount));
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            long timestampLast;
            Object timestampLastObject;
            long timestampFirst;
            Object timestampFirstObject;
            Object peakRssiMinimumObject;
            Map.Entry entry = iterator.next();
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map reads = (Map)value;
            Object countObject = reads.get("count");
            int count = 1;
            if (countObject instanceof Number) {
                count = ((Number)countObject).intValue();
            }
            totalCount += (long)count;
            Object peakRssiMaximumObject = reads.get("peakRSSIMaximum");
            if (peakRssiMaximumObject instanceof Number) {
                int peakRssiMaximum = ((Number)peakRssiMaximumObject).intValue();
                int index = peakRssiMaximum + 128;
                index = Math.max(0, index);
                int n = index = Math.min(511, index);
                peakRssiMaximumValues[n] = peakRssiMaximumValues[n] + 1;
                if ((long)peakRssiMaximum > peakRssiMaximumOverall) {
                    peakRssiMaximumOverall = peakRssiMaximum;
                }
            }
            if ((peakRssiMinimumObject = reads.get("peakRSSIMinimum")) instanceof Number) {
                int peakRssiMinimum = ((Number)peakRssiMinimumObject).intValue();
                int index = peakRssiMinimum + 128;
                index = Math.max(0, index);
                int n = index = Math.min(511, index);
                peakRssiMinimumValues[n] = peakRssiMinimumValues[n] + 1;
                if ((long)peakRssiMinimum < peakRssiMinimumOverall) {
                    peakRssiMinimumOverall = peakRssiMinimum;
                }
            }
            if ((timestampFirstObject = reads.get("timestampFirst")) instanceof Number && (timestampFirst = ((Number)timestampFirstObject).longValue()) < timestampFirstOverall) {
                timestampFirstOverall = timestampFirst;
            }
            if (!((timestampLastObject = reads.get("timestampLast")) instanceof Number) || (timestampLast = ((Number)timestampLastObject).longValue()) <= timestampLastOverall) continue;
            timestampLastOverall = timestampLast;
        }
        summary.put("peakRSSIMaximumMedian", RfidBaseProfile.computeMedianRssi(peakRssiMaximumValues, tagCount));
        summary.put("peakRSSIMinimumMedian", RfidBaseProfile.computeMedianRssi(peakRssiMinimumValues, tagCount));
        Number peakRssiMaximumAverage = RfidBaseProfile.computeAverageRssi(peakRssiMaximumValues, tagCount);
        summary.put("peakRSSIMaximumAverage", peakRssiMaximumAverage);
        Number peakRssiMinimumAverage = RfidBaseProfile.computeAverageRssi(peakRssiMinimumValues, tagCount);
        summary.put("peakRSSIMinimumAverage", peakRssiMinimumAverage);
        double peakRssiMaximumAverageValue = peakRssiMaximumAverage.doubleValue();
        Number peakRssiMaximumStandardDeviation = RfidBaseProfile.computeStandardDeviationRssi(peakRssiMaximumValues, tagCount, peakRssiMaximumAverageValue);
        double peakRssiMaximumStandardDeviationValue = peakRssiMaximumStandardDeviation.doubleValue();
        summary.put("peakRSSIMaximumStandardDeviation", peakRssiMaximumStandardDeviation);
        double peakRssiMinimumAverageValue = peakRssiMinimumAverage.doubleValue();
        Number peakRssiMinimumStandardDeviation = RfidBaseProfile.computeStandardDeviationRssi(peakRssiMinimumValues, tagCount, peakRssiMinimumAverageValue);
        double peakRssiMinimumStandardDeviationValue = peakRssiMinimumStandardDeviation.doubleValue();
        summary.put("peakRSSIMinimumStandardDeviation", peakRssiMinimumStandardDeviation);
        summary.put("count", RfidBaseProfile.createNumber((long)totalCount));
        double countAverage = (double)totalCount / (double)tagCount;
        summary.put("countAverage", new Double(countAverage));
        summary.put("peakRSSIMaximum", RfidBaseProfile.createNumber((long)peakRssiMaximumOverall));
        summary.put("peakRSSIMinimum", RfidBaseProfile.createNumber((long)peakRssiMinimumOverall));
        summary.put("timestampFirst", RfidBaseProfile.createNumber((long)timestampFirstOverall));
        summary.put("timestampLast", RfidBaseProfile.createNumber((long)timestampLastOverall));
        Iterator iterator2 = entrySet.iterator();
        while (iterator2.hasNext()) {
            Object peakRssiMinimumObject;
            Map.Entry entry = iterator2.next();
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map reads = (Map)value;
            Object peakRssiMaximumObject = reads.get("peakRSSIMaximum");
            if (peakRssiMaximumObject instanceof Number) {
                int peakRssiMaximum = ((Number)peakRssiMaximumObject).intValue();
                double peakRssiMaximumStandardScoreValue = ((double)peakRssiMaximum - peakRssiMaximumAverageValue) / peakRssiMaximumStandardDeviationValue;
                reads.put("peakRSSIMaximumStandardScore", new Double(peakRssiMaximumStandardScoreValue));
            }
            if (!((peakRssiMinimumObject = reads.get("peakRSSIMinimum")) instanceof Number)) continue;
            int peakRssiMinimum = ((Number)peakRssiMinimumObject).intValue();
            double peakRssiMinimumStandardScoreValue = ((double)peakRssiMinimum - peakRssiMinimumAverageValue) / peakRssiMinimumStandardDeviationValue;
            reads.put("peakRSSIMinimumStandardScore", new Double(peakRssiMinimumStandardScoreValue));
        }
        return summary;
    }

    public static int computeAntennaFactor(Map antennasMap) {
        if (antennasMap != null) {
            int antennasCount = antennasMap.size();
            int antennaEven = 0;
            int antennaOdd = 0;
            if (antennasCount > 1) {
                Iterator iterator = antennasMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = String.valueOf(iterator.next());
                    if (key.length() <= 0) continue;
                    char lastCharacter = key.charAt(key.length() - 1);
                    if (lastCharacter % 2 == 0) {
                        ++antennaEven;
                        continue;
                    }
                    ++antennaOdd;
                }
                int bothFactor = Math.min(antennaEven, antennaOdd);
                int antennaFactor = antennasCount;
                if (antennasCount > 2) {
                    antennaFactor *= 2;
                }
                return antennaFactor += bothFactor;
            }
        }
        return 1;
    }

    public static Number computeAverageRssi(int[] values, long count) {
        int length = values.length;
        if (length > 0) {
            long runningCount = 0L;
            int i = 0;
            while (i < length) {
                int value = values[i];
                if (value > 0) {
                    runningCount += (long)(value * (i - 128));
                }
                ++i;
            }
            return new Double((double)runningCount / (double)count);
        }
        return RfidBaseProfile.createNumber((long)0L);
    }

    public static Number computeMedianRssi(int[] values, long count) {
        block9: {
            int length = values.length;
            if (length <= 0) break block9;
            int runningCount = 0;
            if (count % 2L == 0L) {
                long secondMiddleIndex = count / 2L;
                long firstMiddleIndex = secondMiddleIndex - 1L;
                int firstMedian = Integer.MIN_VALUE;
                int i = 0;
                while (i < length) {
                    if (values[i] != 0) {
                        if ((long)(runningCount += values[i]) >= firstMiddleIndex && firstMedian == Integer.MIN_VALUE) {
                            firstMedian = i - 128;
                        }
                        if ((long)runningCount >= secondMiddleIndex) {
                            long secondMedian = i - 128;
                            long totalMedian = (long)firstMedian + secondMedian;
                            if (totalMedian % 2L == 0L) {
                                return RfidBaseProfile.createNumber((long)(totalMedian / 2L));
                            }
                            double median = (double)totalMedian / 2.0;
                            return new Double(median);
                        }
                    }
                    ++i;
                }
            } else {
                long mid = count / 2L;
                int i = 0;
                while (i < length) {
                    if ((long)(runningCount += values[i]) >= mid) {
                        return RfidBaseProfile.createNumber((long)(i - 128));
                    }
                    ++i;
                }
            }
        }
        return RfidBaseProfile.createNumber((long)0L);
    }

    public static Number computeStandardDeviationRssi(int[] values, long count, double average) {
        int length = values.length;
        if (length > 0) {
            double runningCount = 0.0;
            int i = 0;
            while (i < length) {
                int value = values[i];
                if (value > 0) {
                    double difference = (double)(i - 128) - average;
                    double square = difference * difference;
                    runningCount += (double)value * square;
                }
                ++i;
            }
            double averageDifference = runningCount / (double)count;
            return new Double(Math.sqrt(averageDifference));
        }
        return RfidBaseProfile.createNumber((long)0L);
    }

    public static Number getStandardScoreDefault() {
        return StandardScoreDefault;
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestMasks parseInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = RfidBaseProfile.parseDelimitedByToken(targetTagConfig, ";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = RfidBaseProfile.parseDelimitedByToken(masksConfig[i], ",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = RfidBaseProfile.parseHexSpaceDelimited(configParam[3]);
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        char[] characters = string.toCharArray();
        int length = characters.length + 1 >> 1;
        byte[] tag = new byte[length];
        int index = characters.length % 2;
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            int digit = character - 48;
            if (digit < 0) {
                throw new NumberFormatException();
            }
            if (digit > 9 && ((digit = character - 87) & 0xFFFFFFF0) != 0 && ((digit = character - 55) & 0xFFFFFFF0) != 0) {
                throw new NumberFormatException();
            }
            tag[index >> 1] = index % 2 == 0 ? (byte)(digit << 4) : (byte)((tag[index >> 1] & 0xF0) + digit);
            ++index;
            ++i;
        }
        return tag;
    }

    public static void updateFieldTotal(Map targetMap, Map reads, String fieldName, Object fieldValue) {
        Object cacheObject = targetMap.get(fieldName);
        if (cacheObject instanceof Number) {
            long value = ((Number)fieldValue).longValue();
            long cacheValue = ((Number)cacheObject).longValue();
            targetMap.put(fieldName, RfidBaseProfile.createNumber((long)(value += cacheValue)));
        } else {
            targetMap.put(fieldName, fieldValue);
        }
    }

    protected RfidBaseProfile() {
    }

    protected RfidBaseProfile(String capabilities, String status, String configuration) {
        super(capabilities, status, configuration);
    }

    protected RfidBaseProfile(String capabilities, String status, String configuration, String metrics) {
        super(capabilities, status, configuration, metrics);
    }

    protected void addTagToCache(String key, Map reads, Map cache) {
        cache.put(key, reads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuperCache() {
        Map map = this.superCache;
        synchronized (map) {
            int globalSize = this.superCache.size();
            int delta = globalSize - this.getSuperCacheMaximumSizeValue();
            if (delta > 0) {
                ArrayList<String> keysList = new ArrayList<String>(delta);
                Iterator iterator = this.superCache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object key = entry.getKey();
                    Map value = (Map)entry.getValue();
                    Object timestampObject = value.get("timestamp");
                    if (!(timestampObject instanceof Number)) continue;
                    StringBuffer buffer = new StringBuffer(64);
                    long timestamp = ((Number)timestampObject).longValue();
                    buffer.append(Nls.formatTimestamp((long)timestamp));
                    buffer.append('\u0000');
                    buffer.append(key);
                    keysList.add(buffer.toString());
                }
                String[] keys = new String[keysList.size()];
                keys = keysList.toArray(keys);
                int i = 0;
                while (i < delta) {
                    String bigKey = keys[i];
                    int index = bigKey.lastIndexOf(0);
                    String key = bigKey.substring(index + 1);
                    this.superCache.remove(key);
                    ++i;
                }
            }
        }
    }

    protected Filter createLdapFilter(String filterString) throws InvalidSyntaxException {
        Filter result = this.createFilter(filterString);
        return result;
    }

    public void flushTagCache() {
        this.cachedTags = new Hashtable(1031);
    }

    public ScriptService getConfidenceScriptService() {
        return this.confidenceScriptService;
    }

    public String getReaderId() {
        String id = this.getId();
        if (id != null && id.length() > 0) {
            return id;
        }
        String idName = this.getIdName();
        if (idName != null && idName.length() > 0) {
            return idName;
        }
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            return prefix;
        }
        return this.getOutputName();
    }

    public abstract MeasurementService getReportLevel();

    public int getReportLevelValue() {
        Object tagAntennaReportLevelObject = this.getReportLevel().getValue();
        if (tagAntennaReportLevelObject instanceof Number) {
            int tagAntennaReportLevelValue = ((Number)tagAntennaReportLevelObject).intValue();
            return tagAntennaReportLevelValue;
        }
        return 5;
    }

    public Map getSuperCache() {
        return this.superCache;
    }

    public abstract MeasurementService getSuperCacheMaximumSize();

    public int getSuperCacheMaximumSizeValue() {
        MeasurementService superCacheMaximumSizeObject = this.getSuperCacheMaximumSize();
        if (superCacheMaximumSizeObject instanceof Number) {
            return ((Number)superCacheMaximumSizeObject).intValue();
        }
        return 0;
    }

    public void setConfidenceScriptService(ScriptService confidenceScriptService) {
        this.confidenceScriptService = confidenceScriptService;
    }

    public void setSuperCache(Map globalSuperCache) {
        this.superCache = globalSuperCache;
    }

    public long updateMap(Map targetMap, Map sourceMap, int antenna, int level) {
        Object timestampFirst = null;
        Object timestampLast = null;
        long peakRssiMaximum = -128L;
        long peakRssiMinimum = 127L;
        long count = 0L;
        long peakRssiTotal = 0L;
        int antennaReportCount = 0;
        int antennaReportCountWeighted = 0;
        Iterator iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            long cacheValue;
            long value;
            Object cacheObject;
            Map.Entry entry = iterator.next();
            String ekey = String.valueOf(entry.getKey());
            Object evalue = entry.getValue();
            if (ekey.equals("peakRSSI")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value <= (cacheValue = ((Number)cacheObject).longValue())) continue;
                    targetMap.put("peakRSSI", evalue);
                    continue;
                }
                targetMap.put("peakRSSI", evalue);
                continue;
            }
            if (ekey.equals("peakRSSIMaximum")) {
                if (level >= 3 || !(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                peakRssiMaximum = value = ((Number)evalue).longValue();
                if (cacheObject instanceof Number) {
                    cacheValue = ((Number)cacheObject).longValue();
                    if (value > cacheValue) {
                        targetMap.put("peakRSSIMaximum", evalue);
                        continue;
                    }
                    peakRssiMaximum = cacheValue;
                    continue;
                }
                targetMap.put("peakRSSIMaximum", evalue);
                continue;
            }
            if (ekey.equals("peakRSSIMinimum")) {
                if (level >= 3 || !(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                peakRssiMinimum = value = ((Number)evalue).longValue();
                if (cacheObject instanceof Number) {
                    cacheValue = ((Number)cacheObject).longValue();
                    if (value < cacheValue) {
                        targetMap.put("peakRSSIMinimum", evalue);
                        continue;
                    }
                    peakRssiMinimum = cacheValue;
                    continue;
                }
                targetMap.put("peakRSSIMinimum", evalue);
                continue;
            }
            if (ekey.equals("peakRSSITotal")) {
                if (level >= 3 || !(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    cacheValue = ((Number)cacheObject).longValue();
                    peakRssiTotal = value + cacheValue;
                    targetMap.put("peakRSSITotal", RfidBaseProfile.createNumber((long)peakRssiTotal));
                    continue;
                }
                targetMap.put("peakRSSITotal", evalue);
                continue;
            }
            if (ekey.equals("count")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    cacheValue = ((Number)cacheObject).longValue();
                    count = value + cacheValue;
                    targetMap.put("count", RfidBaseProfile.createNumber((long)count));
                    continue;
                }
                targetMap.put("count", evalue);
                continue;
            }
            if (ekey.equals("timestampLast")) {
                if (!(evalue instanceof Number)) continue;
                timestampLast = evalue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value > (cacheValue = ((Number)cacheObject).longValue())) {
                        targetMap.put("timestampLast", evalue);
                        continue;
                    }
                    timestampLast = cacheObject;
                    continue;
                }
                targetMap.put("timestampLast", evalue);
                continue;
            }
            if (ekey.equals("timestampFirst")) {
                if (!(evalue instanceof Number)) continue;
                timestampFirst = evalue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value < (cacheValue = ((Number)cacheObject).longValue())) {
                        targetMap.put("timestampFirst", evalue);
                        continue;
                    }
                    timestampFirst = cacheObject;
                    continue;
                }
                targetMap.put("timestampFirst", evalue);
                continue;
            }
            if (ekey.equals("timestamp")) {
                targetMap.put("timestamp", evalue);
                continue;
            }
            if (ekey.equals("readersMap") || ekey.equals("antennasMap") || level != 0) continue;
            targetMap.put(ekey, evalue);
        }
        if (count > 0L) {
            float average = (float)peakRssiTotal / (float)count;
            targetMap.put("peakRSSIAverage", new Float(average));
        }
        long duration = 0L;
        if (timestampLast instanceof Number && timestampFirst instanceof Number) {
            long first = ((Number)timestampFirst).longValue();
            long last = ((Number)timestampLast).longValue();
            duration = last - first;
            targetMap.put("duration", RfidBaseProfile.createNumber((long)duration));
        }
        long peakRssiRange = peakRssiMinimum - peakRssiMinimum;
        targetMap.put("peakRSSIRange", RfidBaseProfile.createNumber((long)peakRssiRange));
        if (level < 3) {
            Object result;
            antennaReportCountWeighted = 1;
            switch (level) {
                case 0: {
                    antennaReportCount = 0;
                    Object readersMapObject = targetMap.get("readersMap");
                    if (!(readersMapObject instanceof Map)) break;
                    Map readersMap = (Map)readersMapObject;
                    Iterator iterator2 = readersMap.values().iterator();
                    while (iterator2.hasNext()) {
                        Map readerMap = (Map)iterator2.next();
                        Object antennasMapObject = readerMap.get("antennasMap");
                        if (!(antennasMapObject instanceof Map)) continue;
                        Map antennasMap = (Map)antennasMapObject;
                        antennaReportCount += antennasMap.size();
                        int antennaReportCountWeightedSingle = RfidBaseProfile.computeAntennaFactor(antennasMap);
                        antennaReportCountWeighted = Math.max(antennaReportCountWeighted, antennaReportCountWeightedSingle);
                    }
                    break;
                }
                case 1: {
                    Object antennasMapObject = targetMap.get("antennasMap");
                    if (!(antennasMapObject instanceof Map)) break;
                    Map antennasMap = (Map)antennasMapObject;
                    antennaReportCount = antennasMap.size();
                    antennaReportCountWeighted = RfidBaseProfile.computeAntennaFactor(antennasMap);
                    break;
                }
                case 2: {
                    antennaReportCount = 1;
                }
            }
            if (antennaReportCount == 0) {
                ++antennaReportCount;
            }
            if (antennaReportCount > 0) {
                targetMap.put("antennaReportCount", RfidBaseProfile.createNumber((long)antennaReportCount));
            }
            long antennaFactor = antennaReportCountWeighted * antennaReportCountWeighted;
            long countFactor = count;
            long peakRssiMaximumAdjusted = peakRssiMaximum + 128L;
            long peakRssiFactor = peakRssiMaximumAdjusted * peakRssiMaximumAdjusted;
            long confidence = antennaFactor * (countFactor + peakRssiFactor);
            ScriptService confidenceScriptService = this.getConfidenceScriptService();
            if (confidenceScriptService != null && (result = confidenceScriptService.evaluate(targetMap)) instanceof Number) {
                confidence = ((Number)result).longValue();
            }
            targetMap.put("confidence", RfidBaseProfile.createNumber((long)confidence));
            return confidence;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map updateSuperCache(Map tagMap) {
        if (this.getSuperCacheMaximumSizeValue() < 1) {
            return tagMap;
        }
        HashMap resultMap = new HashMap(1031);
        Map map = this.superCache;
        synchronized (map) {
            Object currentTimestamp = RfidBaseProfile.getCurrentTimestamp();
            Iterator iterator = tagMap.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean add;
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                Map value = (Map)entry.getValue();
                Map globalMap = (Map)this.superCache.get(key);
                Object confidenceObject = value.get("confidence");
                Object timestampObject = value.get("timestamp");
                boolean bl = add = globalMap == null;
                if (globalMap != null) {
                    Object confidenceGlobalObject = globalMap.get("confidence");
                    if (confidenceGlobalObject instanceof Number && confidenceObject instanceof Number) {
                        long confidenceGlobal = ((Number)confidenceGlobalObject).longValue();
                        long confidence = ((Number)confidenceObject).longValue();
                        if (confidence > confidenceGlobal) {
                            add = true;
                        } else if (timestampObject == null) {
                            globalMap.put("timestamp", currentTimestamp);
                        } else {
                            globalMap.put("timestamp", timestampObject);
                        }
                    } else {
                        add = true;
                    }
                }
                if (!add) continue;
                resultMap.put(key, value);
                HashMap<String, Object> smallMap = new HashMap<String, Object>();
                if (confidenceObject == null) {
                    smallMap.put("confidence", RfidBaseProfile.createNumber((long)0L));
                } else {
                    smallMap.put("confidence", confidenceObject);
                }
                if (timestampObject == null) {
                    smallMap.put("timestamp", currentTimestamp);
                } else {
                    smallMap.put("timestamp", timestampObject);
                }
                Object readerObject = value.get("reader");
                if (readerObject == null) {
                    smallMap.put("reader", this.getReaderId());
                } else {
                    smallMap.put("reader", readerObject);
                }
                this.superCache.put(key, smallMap);
            }
        }
        this.checkSuperCache();
        return resultMap;
    }

    public void updateTagInCache(String key, Map reads, Map cache, Object timestamp) {
        Map cacheReadData = (Map)cache.get(key);
        if (cacheReadData == null) {
            this.addTagToCache(key, new Hashtable(reads), cache);
        } else {
            Object readersMapObject;
            int antenna;
            Object antennaObject;
            boolean update = false;
            int tagAntennaReportLevelValue = this.getReportLevelValue();
            if (tagAntennaReportLevelValue >= 5 && (antennaObject = reads.get("antenna")) instanceof Number && (antenna = ((Number)antennaObject).intValue()) > 0 && (readersMapObject = cacheReadData.get("readersMap")) instanceof Map) {
                Map readerInfo;
                Object antennaMapObject;
                Map antennaMap;
                Map readersMap = (Map)readersMapObject;
                String readerName = (String)reads.get("reader");
                if (readerName == null) {
                    readerName = this.getReaderId();
                }
                Map map = antennaMap = (antennaMapObject = (readerInfo = (Map)readersMap.get(readerName)).get("antennasMap")) instanceof Map ? (Map)antennaMapObject : new Hashtable();
                if (antennaMapObject == null) {
                    readerInfo.put("antennasMap", antennaMap);
                }
                String antennaKey = Integer.toString(antenna);
                Object antennaInfoObject = antennaMap.get(antennaKey);
                Hashtable<String, Map> antennaInfo = null;
                if (antennaInfoObject instanceof Map) {
                    antennaInfo = (Hashtable<String, Map>)antennaInfoObject;
                    if (tagAntennaReportLevelValue >= 8) {
                        Map reportsMap = (Map)antennaInfo.get("reportsMap");
                        antennaInfo.put("reportsMap", reportsMap);
                        HashMap reportMap = new HashMap(101);
                        this.updateMap(reportMap, reads, antenna, 3);
                        reportsMap.put(Integer.toString(reportsMap.size() + 1), reportMap);
                    }
                } else {
                    antennaInfo = new Hashtable<String, Map>();
                    antennaMap.put(antennaKey, antennaInfo);
                    if (tagAntennaReportLevelValue >= 8) {
                        HashMap reportsMap = new HashMap(101);
                        antennaInfo.put("reportsMap", reportsMap);
                        HashMap reportMap = new HashMap(101);
                        this.updateMap(reportMap, reads, antenna, 3);
                        reportsMap.put("1", reportMap);
                    }
                }
                this.updateMap(antennaInfo, reads, antenna, 2);
                this.updateMap(readerInfo, reads, antenna, 1);
                this.updateMap(cacheReadData, reads, antenna, 0);
                update = true;
            }
            if (!update) {
                this.updateMap(cacheReadData, reads, -1, 0);
            }
        }
    }
}

