/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.profile;

import java.io.Serializable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.parameter.BaseParameter;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.base.profile.RfidBaseProfile;
import org.eclipse.soda.dk.rfid.inventory.profile.ExpressionFilterResults;
import org.eclipse.soda.dk.rfid.inventory.profile.service.RfidInventoryProfileService;
import org.eclipse.soda.dk.script.ScriptManager;
import org.eclipse.soda.dk.script.service.ScriptService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidInventoryProfile
extends RfidBaseProfile
implements ProfileService,
RfidInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    public static final String POSITION_PROFILE_PREFIX = "PositionProfilePrefix";
    private static final Byte COMMAND_DEACTIVATE_BY_MEASUREMENT_BYTE = new Byte(0);
    private static final byte COMMAND_DEACTIVATE_BY_MEASUREMENT = 0;
    private static final Byte COMMAND_ACTIVATE_BY_MEASUREMENT_BYTE = new Byte(1);
    private static final byte COMMAND_ACTIVATE_BY_MEASUREMENT = 1;
    protected String gpioProfileServiceInputExternalKey = null;
    protected String gpioProfileServiceInputGetExternalKey = null;
    protected String gpioProfileServiceAnalogInputExternalKey = null;
    protected String gpioProfileServiceAnalogInputGetExternalKey = null;
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    protected String positionProfileServiceCoordinateExternalKey = null;
    protected String positionProfileServiceCoordinateGetExternalKey = null;
    protected final MethodMeasurement tagReadingExpression = new MethodMeasurement("RfidInventory/TagReadingExpression", (Object)"");
    protected final MethodMeasurement tagReading = new MethodMeasurement("RfidInventory/TagReading", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagAggregatingExpression = new MethodMeasurement("RfidInventory/TagAggregatingExpression", (Object)"");
    protected final MethodMeasurement tagAggregating = new MethodMeasurement("RfidInventory/TagAggregating", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagMaskSetting = new MethodMeasurement("RfidInventory/TagMaskSetting", (Object)"");
    protected final MethodMeasurement tagFilterExpression = new MethodMeasurement("RfidInventory/TagFilterExpression", (Object)"");
    protected final MethodMeasurement aggregationFilterExpression = new MethodMeasurement("RfidInventory/AggregationFilterExpression", (Object)"");
    protected final MethodMeasurement aggregationFinalFilterExpression = new MethodMeasurement("RfidInventory/AggregationFinalFilterExpression", (Object)"");
    protected final MethodMeasurement duplicateFilteringExpression = new MethodMeasurement("RfidInventory/DuplicateFilteringExpression", (Object)"");
    protected final MethodMeasurement duplicateFiltering = new MethodMeasurement("RfidInventory/DuplicateFiltering", (Object)Boolean.FALSE);
    protected final MethodMeasurement aggregationMaskSetting = new MethodMeasurement("RfidInventory/AggregationMaskSetting", (Object)"");
    protected final MethodMeasurement dataExtensions = new MethodMeasurement("RfidInventory/DataExtensions", new HashMap());
    protected final MethodMeasurement tagPosition = new MethodMeasurement("RfidInventory/TagPosition", new HashMap());
    protected final MethodMeasurement tagAntennaReportLevel = new MethodMeasurement("RfidInventory/TagAntennaReportLevel", (Object)RfidInventoryProfile.createInteger((int)5));
    protected final MethodMeasurement readOperations = new MethodMeasurement("RfidInventory/ReadOperations", (Object)"");
    protected final MethodMeasurement readOperationsCount = new MethodMeasurement("RfidInventory/ReadOperationsCount", (Object)RfidInventoryProfile.createInteger((int)0));
    protected final MethodMeasurement antennaCount = new MethodMeasurement("RfidInventory/AntennaCount", (Object)RfidInventoryProfile.createInteger((int)0));
    protected final MethodMeasurement superCacheMaximumSize = new MethodMeasurement("RfidInventory/SuperCacheMaximumSize", (Object)RfidInventoryProfile.createInteger((int)0));
    protected final MethodMeasurement confidenceScript = new MethodMeasurement("RfidInventory/ConfidenceScript");
    protected final Signal tagReport = new Signal("RfidInventory/TagReport");
    protected final Signal tagAggregationReport = new Signal("RfidInventory/TagAggregationReport");
    private int readStopTimeout = 2000;
    protected String gpioInput;
    private Filter tagAggregatingLdapFilter;
    private Filter tagReadingLdapFilter;
    private Filter tagLdapFilter;
    private Filter aggregationLdapFilter;
    private Filter aggregationFinalLdapFilter;
    private Filter duplicateFilteringLdapFilter;
    protected InterestMasks tagInterest = new InterestMasks();
    protected InterestMasks aggregationInterest = new InterestMasks();
    private Map aggregatedTags = new Hashtable(1031);
    private final Object waitForReadStop = new Object();
    private final Object sequentialLdapLock = new Object();
    private Worker readStopCommandConsumerWorker;
    private IQueue readerStopCommandQueue;

    public RfidInventoryProfile() {
        super("RfidInventoryProfile/Capabilities", "RfidInventoryProfile/Status", "RfidInventoryProfile/Configuration", "RfidInventoryProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        this.setupReadStopConsumerThread();
        this.applyTagReading(this.getTagReadingValue());
        this.evaluateTagReadingLdapFilter();
        this.evaluateDuplicateFilteringLdapFilter();
        this.evaluateTagAggregatingLdapFilter();
        super.activate();
    }

    private void applyAggregating(String key, Map reads, Object timestamp, boolean sendTag) {
        byte[] tagBytes;
        boolean isAggregating = (Boolean)this.getTagAggregating().getValue();
        if (isAggregating && this.aggregationInterest.isInterested(tagBytes = RfidInventoryProfile.toBytes(key))) {
            boolean aggregation = true;
            if (this.aggregationLdapFilter != null) {
                Hashtable tagLdapMap = new Hashtable();
                tagLdapMap.putAll(this.ldapMap);
                tagLdapMap.putAll(reads);
                aggregation = this.evaluateAggregationLdapFilter(tagLdapMap);
            }
            if (aggregation) {
                if (this.getTagReadingValue()) {
                    this.updateTagInCache(key, reads, this.aggregatedTags, timestamp);
                } else {
                    Map tagErrorMap = this.buildTagMessage(key, reads);
                    this.triggerTagAggregationReport(tagErrorMap, true);
                }
            }
        }
    }

    protected void applyDataExtensions(Map rfidData) {
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions == null || extensions.isEmpty()) {
            rfidData.put("dataExtensions", new Hashtable(11));
        } else {
            Map existingDataExtensions = (Map)rfidData.get("dataExtensions");
            Map mergedDataExt = this.mergeMapOverMap(extensions, existingDataExtensions);
            rfidData.put("dataExtensions", Collections.unmodifiableMap(mergedDataExt));
        }
        Map position = (Map)this.tagPosition.getValue();
        if (position != null && !position.isEmpty()) {
            Map existingPosition = (Map)rfidData.get("position");
            Map mergedPosition = this.mergeMapOverMap(position, existingPosition);
            rfidData.put("position", Collections.unmodifiableMap(mergedPosition));
        }
    }

    protected void applyDataExtensionsSingleTag(Map rfidData) {
        Map position;
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions != null && !extensions.isEmpty()) {
            Map currentExtensions = Collections.unmodifiableMap(extensions);
            rfidData.put("position", currentExtensions);
        }
        if ((position = (Map)this.tagPosition.getValue()) != null && !position.isEmpty()) {
            Map currentPosition = Collections.unmodifiableMap(position);
            rfidData.put("position", currentPosition);
        }
    }

    private boolean applyFiltering(String key, Map reads, Object timestamp) {
        byte[] tagBytes = RfidInventoryProfile.toBytes(key);
        boolean passesFilter = this.tagInterest.isInterested(tagBytes);
        if (passesFilter) {
            boolean isDuplicateFiltering;
            this.improveReportMap(key, reads, timestamp);
            if (this.tagFilterExpression != null) {
                Hashtable tagLdapMap = new Hashtable();
                tagLdapMap.putAll(this.ldapMap);
                tagLdapMap.putAll(reads);
                passesFilter = this.evaluateTagLdapFilter(tagLdapMap);
            }
            if (passesFilter && (isDuplicateFiltering = ((Boolean)this.getDuplicateFiltering().getValue()).booleanValue())) {
                if (!this.isDuplicateTag(key)) {
                    this.addTagToCache(key, reads, this.cachedTags);
                } else {
                    passesFilter = false;
                }
            }
        } else {
            boolean isAggregating = (Boolean)this.getTagAggregating().getValue();
            if (isAggregating) {
                this.improveReportMap(key, reads, timestamp);
            }
        }
        return passesFilter;
    }

    private void applyLdap() {
        ExpressionFilterResults efr = new ExpressionFilterResults();
        if (this.duplicateFilteringLdapFilter != null) {
            efr.setDuplicateFilteringLdapFilter(this.duplicateFilteringLdapFilter.match((Dictionary)this.ldapMap));
            efr.setDuplicateFilteringLdapFilterNotNull(true);
        }
        if (this.tagAggregatingLdapFilter != null) {
            efr.setTagAggregatingLdapFilter(this.tagAggregatingLdapFilter.match((Dictionary)this.ldapMap));
            efr.setTagAggregatingLdapFilterNotNull(true);
        }
        if (this.tagReadingLdapFilter != null) {
            efr.setTagReadingLdapFilter(this.tagReadingLdapFilter.match((Dictionary)this.ldapMap));
            efr.setTagReadingLdapFilterNotNull(true);
        }
        this.scheduleReadCommand(efr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTagReading(boolean reading) {
        if (!this.isStarted()) {
            Object object = this.waitForReadStop;
            synchronized (object) {
                this.tagReading.setValue((Object)Boolean.FALSE, RfidInventoryProfile.getCurrentTimestamp());
            }
            return;
        }
        if (reading) {
            this.scheduleReadCommand(COMMAND_ACTIVATE_BY_MEASUREMENT_BYTE);
        } else {
            this.scheduleReadCommand(COMMAND_DEACTIVATE_BY_MEASUREMENT_BYTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTagReadingFalse() throws InterruptedException {
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (!this.getBooleanValue(this.tagReading.getValue()).booleanValue()) {
                return;
            }
            long readTimeout = this.getReadStopTimeout();
            boolean requiresWait = this.autonomousModeOff();
            if (requiresWait && readTimeout > 0L) {
                this.waitForReadStop.wait(readTimeout);
            }
            this.tagReading.setValue((Object)Boolean.FALSE, RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTagReadingTrue() {
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (this.getBooleanValue(this.tagReading.getValue()).booleanValue()) {
                return;
            }
            this.tagReading.setValue((Object)Boolean.TRUE, RfidInventoryProfile.getCurrentTimestamp());
            this.autonomousModeOn();
        }
    }

    protected abstract boolean autonomousModeOff();

    protected abstract boolean autonomousModeOn();

    protected Map buildOuterTagMessage(Map tags) {
        Map summaryMap;
        int count;
        Hashtable tagMap = new Hashtable(13);
        tagMap.put("tags", Collections.unmodifiableMap(tags));
        if (this.getReportLevelValue() >= 5 && (count = tags.size()) > 1 && (summaryMap = RfidInventoryProfile.buildSummary(tags)) != null && !summaryMap.isEmpty()) {
            tagMap.put("summary", Collections.unmodifiableMap(summaryMap));
        }
        this.applyDataExtensions(tagMap);
        return Collections.unmodifiableMap(tagMap);
    }

    protected Map buildTagMessage(String key, Map reads) {
        Hashtable<String, Map> tags = new Hashtable<String, Map>(7);
        tags.put(key, reads);
        Map tagMap = this.buildOuterTagMessage(tags);
        return tagMap;
    }

    protected void consumeReadStopCommands() throws InterruptedException {
        Object typeObj = this.getReaderStopCommandQueue().remove();
        if (typeObj instanceof Byte) {
            switch ((Byte)typeObj) {
                case 0: {
                    this.applyTagReadingFalse();
                    break;
                }
                case 1: {
                    this.applyTagReadingTrue();
                }
            }
        } else if (typeObj instanceof ExpressionFilterResults) {
            ExpressionFilterResults ef = (ExpressionFilterResults)typeObj;
            this.evaluateLdapFilters(ef);
        }
    }

    private IQueue createQueue(int capacity) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IQueue queue = utility.createQueue(capacity);
        return queue;
    }

    public void deactivate() {
        if (this.readStopCommandConsumerWorker != null && this.readStopCommandConsumerWorker.isRunning()) {
            this.readStopCommandConsumerWorker.stop();
        }
        this.readStopCommandConsumerWorker = null;
        super.deactivate();
    }

    public boolean evaluateAggregationLdapFilter(Dictionary tagLdapMap) {
        if (this.aggregationLdapFilter != null) {
            boolean result = this.aggregationLdapFilter.match(tagLdapMap);
            return result;
        }
        return true;
    }

    public void evaluateDuplicateFilteringLdapFilter() {
        if (this.duplicateFilteringLdapFilter != null) {
            boolean duplicateFilteringResult = this.duplicateFilteringLdapFilter.match((Dictionary)this.ldapMap);
            this.duplicateFiltering.setValue((Object)(duplicateFilteringResult ? Boolean.TRUE : Boolean.FALSE), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    public void evaluateDuplicateFilteringLdapFilter(boolean duplicateFilteringResult) {
        this.duplicateFiltering.setValue((Object)(duplicateFilteringResult ? Boolean.TRUE : Boolean.FALSE), RfidInventoryProfile.getCurrentTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateLdapFilters(ExpressionFilterResults expressionFilterResults) throws InterruptedException {
        boolean evaluateReadingLast = true;
        Object object = this.waitForReadStop;
        synchronized (object) {
            if (this.getTagReadingValue() && expressionFilterResults.isTagReadingLdapFilterNotNull() && !expressionFilterResults.isTagReadingLdapFilter()) {
                evaluateReadingLast = false;
                this.applyTagReadingFalse();
            }
        }
        object = this.sequentialLdapLock;
        synchronized (object) {
            if (expressionFilterResults.isDuplicateFilteringLdapFilterNotNull()) {
                this.evaluateDuplicateFilteringLdapFilter(expressionFilterResults.isDuplicateFilteringLdapFilter());
            }
            if (expressionFilterResults.isTagAggregatingLdapFilterNotNull()) {
                this.evaluateTagAggregatingLdapFilter(expressionFilterResults.isTagAggregatingLdapFilter());
            }
            if (evaluateReadingLast && expressionFilterResults.isTagReadingLdapFilterNotNull()) {
                this.evaluateTagReadingLdapFilter(expressionFilterResults.isTagReadingLdapFilter());
            }
        }
    }

    public void evaluateTagAggregatingLdapFilter() {
        if (this.tagAggregatingLdapFilter != null) {
            boolean tagAggregatingResult = this.tagAggregatingLdapFilter.match((Dictionary)this.ldapMap);
            this.tagAggregating.setValue((Object)(tagAggregatingResult ? Boolean.TRUE : Boolean.FALSE), RfidInventoryProfile.getCurrentTimestamp());
        }
    }

    public void evaluateTagAggregatingLdapFilter(boolean tagAggregatingResult) {
        this.tagAggregating.setValue((Object)(tagAggregatingResult ? Boolean.TRUE : Boolean.FALSE), RfidInventoryProfile.getCurrentTimestamp());
    }

    public boolean evaluateTagLdapFilter(Dictionary tagLdapMap) {
        if (this.tagLdapFilter != null) {
            boolean result = this.tagLdapFilter.match(tagLdapMap);
            return result;
        }
        return true;
    }

    public void evaluateTagReadingLdapFilter() {
        if (this.tagReadingLdapFilter != null) {
            boolean tagReadingResult = this.tagReadingLdapFilter.match((Dictionary)this.ldapMap);
            this.handleSetTagReading((Measurement)this.tagReading, tagReadingResult ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void evaluateTagReadingLdapFilter(boolean tagReadingResult) {
        this.handleSetTagReading((Measurement)this.tagReading, tagReadingResult ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        try {
            super.exit();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.superCache = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.superCache = null;
            return;
        }
    }

    public Map filterMap(Map map, Filter filter) {
        HashMap result = new HashMap();
        Hashtable ldapBaseTagMap = new Hashtable();
        ldapBaseTagMap.putAll(this.ldapMap);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Map value = (Map)entry.getValue();
            Hashtable ldapTagMap = (Hashtable)ldapBaseTagMap.clone();
            ldapTagMap.putAll(value);
            if (!filter.match((Dictionary)ldapTagMap)) continue;
            result.put(key, value);
        }
        return result;
    }

    public void flushAggregationCache() {
        this.aggregatedTags = new Hashtable(1031);
    }

    public MeasurementService getAggregationFilterExpression() {
        return this.aggregationFilterExpression;
    }

    public MeasurementService getAggregationFinalFilterExpression() {
        return this.aggregationFinalFilterExpression;
    }

    public Filter getAggregationFinalLdapFilter() {
        return this.aggregationFinalLdapFilter;
    }

    public Filter getAggregationLdapFilter() {
        return this.aggregationLdapFilter;
    }

    public MeasurementService getAggregationMaskSetting() {
        return this.aggregationMaskSetting;
    }

    public MeasurementService getAntennaCount() {
        return this.antennaCount;
    }

    public MeasurementService getConfidenceScript() {
        return this.confidenceScript;
    }

    public int getControlCapacity() {
        return 31;
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public MeasurementService getDataExtensions() {
        return this.dataExtensions;
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "RfidInventoryProfile";
    }

    public MeasurementService getDuplicateFiltering() {
        return this.duplicateFiltering;
    }

    public MeasurementService getDuplicateFilteringExpression() {
        return this.duplicateFilteringExpression;
    }

    public Filter getDuplicateFilteringLdapFilter() {
        return this.duplicateFilteringLdapFilter;
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public int getMessageCapacity() {
        return 2;
    }

    public String getPositionProfilePrefix() {
        return this.getString(POSITION_PROFILE_PREFIX, this.getPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueue getReaderStopCommandQueue() {
        RfidInventoryProfile rfidInventoryProfile = this;
        synchronized (rfidInventoryProfile) {
            if (this.readerStopCommandQueue == null) {
                this.readerStopCommandQueue = this.createQueue(13);
            }
            return this.readerStopCommandQueue;
        }
    }

    public MeasurementService getReadOperations() {
        return this.readOperations;
    }

    public MeasurementService getReadOperationsCount() {
        return this.readOperationsCount;
    }

    private WorkerService getReadStopCommandConsumerWorker() {
        WorkerService work = new WorkerService(){

            public boolean doWork() throws InterruptedException {
                RfidInventoryProfile.this.consumeReadStopCommands();
                return true;
            }
        };
        return work;
    }

    public int getReadStopTimeout() {
        return this.readStopTimeout;
    }

    public MeasurementService getReportLevel() {
        return this.getTagAntennaReportLevel();
    }

    public MeasurementService getSuperCacheMaximumSize() {
        return this.superCacheMaximumSize;
    }

    public MeasurementService getTagAggregating() {
        return this.tagAggregating;
    }

    public MeasurementService getTagAggregatingExpression() {
        return this.tagAggregatingExpression;
    }

    public SignalService getTagAggregationReport() {
        return this.tagAggregationReport;
    }

    public MeasurementService getTagAntennaReportLevel() {
        return this.tagAntennaReportLevel;
    }

    public MeasurementService getTagFilterExpression() {
        return this.tagFilterExpression;
    }

    public Filter getTagLdapFilter() {
        return this.tagLdapFilter;
    }

    public MeasurementService getTagMaskSetting() {
        return this.tagMaskSetting;
    }

    public MeasurementService getTagPosition() {
        return this.tagPosition;
    }

    public MeasurementService getTagReading() {
        return this.tagReading;
    }

    public MeasurementService getTagReadingExpression() {
        return this.tagReadingExpression;
    }

    protected boolean getTagReadingValue() {
        if (this.getTagReading() == null || this.getTagReading().getValue() == null) {
            return false;
        }
        return (Boolean)this.getTagReading().getValue();
    }

    public SignalService getTagReport() {
        return this.tagReport;
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleDuplicateFiltering(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (!newState) {
            this.flushTagCache();
        }
    }

    protected void handleGpioProfileServiceAnalogInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    public Object handleMethodAggregationFilterExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetAggregationFilterExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodAggregationFinalFilterExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetAggregationFinalFilterExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodAggregationMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetAggregationMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodAntennaCount(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof Number) {
                    measurement.setValue((Object)measurement, RfidInventoryProfile.getCurrentTimestamp());
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodConfidenceScript(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof String) {
                    ScriptManager scriptManager;
                    String scriptSource = data.toString();
                    if (scriptSource.length() <= 0 || (scriptManager = ScriptManager.getInstance()) == null) break;
                    ScriptService scriptService = scriptManager.createScript(scriptSource, "");
                    if (scriptService == null) {
                        throw new IllegalArgumentException(String.valueOf(data));
                    }
                    this.setConfidenceScriptService(scriptService);
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodDataExtensions(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDataExtensions(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodDuplicateFiltering(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.duplicateFilteringLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodDuplicateFiltering");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodDuplicateFilteringExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetDuplicateFilteringExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodReadOperations(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagReadingExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodReadOperationsCount(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof Number) {
                    measurement.setValue((Object)measurement, RfidInventoryProfile.getCurrentTimestamp());
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodSuperCacheMaximumSize(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (data instanceof Number) {
                    measurement.setValue((Object)measurement, RfidInventoryProfile.getCurrentTimestamp());
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(data));
            }
        }
        return null;
    }

    public Object handleMethodTagAggregating(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagAggregatingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagAggregating");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagAggregatingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagAggregatingExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagAntennaReportLevel(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagFilterExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagFilterExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagMaskSetting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagPosition(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagReading(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagReadingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagReading");
                }
                this.handleSetTagReading(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagReadingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagReadingExpression(measurement, data);
            }
        }
        return null;
    }

    protected void handlePositionProfileServiceCoordinate(String externalKey, Dictionary data) {
        Object tempValue = data.get("value");
        if (tempValue == null || !(tempValue instanceof Map)) {
            return;
        }
        Map values = (Map)tempValue;
        HashMap map = new HashMap(101);
        map.putAll(values);
        this.tagPosition.setValue(map, RfidInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetAggregationFilterExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setAggregationLdapFilter(aggFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setAggregationLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    protected void handleSetAggregationFinalFilterExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setAggregationFinalLdapFilter(aggFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setAggregationFinalLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException(String.valueOf(data));
    }

    protected void handleSetAggregationMaskSetting(Measurement measurement, Object data) {
        if (!(data instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(data));
        }
        this.aggregationInterest = RfidInventoryProfile.parseInterestMasks((String)data);
        measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetDataExtensions(Measurement measurement, Object newValue) {
        Map newExtensions = null;
        if (newValue instanceof Map) {
            Map additionalExtensions = (Map)newValue;
            if (additionalExtensions.isEmpty()) {
                newExtensions = new Hashtable(11);
            } else {
                Map existingExtensions = (Map)measurement.getValue();
                newExtensions = this.mergeMapOverMap(additionalExtensions, existingExtensions);
            }
        } else if (newValue == null) {
            newExtensions = new Hashtable(11);
        }
        if (newExtensions == null) {
            throw new IllegalArgumentException("handleSetDataExtensions: " + newValue);
        }
        measurement.setValue(newExtensions, RfidInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetDuplicateFilteringExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter dupFilter = this.createLdapFilter((String)data);
                    this.setFilterDuplicatesLdapFilter(dupFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setFilterDuplicatesLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetDuplicateFilteringExpression: " + data);
    }

    protected void handleSetTagAggregatingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setTagAggregatingLdapFilter(aggFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagAggregatingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleTagAggregatingExpression: " + data);
    }

    protected void handleSetTagFilterExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter filter = this.createLdapFilter((String)data);
                    this.setTagLdapFilter(filter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetDuplicateFilteringExpression: " + data);
    }

    protected void handleSetTagMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.tagInterest = RfidInventoryProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    protected void handleSetTagReading(Measurement measurement, Object data) {
        boolean newState = this.getBooleanValue(data);
        this.applyTagReading(newState);
    }

    protected void handleSetTagReadingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter readFilter = this.createLdapFilter((String)data);
                    this.setTagReadingLdapFilter(readFilter);
                    measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagReadingLdapFilter(null);
                measurement.setValue(data, RfidInventoryProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetTagReadingExpression: " + data);
    }

    protected void handleTagAggregating(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (oldValue != null && !newState) {
            this.notifyTagAggregation();
            this.flushAggregationCache();
        }
    }

    public void improveReportMap(String key, Map reads, Object timestamp) {
        int antenna;
        Object antennaObject;
        int tagAntennaReportLevelValue;
        Object timestampLast;
        Object timestampFirst;
        String tagType = null;
        this.applyDataExtensionsSingleTag(reads);
        if (!reads.containsKey("timestamp")) {
            reads.put("timestamp", timestamp);
        }
        Object countObject = reads.get("count");
        int count = 1;
        if (!(countObject instanceof Number)) {
            reads.put("count", RfidInventoryProfile.createInteger((int)1));
        } else {
            count = ((Number)countObject).intValue();
        }
        Object peakRssiObject = reads.get("peakRSSI");
        if (peakRssiObject instanceof Number) {
            tagType = "rfid";
            int peakRssi = ((Number)peakRssiObject).intValue();
            if (!reads.containsKey("peakRSSITotal")) {
                reads.put("peakRSSITotal", RfidInventoryProfile.createNumber((long)(peakRssi * count)));
            }
            if (!reads.containsKey("peakRSSIMaximum")) {
                reads.put("peakRSSIMaximum", peakRssiObject);
            }
            if (!reads.containsKey("peakRSSIMinimum")) {
                reads.put("peakRSSIMinimum", peakRssiObject);
            }
            if (!reads.containsKey("peakRSSIAverage")) {
                reads.put("peakRSSIAverage", peakRssiObject);
            }
        }
        if ((timestampFirst = reads.get("timestampFirst")) == null) {
            reads.put("timestampFirst", timestamp);
            timestampFirst = timestamp;
        }
        if ((timestampLast = reads.get("timestampLast")) == null) {
            reads.put("timestampLast", timestamp);
            timestampLast = timestamp;
        }
        if (timestampFirst instanceof Number && timestampLast instanceof Number) {
            long first = ((Number)timestampFirst).longValue();
            long last = ((Number)timestampLast).longValue();
            long duration = last - first;
            reads.put("duration", RfidInventoryProfile.createNumber((long)duration));
        }
        Object readerObject = reads.get("reader");
        String readerName = this.getReaderId();
        if (readerObject == null) {
            reads.put("reader", readerName);
        } else {
            readerName = readerObject.toString();
        }
        Object pcObject = reads.get("C1G2PC");
        int afi = -1;
        if (pcObject instanceof Number) {
            byte[] bytes;
            int epcLength;
            tagType = "rfid";
            byte[] epcBytes = Nls.parseCompressedHexString((String)key);
            int keyLength = key.length();
            int epcBankLength = epcLength = keyLength * 4;
            int epcOffset = 16;
            int pc = ((Number)pcObject).intValue();
            Object crcObject = reads.get("C1G2CRC");
            if (crcObject instanceof Number) {
                epcOffset = 0;
                bytes = new byte[4 + epcBytes.length];
                int crc = ((Number)crcObject).intValue();
                epcBankLength += 16;
                BaseParameter.setBits((byte[])bytes, (int)(bytes.length >> 3), (int)0, (int)16, (long)crc, (boolean)false);
                BaseParameter.setBits((byte[])bytes, (int)(bytes.length >> 3), (int)16, (int)16, (long)pc, (boolean)false);
                BaseParameter.setBytes((byte[])bytes, (int)(bytes.length >> 3), (int)32, (int)epcLength, (byte[])epcBytes, (boolean)false);
                reads.put("epcBank", bytes);
            } else {
                bytes = new byte[2 + epcBytes.length];
                BaseParameter.setBits((byte[])bytes, (int)(bytes.length >> 3), (int)0, (int)16, (long)pc, (boolean)false);
                BaseParameter.setBytes((byte[])bytes, (int)(bytes.length >> 3), (int)16, (int)epcLength, (byte[])epcBytes, (boolean)false);
            }
            epcBankLength += 16;
            StringBuffer epcBuffer = new StringBuffer(32);
            epcBuffer.append("1.");
            epcBuffer.append(epcOffset);
            epcBuffer.append('.');
            epcBuffer.append(epcBankLength);
            String epcBufferKey = epcBuffer.toString();
            if (reads.get(epcBufferKey) == null) {
                reads.put(epcBufferKey, bytes);
            }
            if (reads.get("afi") == null) {
                afi = pc & 0xFF;
                reads.put("afi", RfidInventoryProfile.createInteger((int)afi));
            }
            if (reads.get("nsi") == null) {
                reads.put("nsi", RfidInventoryProfile.createInteger((int)(pc & 0x1FF)));
            }
        }
        if (reads.get("epcURI") == null) {
            Object afiObject;
            if (afi < 0 && (afiObject = reads.get("afi")) instanceof Number) {
                afi = ((Number)afiObject).intValue();
            }
            if (afi >= 0) {
                StringBuffer buffer = new StringBuffer(128);
                buffer.append("urn:epc:raw:");
                buffer.append(key.length() << 2);
                buffer.append('.');
                if (afi > 0) {
                    buffer.append('x');
                    String afiHexString = Integer.toHexString(afi);
                    if (afiHexString.length() == 1) {
                        buffer.append('0');
                    }
                    buffer.append(afiHexString);
                    buffer.append('.');
                }
                buffer.append('x');
                buffer.append(key.toUpperCase());
                reads.put("epcURI", buffer.toString());
            }
        }
        if (tagType != null && reads.get("epcURI") == null) {
            reads.put("tagType", tagType);
        }
        if ((tagAntennaReportLevelValue = this.getReportLevelValue()) >= 5 && (antennaObject = reads.get("antenna")) instanceof Number && (antenna = ((Number)antennaObject).intValue()) > 0) {
            String antennaKey;
            Map antennaInformation;
            Object readersInformationObject = reads.get("readersMap");
            Hashtable readersInformation = null;
            Hashtable<String, Object> readerInformation = null;
            if (readersInformationObject instanceof Map) {
                readersInformation = (Hashtable)readersInformationObject;
                readerInformation = new Hashtable<String, Object>();
            } else {
                readersInformation = new Hashtable();
                reads.put("readersMap", readersInformation);
                readerInformation = new Hashtable();
                readersInformation.put(readerName, readerInformation);
                long confidence = this.updateMap(readerInformation, reads, antenna, 1);
                Number confidenceNumber = RfidInventoryProfile.createNumber((long)confidence);
                readerInformation.put("confidence", confidenceNumber);
                reads.put("confidence", confidenceNumber);
            }
            Object antennaInformationObject = readerInformation.get("antennasMap");
            Map map = antennaInformation = antennaInformationObject instanceof Map ? (Map)antennaInformationObject : new Hashtable();
            if (antennaInformationObject == null) {
                readerInformation.put("antennasMap", antennaInformation);
            }
            if (antennaInformation.get(antennaKey = Integer.toString(antenna)) == null) {
                HashMap<String, Serializable> antennaMap = new HashMap<String, Serializable>(101);
                long confidence = this.updateMap(antennaMap, reads, antenna, 2);
                antennaInformation.put(antennaKey, antennaMap);
                antennaMap.put("confidence", RfidInventoryProfile.createNumber((long)confidence));
                if (tagAntennaReportLevelValue >= 8) {
                    HashMap reportsMap = new HashMap(101);
                    antennaMap.put("reportsMap", reportsMap);
                    HashMap reportMap = new HashMap(101);
                    this.updateMap(reportMap, reads, antenna, 3);
                    reportsMap.put("1", reportMap);
                }
            }
        }
    }

    private void initialize() {
        this.put((ControlService)this.tagReadingExpression);
        this.put((ControlService)this.tagReading);
        this.put((ControlService)this.tagAggregatingExpression);
        this.put((ControlService)this.tagAggregating);
        this.tagAggregating.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.tagMaskSetting);
        this.put((ControlService)this.tagFilterExpression);
        this.put((ControlService)this.aggregationFilterExpression);
        this.put((ControlService)this.aggregationFinalFilterExpression);
        this.put((ControlService)this.duplicateFilteringExpression);
        this.put((ControlService)this.duplicateFiltering);
        this.duplicateFiltering.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.aggregationMaskSetting);
        this.put((ControlService)this.dataExtensions);
        this.put((ControlService)this.tagPosition);
        this.put((ControlService)this.tagAntennaReportLevel);
        this.put((ControlService)this.readOperations);
        this.put((ControlService)this.readOperationsCount);
        this.put((ControlService)this.antennaCount);
        this.put((ControlService)this.superCacheMaximumSize);
        this.put((ControlService)this.confidenceScript);
        this.put((ControlService)this.tagReport);
        this.put((ControlService)this.tagAggregationReport);
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    protected boolean isDuplicateTag(String key) {
        return this.cachedTags.containsKey(key);
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.tagAggregating == source) {
            this.handleTagAggregating(source, timestamp, newValue, oldValue);
            return;
        }
        if (this.duplicateFiltering == source) {
            this.handleDuplicateFiltering(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public long mergeAntennaInfo(Map targetMap, Map sourceMap, int antenna) {
        Object result;
        String ekey;
        Map.Entry entry;
        Object timestampFirst = null;
        Object timestampLast = null;
        long peakRssiMaximum = 0L;
        long peakRssiMinimum = 0L;
        long count = 0L;
        long peakRssiTotal = 0L;
        int antennaReportCount = 0;
        Iterator iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            long cacheValue;
            long value;
            Object cacheObject;
            entry = iterator.next();
            ekey = String.valueOf(entry.getKey());
            Object evalue = entry.getValue();
            if (ekey.length() > "antenna".length() && ekey.startsWith("antenna")) continue;
            if (ekey.equals("peakRSSI")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value <= (cacheValue = ((Number)cacheObject).longValue())) continue;
                    targetMap.put("peakRSSI", evalue);
                    continue;
                }
                targetMap.put("peakRSSI", evalue);
                continue;
            }
            if (ekey.equals("peakRSSIMaximum")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                peakRssiMaximum = value = ((Number)evalue).longValue();
                if (cacheObject instanceof Number) {
                    cacheValue = ((Number)cacheObject).longValue();
                    if (value > cacheValue) {
                        targetMap.put("peakRSSIMaximum", evalue);
                        continue;
                    }
                    peakRssiMaximum = cacheValue;
                    continue;
                }
                targetMap.put("peakRSSIMaximum", evalue);
                continue;
            }
            if (ekey.equals("peakRSSIMinimum")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                peakRssiMinimum = value = ((Number)evalue).longValue();
                if (cacheObject instanceof Number) {
                    cacheValue = ((Number)cacheObject).longValue();
                    if (value < cacheValue) {
                        targetMap.put("peakRSSIMinimum", evalue);
                        continue;
                    }
                    peakRssiMinimum = cacheValue;
                    continue;
                }
                targetMap.put("peakRSSIMinimum", evalue);
                continue;
            }
            if (ekey.equals("peakRSSITotal")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    cacheValue = ((Number)cacheObject).longValue();
                    peakRssiTotal = value + cacheValue;
                    targetMap.put("peakRSSITotal", RfidInventoryProfile.createNumber((long)peakRssiTotal));
                    continue;
                }
                targetMap.put("peakRSSITotal", evalue);
                continue;
            }
            if (ekey.equals("count")) {
                if (!(evalue instanceof Number)) continue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    cacheValue = ((Number)cacheObject).longValue();
                    count = value + cacheValue;
                    targetMap.put("count", RfidInventoryProfile.createNumber((long)count));
                    continue;
                }
                targetMap.put("count", evalue);
                continue;
            }
            if (ekey.equals("timestampLast")) {
                if (!(evalue instanceof Number)) continue;
                timestampLast = evalue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value > (cacheValue = ((Number)cacheObject).longValue())) {
                        targetMap.put("timestampLast", evalue);
                        continue;
                    }
                    timestampLast = cacheObject;
                    continue;
                }
                targetMap.put("timestampLast", evalue);
                continue;
            }
            if (ekey.equals("timestampFirst")) {
                if (!(evalue instanceof Number)) continue;
                timestampFirst = evalue;
                cacheObject = targetMap.get(ekey);
                if (cacheObject instanceof Number) {
                    value = ((Number)evalue).longValue();
                    if (value < (cacheValue = ((Number)cacheObject).longValue())) {
                        targetMap.put("timestampFirst", evalue);
                        continue;
                    }
                    timestampFirst = cacheObject;
                    continue;
                }
                targetMap.put("timestampFirst", evalue);
                continue;
            }
            if (ekey.equals("timestamp")) {
                targetMap.put("timestamp", evalue);
                continue;
            }
            if (antenna >= 0 && this.getReportLevelValue() < 8) continue;
            targetMap.put(ekey, evalue);
        }
        iterator = targetMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            ekey = String.valueOf(entry.getKey());
            if (ekey.length() <= "antenna".length() || !ekey.startsWith("antenna")) continue;
            ++antennaReportCount;
        }
        if (count > 0L) {
            float average = (float)peakRssiTotal / (float)count;
            targetMap.put("peakRSSIAverage", new Float(average));
        }
        long duration = 0L;
        if (timestampLast instanceof Number && timestampFirst instanceof Number) {
            long first = ((Number)timestampFirst).longValue();
            long last = ((Number)timestampLast).longValue();
            duration = last - first;
            targetMap.put("duration", RfidInventoryProfile.createNumber((long)duration));
        }
        long peakRssiRange = peakRssiMinimum - peakRssiMinimum;
        targetMap.put("peakRSSIRange", RfidInventoryProfile.createNumber((long)peakRssiRange));
        if (antennaReportCount == 0) {
            ++antennaReportCount;
        }
        if (antennaReportCount > 0) {
            targetMap.put("antennaReportCount", RfidInventoryProfile.createNumber((long)antennaReportCount));
        }
        long antennaFactor = antennaReportCount * antennaReportCount;
        long countFactor = count;
        long peakRssiMaximumAdjusted = peakRssiMaximum + 128L;
        long peakRssiFactor = peakRssiMaximumAdjusted * peakRssiMaximumAdjusted;
        long confidence = antennaFactor * (countFactor + peakRssiFactor);
        ScriptService confidenceScriptService = this.getConfidenceScriptService();
        if (confidenceScriptService != null && (result = confidenceScriptService.evaluate(targetMap)) instanceof Number) {
            confidence = ((Number)result).longValue();
        }
        if (antenna < 0) {
            targetMap.put("confidence", RfidInventoryProfile.createNumber((long)confidence));
        }
        return confidence;
    }

    public Map mergeMapOverMap(Map additionalValues, Map existingValues) {
        Hashtable newExtensions = new Hashtable(17);
        if (existingValues != null) {
            newExtensions.putAll(existingValues);
        }
        if (additionalValues != null) {
            newExtensions.putAll(additionalValues);
        }
        return newExtensions;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceAnalogInputExternalKey)) {
            this.handleGpioProfileServiceAnalogInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        if (externalKey.equals(this.positionProfileServiceCoordinateExternalKey)) {
            this.handlePositionProfileServiceCoordinate(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReadStop() {
        Object object = this.waitForReadStop;
        synchronized (object) {
            this.waitForReadStop.notifyAll();
        }
    }

    public void notifyTagAggregation() {
        Map reducedMap = this.updateSuperCache(this.aggregatedTags);
        if (this.aggregationFinalLdapFilter == null) {
            Map tagMap = this.buildOuterTagMessage(reducedMap);
            this.triggerTagAggregationReport(tagMap, false);
        } else {
            Map filteredAggregatedTags = this.filterMap(reducedMap, this.aggregationFinalLdapFilter);
            Map tagMap = this.buildOuterTagMessage(filteredAggregatedTags);
            this.triggerTagAggregationReport(tagMap, false);
        }
    }

    public void notifyTagRead(Map tags) {
        this.notifyTagRead(tags, RfidInventoryProfile.getCurrentTimestamp());
    }

    public void notifyTagRead(Map tags, Object timestamp) {
        HashMap ttags = new HashMap(tags);
        Hashtable<String, Map> publishTags = null;
        Iterator i = ttags.entrySet().iterator();
        while (i.hasNext()) {
            Map tagReads;
            Map.Entry entry = i.next();
            String tagKey = (String)entry.getKey();
            boolean sendTag = this.applyFiltering(tagKey, tagReads = (Map)entry.getValue(), timestamp);
            if (sendTag) {
                if (publishTags == null) {
                    publishTags = new Hashtable<String, Map>((ttags.size() << 1) - 1);
                }
                publishTags.put(tagKey, tagReads);
            }
            this.applyAggregating(tagKey, tagReads, timestamp, sendTag);
        }
        if (publishTags != null) {
            Map tagMap = this.buildOuterTagMessage(publishTags);
            this.triggerTagReport(tagMap, false, timestamp);
        }
    }

    public void notifyTagRead(String key, Map reads) {
        this.notifyTagRead(key, reads, RfidInventoryProfile.getCurrentTimestamp());
    }

    public void notifyTagRead(String key, Map reads, Object timestamp) {
        HashMap treads = new HashMap(reads);
        boolean sendTag = this.applyFiltering(key, treads, timestamp);
        if (sendTag) {
            Map tagMap = this.buildTagMessage(key, treads);
            this.triggerTagReport(tagMap, false, timestamp);
        }
        this.applyAggregating(key, treads, timestamp, sendTag);
    }

    private void scheduleReadCommand(Object type) {
        this.getReaderStopCommandQueue().add(type);
    }

    public void setAggregationFinalLdapFilter(Filter aggregationFinalLdapFilter) {
        this.aggregationFinalLdapFilter = aggregationFinalLdapFilter;
    }

    public void setAggregationLdapFilter(Filter aggregationLdapFilter) {
        this.aggregationLdapFilter = aggregationLdapFilter;
    }

    public void setDuplicateFilteringLdapFilter(Filter duplicateFilteringLdapFilter) {
        this.duplicateFilteringLdapFilter = duplicateFilteringLdapFilter;
    }

    public void setFilterDuplicatesLdapFilter(Filter filterDuplicatesLdapFilter) {
        this.duplicateFilteringLdapFilter = filterDuplicatesLdapFilter;
        this.evaluateDuplicateFilteringLdapFilter();
    }

    public void setReadStopTimeout(int readStopTimeout) {
        this.readStopTimeout = readStopTimeout;
    }

    public void setTagAggregatingLdapFilter(Filter tagAggregatingLdapFilter) {
        this.tagAggregatingLdapFilter = tagAggregatingLdapFilter;
        this.evaluateTagAggregatingLdapFilter();
    }

    public void setTagLdapFilter(Filter tagLdapFilter) {
        this.tagLdapFilter = tagLdapFilter;
    }

    public void setTagReadingLdapFilter(Filter tagReadingLdapFilter) {
        this.tagReadingLdapFilter = tagReadingLdapFilter;
        this.evaluateTagReadingLdapFilter();
    }

    public void setup() {
        super.setup();
        this.setReadStopTimeout(this.getInt("rfidinventoryprofile.readStopTimeout", this.getReadStopTimeout()));
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input/get");
        this.gpioProfileServiceAnalogInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput");
        this.gpioProfileServiceAnalogInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        String positionProfilePrefix = this.getPositionProfilePrefix();
        this.positionProfileServiceCoordinateExternalKey = this.prependPrefix(positionProfilePrefix, "Position/Coordinate");
        this.positionProfileServiceCoordinateGetExternalKey = this.prependPrefix(positionProfilePrefix, "Position/Coordinate/get");
        this.register(new String[]{this.gpioProfileServiceInputExternalKey, this.gpioProfileServiceAnalogInputExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey, this.positionProfileServiceCoordinateExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.gpioProfileServiceAnalogInputGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
        this.broadcast(this.positionProfileServiceCoordinateGetExternalKey, new Hashtable());
    }

    private void setupReadStopConsumerThread() {
        WorkerService work = this.getReadStopCommandConsumerWorker();
        this.readStopCommandConsumerWorker = new Worker("RfidInventoryProfileRSC", work);
        this.readStopCommandConsumerWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMapInLdap(Dictionary data) {
        Hashtable hashtable = this.ldapMap;
        synchronized (hashtable) {
            Object tempValue = data.get("value");
            if (tempValue == null || !(tempValue instanceof Map)) {
                return;
            }
            Map values = (Map)tempValue;
            this.ldapMap.putAll(values);
            this.applyLdap();
        }
    }

    protected void triggerTagAggregationReport(Map tagMap, boolean withError) {
        if (withError) {
            this.tagAggregationReport.fireErrorOccurred(RfidInventoryProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagAggregationReport.trigger((Object)tagMap);
        }
    }

    protected void triggerTagReport(Map tagMap, boolean withError) {
        Object timestamp = RfidInventoryProfile.getCurrentTimestamp();
        this.triggerTagReport(tagMap, withError, timestamp);
    }

    protected void triggerTagReport(Map tagMap, boolean withError, Object timestamp) {
        Object timestampValue;
        Object object = timestampValue = timestamp != null ? timestamp : RfidInventoryProfile.getCurrentTimestamp();
        if (withError || !this.getTagReadingValue()) {
            this.tagReport.fireErrorOccurred(timestampValue, (Object)tagMap);
        } else {
            this.tagReport.trigger((Object)tagMap, timestampValue);
        }
    }
}

