/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.write.profile.test.agent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.profile.test.agent.ProfileAbstractTestCase;
import org.eclipse.soda.dk.rfid.write.profile.test.agent.RfidWriteProfileTestAgent;
import org.eclipse.soda.dk.rfid.write.profile.test.agent.WriteProfileStringGeneratorConstants;
import org.eclipse.soda.dk.testagent.util.NotificationProbe;

public class RfidWriteProfileAbstractTestCase
extends ProfileAbstractTestCase
implements WriteProfileStringGeneratorConstants {
    protected static final int DEFAULT_TIME_OUT_DURATION = 3000;
    protected static final int DEFAULT_KILL_TIME_DURATION = 30000;
    protected static final String AND_EXPRESSION = "(&(i1=true)(b32=true)(l2=1))";
    protected static final String OR_EXPRESSION = "(|(i32=true)(b1=true))";
    protected static final long BIT_1 = 1L;
    protected static final long BIT_2 = 2L;
    protected static final long BIT_32 = Integer.MIN_VALUE;
    protected Set originalTagInfo;
    protected Set writeDataSet;
    protected Set tagEpcSet;
    protected String writeOperationId;
    protected String readOperationId;
    protected String initialReadOperationId;
    protected String tagEpc;
    protected String tagWriteString;
    protected String readString;
    protected String readerIdProperty;
    protected String tagWriteData;
    protected int epc_bit_size;
    protected int testState;
    protected int timeOutDurationProperty;
    protected int writeOperationKillTime;
    protected String controlProfileServiceBitsExternalKey;
    protected String controlProfileServiceLongsExternalKey;
    protected String gpioProfileServiceAnalogInputExternalKey;
    protected String gpioProfileServiceInputExternalKey;
    protected String rfidWriteProfileServiceAntennaConfigurationExternalKey;
    protected String rfidWriteProfileServiceCapabilitiesExternalKey;
    protected String rfidWriteProfileServiceConfigurationExternalKey;
    protected String rfidWriteProfileServiceDataWriteExtensionsExternalKey;
    protected String rfidWriteProfileServiceStatusExternalKey;
    protected String rfidWriteProfileServiceTagAggregationWriteMaskSettingExternalKey;
    protected String rfidWriteProfileServiceTagWriteAggregatingExpressionExternalKey;
    protected String rfidWriteProfileServiceTagWriteAggregatingExternalKey;
    protected String rfidWriteProfileServiceTagWriteAggregationReportExternalKey;
    protected String rfidWriteProfileServiceTagWriteAntennaReportingExternalKey;
    protected String rfidWriteProfileServiceTagWriteMaskSettingExternalKey;
    protected String rfidWriteProfileServiceTagWriteReportExternalKey;
    protected String rfidWriteProfileServiceWriteOperationsExecuteRequestExternalKey;
    protected String rfidWriteProfileServiceWriteOperationsExecuteStatusExternalKey;
    protected String rfidWriteProfileServiceWriteOperationsExpressionExternalKey;
    protected String rfidWriteProfileServiceWriteOperationsExternalKey;
    protected String rfidWriteProfileServiceWriteOperationsStopRequestExternalKey;

    public RfidWriteProfileAbstractTestCase(String name) {
        super(name);
    }

    protected Map GetAntennaConfiguration() throws InterruptedException {
        return (Map)this.getMeasurement(this.rfidWriteProfileServiceAntennaConfigurationExternalKey);
    }

    protected Map GetDataWriteExtensions() throws InterruptedException {
        return (Map)this.getMeasurement(this.rfidWriteProfileServiceDataWriteExtensionsExternalKey);
    }

    protected Dictionary GetRfidWriteProfileCapabilities() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidWriteProfileServiceCapabilitiesExternalKey);
    }

    protected Dictionary GetRfidWriteProfileConfiguration() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidWriteProfileServiceConfigurationExternalKey);
    }

    protected Dictionary GetRfidWriteProfileStatus() throws InterruptedException {
        return (Dictionary)this.getMeasurement(this.rfidWriteProfileServiceStatusExternalKey);
    }

    protected String GetTagAggregationWriteMaskSetting() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidWriteProfileServiceTagAggregationWriteMaskSettingExternalKey);
    }

    protected Boolean GetTagWriteAggregating() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExternalKey);
    }

    protected String GetTagWriteAggregatingExpression() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExpressionExternalKey);
    }

    protected Boolean GetTagWriteAntennaReporting() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidWriteProfileServiceTagWriteAntennaReportingExternalKey);
    }

    protected String GetTagWriteMaskSetting() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidWriteProfileServiceTagWriteMaskSettingExternalKey);
    }

    protected String GetWriteOperations() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidWriteProfileServiceWriteOperationsExternalKey);
    }

    protected Boolean GetWriteOperationsExecuteStatus() throws InterruptedException {
        return (Boolean)this.getMeasurement(this.rfidWriteProfileServiceWriteOperationsExecuteStatusExternalKey);
    }

    protected String GetWriteOperationsExpression() throws InterruptedException {
        return (String)this.getMeasurement(this.rfidWriteProfileServiceWriteOperationsExpressionExternalKey);
    }

    protected Map ReadAntennaConfiguration() throws InterruptedException {
        return (Map)this.readMeasurement(this.rfidWriteProfileServiceAntennaConfigurationExternalKey);
    }

    protected Map ReadDataWriteExtensions() throws InterruptedException {
        return (Map)this.readMeasurement(this.rfidWriteProfileServiceDataWriteExtensionsExternalKey);
    }

    protected String ReadTagAggregationWriteMaskSetting() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidWriteProfileServiceTagAggregationWriteMaskSettingExternalKey);
    }

    protected Boolean ReadTagWriteAggregating() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExternalKey);
    }

    protected String ReadTagWriteAggregatingExpression() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExpressionExternalKey);
    }

    protected Boolean ReadTagWriteAntennaReporting() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidWriteProfileServiceTagWriteAntennaReportingExternalKey);
    }

    protected String ReadTagWriteMaskSetting() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidWriteProfileServiceTagWriteMaskSettingExternalKey);
    }

    protected String ReadWriteOperations() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidWriteProfileServiceWriteOperationsExternalKey);
    }

    protected Boolean ReadWriteOperationsExecuteStatus() throws InterruptedException {
        return (Boolean)this.readMeasurement(this.rfidWriteProfileServiceWriteOperationsExecuteStatusExternalKey);
    }

    protected String ReadWriteOperationsExpression() throws InterruptedException {
        return (String)this.readMeasurement(this.rfidWriteProfileServiceWriteOperationsExpressionExternalKey);
    }

    protected void ReportAnalogInput(Map dataValue) {
        this.reportMeasurement(this.gpioProfileServiceAnalogInputExternalKey, dataValue);
    }

    protected void ReportBits(Map dataValue) {
        this.reportMeasurement(this.controlProfileServiceBitsExternalKey, dataValue);
    }

    protected void ReportInput(Map dataValue) {
        this.reportMeasurement(this.gpioProfileServiceInputExternalKey, dataValue);
    }

    protected void ReportLongs(Map dataValue) {
        this.reportMeasurement(this.controlProfileServiceLongsExternalKey, dataValue);
    }

    protected void WriteAntennaConfiguration(Map dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceAntennaConfigurationExternalKey, dataValue);
    }

    protected void WriteDataWriteExtensions(Map dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceDataWriteExtensionsExternalKey, dataValue);
    }

    protected void WriteTagAggregationWriteMaskSetting(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceTagAggregationWriteMaskSettingExternalKey, dataValue);
    }

    protected void WriteTagWriteAggregating(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExternalKey, dataValue);
    }

    protected void WriteTagWriteAggregatingExpression(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceTagWriteAggregatingExpressionExternalKey, dataValue);
    }

    protected void WriteTagWriteAntennaReporting(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceTagWriteAntennaReportingExternalKey, dataValue);
    }

    protected void WriteTagWriteMaskSetting(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceTagWriteMaskSettingExternalKey, dataValue);
    }

    protected void WriteWriteOperations(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceWriteOperationsExternalKey, dataValue);
    }

    protected void WriteWriteOperationsExecuteStatus(Boolean dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceWriteOperationsExecuteStatusExternalKey, dataValue);
    }

    protected void WriteWriteOperationsExpression(String dataValue) throws InterruptedException {
        this.writeMeasurement(this.rfidWriteProfileServiceWriteOperationsExpressionExternalKey, dataValue);
    }

    protected void checkSetWrite(String writeString) throws InterruptedException {
        this.waitSig();
        this.WriteWriteOperations(writeString.toString());
        this.writeTagStartOperation("");
        this.waitSig();
    }

    protected int countTagAggregationReports() {
        NotificationProbe probe = this.getProbe();
        return probe.countKeyPublished(this.rfidWriteProfileServiceTagWriteAggregationReportExternalKey);
    }

    protected String generateReadString(String opId) {
        String readString = new String();
        if (this.testState == 0) {
            readString = this.epc_bit_size == 96 ? this.setReadString("1", "0", "0", "0", "2", "6", "0", "0", String.valueOf(this.timeOutDurationProperty), opId) : this.setReadString("1", "0", "0", "0", "0", "4", "0", "0", String.valueOf(this.timeOutDurationProperty), opId);
        } else if (this.testState == 1) {
            readString = this.setReadString("3", "0", "0", "0", "0", "2", "0", "0", String.valueOf(this.timeOutDurationProperty), opId);
        }
        return readString;
    }

    protected String generateWriteString(Set expectedData) {
        StringBuffer writeString = new StringBuffer();
        int count = 0;
        ArrayList originalInfoList = new ArrayList(this.originalTagInfo);
        if (expectedData.size() != 0) {
            Iterator it = expectedData.iterator();
            while (it.hasNext()) {
                String originalInfoStr = (String)originalInfoList.get(count);
                if (this.testState == 0) {
                    if (this.epc_bit_size == 96) {
                        writeString.append(this.setWriteString("1", "1", "32", "ffffffffffffffffffffffff", originalInfoStr, "2", "0", "0", String.valueOf(this.timeOutDurationProperty), this.writeOperationId, (String)it.next()));
                    } else {
                        writeString.append(this.setWriteString("1", "1", "32", "ffffffffffffffff", originalInfoStr, "2", "0", "0", String.valueOf(this.timeOutDurationProperty), this.writeOperationId, (String)it.next()));
                    }
                } else if (this.testState == 1) {
                    writeString.append(this.setWriteString("3", "3", "0", "ffffffff", originalInfoStr, "0", "0", "0", String.valueOf(this.timeOutDurationProperty), this.writeOperationId, (String)it.next()));
                }
                ++count;
            }
            return writeString.toString();
        }
        writeString.append(this.setWriteString("3", "3", "0", "ffffffff", "0", "0", "0", "0", String.valueOf(this.timeOutDurationProperty), this.writeOperationId, (String)this.writeDataSet.iterator().next()));
        return writeString.toString();
    }

    protected ArrayList getAllTagAggregationReports() {
        NotificationProbe probe = this.getProbe();
        return probe.getAllPublishedValues(this.rfidWriteProfileServiceTagWriteAggregationReportExternalKey, "value");
    }

    protected ArrayList getAllTagReports() {
        NotificationProbe probe = this.getProbe();
        return probe.getAllPublishedValues(this.rfidWriteProfileServiceTagWriteReportExternalKey, "value");
    }

    protected Map getBitsData(long bits) {
        long b = bits;
        HashMap<String, Boolean> value = new HashMap<String, Boolean>();
        int i = 1;
        while (i <= 32) {
            Boolean bitValue = (b & 1L) == 0L ? Boolean.FALSE : Boolean.TRUE;
            value.put("b" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    protected Map getInputsData(long bits) {
        long b = bits;
        HashMap<String, Boolean> value = new HashMap<String, Boolean>();
        int i = 1;
        while (i <= 32) {
            Boolean bitValue = (b & 1L) == 0L ? Boolean.FALSE : Boolean.TRUE;
            value.put("i" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    protected void getKeysAndSettingsFromProperties() {
        super.getKeysAndSettingsFromProperties();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix("Control/Bits");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix("Control/Longs");
        this.gpioProfileServiceAnalogInputExternalKey = this.prependPrefix("Gpio/AnalogInput");
        this.gpioProfileServiceInputExternalKey = this.prependPrefix("Gpio/Input");
        this.rfidWriteProfileServiceAntennaConfigurationExternalKey = this.prependPrefix("RfidWrite/AntennaConfiguration");
        this.rfidWriteProfileServiceCapabilitiesExternalKey = this.prependPrefix("RfidWriteProfile/Capabilities");
        this.rfidWriteProfileServiceConfigurationExternalKey = this.prependPrefix("RfidWriteProfile/Configuration");
        this.rfidWriteProfileServiceDataWriteExtensionsExternalKey = this.prependPrefix("RfidWrite/DataWriteExtensions");
        this.rfidWriteProfileServiceStatusExternalKey = this.prependPrefix("RfidWriteProfile/Status");
        this.rfidWriteProfileServiceTagAggregationWriteMaskSettingExternalKey = this.prependPrefix("RfidWrite/TagAggregationWriteMaskSetting");
        this.rfidWriteProfileServiceTagWriteAggregatingExpressionExternalKey = this.prependPrefix("RfidWrite/TagWriteAggregatingExpression");
        this.rfidWriteProfileServiceTagWriteAggregatingExternalKey = this.prependPrefix("RfidWrite/TagWriteAggregating");
        this.rfidWriteProfileServiceTagWriteAggregationReportExternalKey = this.prependPrefix("RfidWrite/TagWriteAggregationReport");
        this.rfidWriteProfileServiceTagWriteAntennaReportingExternalKey = this.prependPrefix("RfidWrite/TagWriteAntennaReporting");
        this.rfidWriteProfileServiceTagWriteMaskSettingExternalKey = this.prependPrefix("RfidWrite/TagWriteMaskSetting");
        this.rfidWriteProfileServiceTagWriteReportExternalKey = this.prependPrefix("RfidWrite/TagWriteReport");
        this.rfidWriteProfileServiceWriteOperationsExecuteRequestExternalKey = this.prependPrefix("RfidWrite/WriteOperationsExecuteRequest");
        this.rfidWriteProfileServiceWriteOperationsExecuteStatusExternalKey = this.prependPrefix("RfidWrite/WriteOperationsExecuteStatus");
        this.rfidWriteProfileServiceWriteOperationsExpressionExternalKey = this.prependPrefix("RfidWrite/WriteOperationsExpression");
        this.rfidWriteProfileServiceWriteOperationsExternalKey = this.prependPrefix("RfidWrite/WriteOperations");
        this.rfidWriteProfileServiceWriteOperationsStopRequestExternalKey = this.prependPrefix("RfidWrite/WriteOperationsStopRequest");
        this.timeOutDurationProperty = this.getInt("timeout.duration.ms", 3000);
        this.writeOperationKillTime = this.getInt("kill.operation.ms", 30000);
        this.tagWriteString = this.getString("write.string", "");
        this.readString = this.getString("read.string", "");
        this.tagWriteData = this.getString("write.data", "");
        this.writeOperationId = this.getString("write.operationId", "");
        this.readOperationId = this.getString("read.operationId", "");
        this.initialReadOperationId = this.getString("initialRead.operationId", "");
        this.tagEpc = this.getString("tag.epc", "");
        this.epc_bit_size = this.getInt("epc.size", 96);
        this.setWriteDataTags();
        this.setTagEpc();
    }

    protected Map getLongsData(long bits) {
        long b = bits;
        HashMap<String, Long> value = new HashMap<String, Long>();
        int i = 1;
        while (i <= 32) {
            Long bitValue = new Long((b & 1L) == 0L ? 0 : 1);
            value.put("l" + i, bitValue);
            b >>>= 1;
            ++i;
        }
        return value;
    }

    protected List getTagsFromTagAggregationReports(Map expectedDataExtensions) {
        ArrayList tagReports = this.getAllTagAggregationReports();
        List tags = this.verifyTagReadsForTagReports(tagReports, expectedDataExtensions, this.readOperationId);
        return tags;
    }

    protected List getTagsFromTagReports(Map expectedDataExtensions, String operationId) {
        ArrayList tagReports = this.getAllTagReports();
        List tags = this.verifyTagReadsForTagReports(tagReports, expectedDataExtensions, operationId);
        return tags;
    }

    public void initialReadTagDataAndCompare(Set expectedData, Map expectedDataExtensions, boolean noDuplicatesAllowed) {
        HashSet receivedTagSet;
        List receivedTags = this.getTagsFromTagReports(expectedDataExtensions, this.initialReadOperationId);
        this.originalTagInfo = receivedTagSet = new HashSet(receivedTags);
        RfidWriteProfileAbstractTestCase.assertTrue((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1026)), (expectedData.size() <= receivedTagSet.size() ? 1 : 0) != 0);
        if (expectedData.size() == 0) {
            RfidWriteProfileAbstractTestCase.assertEquals((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1027)), (int)receivedTagSet.size(), (int)0);
        }
        if (receivedTagSet.equals(expectedData) && expectedData.size() != 0 && receivedTags.size() != 0) {
            RfidWriteProfileAbstractTestCase.fail((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1022)));
        }
    }

    protected void readAndVerifyTags(Set expectedData, Map expectedDataExtensions, boolean noDuplicatesAllowed) throws InterruptedException {
        this.checkSetWrite(this.generateReadString(this.readOperationId));
        this.waitForTagReports(expectedData.size() * 2, this.timeOutDurationProperty);
        this.verifyExpectedTags(expectedData, expectedDataExtensions, noDuplicatesAllowed, this.readOperationId);
        this.verifyNoAggregationReceived();
    }

    public String replace(String temp, String r1, String r2) {
        StringBuffer buffer = new StringBuffer(temp);
        int index = -1;
        while ((index = buffer.toString().indexOf(r1, index + 1)) != -1) {
            buffer.delete(index, index + r1.length());
            buffer.insert(index, r2);
        }
        return buffer.toString();
    }

    protected String setReadString(String memoryBank, String bitPointer, String tagMask, String tagData, String wordPointer, String wordCount, String password, String operationCount, String timeOut, String operationId) {
        String temp = this.readString;
        temp = this.replace(temp, "{mb}", memoryBank);
        temp = this.replace(temp, "{bp}", bitPointer);
        temp = this.replace(temp, "{tm}", tagMask);
        temp = this.replace(temp, "{td}", tagData);
        temp = this.replace(temp, "{wp}", wordPointer);
        temp = this.replace(temp, "{pw}", password);
        temp = this.replace(temp, "{c}", operationCount);
        temp = this.replace(temp, "{wc}", wordCount);
        temp = this.replace(temp, "{t}", timeOut);
        temp = this.replace(temp, "{id}", operationId);
        return temp;
    }

    private void setTagEpc() {
        String[] tags = RfidWriteProfileAbstractTestCase.parseDelimitedByToken((String)this.tagEpc, (String)",");
        this.tagEpcSet = new HashSet(tags.length);
        this.tagEpcSet.addAll(Arrays.asList(tags));
    }

    private void setWriteDataTags() {
        String[] tags = RfidWriteProfileAbstractTestCase.parseDelimitedByToken((String)this.tagWriteData, (String)",");
        this.writeDataSet = new HashSet(tags.length);
        this.writeDataSet.addAll(Arrays.asList(tags));
    }

    protected String setWriteString(String filterHolder, String memoryBank, String bitPointer, String tagMask, String tagData, String wordPointer, String password, String operationCount, String timeOut, String operationId, String writeData) {
        String temp = this.tagWriteString;
        temp = this.replace(temp, "{ff}", filterHolder);
        temp = this.replace(temp, "{mb}", memoryBank);
        temp = this.replace(temp, "{bp}", bitPointer);
        temp = this.replace(temp, "{tm}", tagMask);
        temp = this.replace(temp, "{td}", tagData);
        temp = this.replace(temp, "{wp}", wordPointer);
        temp = this.replace(temp, "{pw}", password);
        temp = this.replace(temp, "{c}", operationCount);
        temp = this.replace(temp, "{w}", writeData);
        temp = this.replace(temp, "{t}", timeOut);
        temp = this.replace(temp, "{id}", operationId);
        return temp;
    }

    public void tagComparison(List receivedTags, List expectedData) {
        HashSet receivedTagSet = new HashSet(receivedTags);
        HashSet expectedDataSet = new HashSet(expectedData);
        RfidWriteProfileAbstractTestCase.assertEquals(expectedDataSet, receivedTagSet);
    }

    protected void tearDown() throws Exception {
        this.WriteTagWriteAggregatingExpression("");
        this.WriteWriteOperationsExpression("");
        this.WriteTagWriteAggregating(Boolean.FALSE);
        this.writeTagStopWriting("");
        super.tearDown();
    }

    public void verifyAggregationReceived(Set expectedData, Map expectedDataExtensions, boolean noDuplicatesAllowed) throws InterruptedException {
        ArrayList expectedTagWriteDataList = new ArrayList(expectedData);
        int count = this.waitForTagAggregationReports(1, this.maxResponseWaitingTimeProperty);
        RfidWriteProfileAbstractTestCase.assertEquals((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1013)), (int)1, (int)count);
        List receivedTags = this.getTagsFromTagAggregationReports(expectedDataExtensions);
        this.tagComparison(receivedTags, expectedTagWriteDataList);
    }

    public void verifyExpectedTags(Set expectedData, Map expectedDataExtensions, boolean noDuplicatesAllowed, String operationId) throws InterruptedException {
        List receivedTags = this.getTagsFromTagReports(expectedDataExtensions, operationId);
        ArrayList expectedTagList = new ArrayList(expectedData);
        this.tagComparison(receivedTags, expectedTagList);
    }

    protected void verifyNoAggregationReceived() {
        int count = this.countTagAggregationReports();
        RfidWriteProfileAbstractTestCase.assertEquals((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1013)), (int)0, (int)count);
    }

    public void verifyTagAggregationExpression(Set expectedData) throws InterruptedException {
        this.WriteTagWriteAggregatingExpression(AND_EXPRESSION);
        this.WriteWriteOperationsExpression(OR_EXPRESSION);
        this.ReportInput(this.getInputsData(1L));
        this.ReportBits(this.getBitsData(-2147483647L));
        this.waitSig();
        this.ReportLongs(this.getLongsData(2L));
        this.waitSig();
        this.waitForTagReports(expectedData.size() * 2, this.timeOutDurationProperty);
        this.ReportBits(this.getBitsData(Integer.MIN_VALUE));
        this.verifyExpectedTags(expectedData, null, false, null);
        this.verifyNoAggregationReceived();
        this.ReportInput(this.getInputsData(0L));
        this.verifyAggregationReceived(expectedData, null, false);
        this.ReportBits(this.getBitsData(0L));
        this.ReportLongs(this.getLongsData(0L));
    }

    protected List verifyTagReadsForTagReports(ArrayList tagReports, Map expectedDataExtensions, String operationId) {
        ArrayList<String> tagRDL = new ArrayList<String>();
        String copyOfOperationId = operationId;
        int i = 0;
        while (i < tagReports.size()) {
            Map tagReport = (Map)tagReports.get(i);
            Map tagReads = (Map)tagReport.get("tags");
            Iterator tags = tagReads.keySet().iterator();
            while (tags.hasNext()) {
                Long timestampLast;
                Long timestampFirst;
                Integer count;
                Integer antenna;
                String tag = (String)tags.next();
                if (tag.equals("dataExtensions")) continue;
                Map tagMapMap = (Map)tagReads.get(tag);
                Iterator it = tagMapMap.keySet().iterator();
                String opId = (String)it.next();
                if (copyOfOperationId == null) {
                    copyOfOperationId = opId;
                }
                if (!copyOfOperationId.equals(opId)) continue;
                Map tagData = (Map)tagMapMap.get(opId);
                byte[] readData = (byte[])tagData.get("readData");
                if (readData != null) {
                    String readDataStr = new String();
                    readDataStr = RfidWriteProfileAbstractTestCase.byteArray2Str(readData);
                    tagRDL.add(readDataStr.toUpperCase());
                }
                if ((antenna = (Integer)tagData.get("antenna")) != null) {
                    RfidWriteProfileAbstractTestCase.assertTrue((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1007)), (antenna >= 0 ? 1 : 0) != 0);
                }
                if ((count = (Integer)tagData.get("count")) != null) {
                    RfidWriteProfileAbstractTestCase.assertTrue((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1008)), (count > 0 ? 1 : 0) != 0);
                }
                if ((timestampFirst = (Long)tagData.get("timestampFirst")) != null) {
                    RfidWriteProfileAbstractTestCase.assertTrue((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1010)), (timestampFirst > 0L ? 1 : 0) != 0);
                }
                if ((timestampLast = (Long)tagData.get("timestampLast")) == null) continue;
                RfidWriteProfileAbstractTestCase.assertTrue((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1011)), (timestampLast >= timestampLast ? 1 : 0) != 0);
            }
            Map dataExtensions = (Map)tagReport.get("dataExtensions");
            if (expectedDataExtensions == null) {
                RfidWriteProfileAbstractTestCase.assertNotNull((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1012)), (Object)dataExtensions);
            } else {
                RfidWriteProfileAbstractTestCase.assertEquals((String)RfidWriteProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(1012)), (Object)expectedDataExtensions, (Object)dataExtensions);
            }
            ++i;
        }
        return tagRDL;
    }

    protected void verifyTagWriteData(Set expectedData) throws InterruptedException {
        this.verifyTagWriteData(expectedData, null);
    }

    protected void verifyTagWriteData(Set expectedData, Map expectedDataExtensions) throws InterruptedException {
        this.checkSetWrite(this.generateReadString(this.initialReadOperationId));
        this.waitForTagReports(expectedData.size() * 2, this.timeOutDurationProperty);
        this.initialReadTagDataAndCompare(expectedData, expectedDataExtensions, false);
    }

    protected void verifyTagWritingAndAggregating(Set expectedData, Map expectedDataExtensions) throws InterruptedException {
        this.WriteTagWriteAggregating(Boolean.TRUE);
        this.checkSetWrite(this.generateWriteString(expectedData));
        this.waitForTagReports(expectedData.size() * 2, this.timeOutDurationProperty);
        this.readAndVerifyTags(expectedData, expectedDataExtensions, false);
        this.WriteTagWriteAggregating(Boolean.FALSE);
        this.verifyAggregationReceived(expectedData, expectedDataExtensions, false);
    }

    public void verifyTagWritingAndAggregation(Set expectedData) throws InterruptedException {
        this.verifyTagWriteData(expectedData);
        this.verifyTagWritingAndAggregating(expectedData, null);
    }

    public void verifyTagWritingExpression(Set expectedData) throws InterruptedException {
        this.WriteTagWriteAggregatingExpression(AND_EXPRESSION);
        this.WriteWriteOperationsExpression(OR_EXPRESSION);
        this.ReportInput(this.getInputsData(-2147483647L));
        this.waitSig();
        this.waitForTagReports(2 + expectedData.size() * 2, this.timeOutDurationProperty);
        this.ReportInput(this.getInputsData(0L));
        this.verifyExpectedTags(expectedData, null, false, null);
        this.verifyNoAggregationReceived();
    }

    protected int waitForTagAggregationReports(int expectedCount, int duration) throws InterruptedException {
        return this.waitForSignal(this.rfidWriteProfileServiceTagWriteAggregationReportExternalKey, expectedCount, duration);
    }

    protected int waitForTagReports(int expectedCount, int duration) throws InterruptedException {
        return this.waitForSignal(this.rfidWriteProfileServiceTagWriteReportExternalKey, expectedCount, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitSig() throws InterruptedException {
        boolean writeOperationWriteStatus = true;
        long current = System.currentTimeMillis();
        long timeOut = this.writeOperationKillTime;
        RfidWriteProfileAbstractTestCase rfidWriteProfileAbstractTestCase = this;
        synchronized (rfidWriteProfileAbstractTestCase) {
            while (true) {
                if (!writeOperationWriteStatus) {
                    return;
                }
                writeOperationWriteStatus = this.GetWriteOperationsExecuteStatus();
                try {
                    if (!writeOperationWriteStatus) continue;
                    long time = System.currentTimeMillis();
                    long wait = time - current;
                    if (timeOut > wait) {
                        this.wait(1000L);
                        continue;
                    }
                    this.writeTagStopWriting("");
                    RfidWriteProfileAbstractTestCase.fail((String)"TimeOut exceeded");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void writeTagStartOperation(String dataValue) throws InterruptedException {
        this.executeCommand(this.rfidWriteProfileServiceWriteOperationsExecuteRequestExternalKey, dataValue);
    }

    protected void writeTagStopWriting(String dataValue) throws InterruptedException {
        this.executeCommand(this.rfidWriteProfileServiceWriteOperationsStopRequestExternalKey, dataValue);
    }

    public static String byteArray2Str(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = Integer.toHexString(bytes[i] & 0xFF);
            if (oneByte.length() == 1) {
                result.append("0");
            }
            result.append(oneByte);
            ++i;
        }
        return result.toString();
    }
}

