/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.write.profile.testcases;

import java.util.Dictionary;
import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.notification.Notification;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.write.profile.testcases.RfidWriteProfileTester;

public class RfidWriteTestcaseSingle
extends TestCase
implements NotificationListener {
    public static final String RESOURCE_BUNDLE = "ResourceBundle";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.rfid.write.profile.testcases.RfidWriteTestcaseSingle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public RfidWriteTestcaseSingle(String name) {
        super(name);
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append("Notification: ");
        buffer.append(externalKey);
        buffer.append(" data: ");
        Nls.formatData((StringBuffer)buffer, (Object)data);
        System.out.println(buffer.toString());
    }

    public void test01() {
        NotificationService notificationService = Notification.createBroker();
        notificationService.register("#", (NotificationListener)this);
        RfidWriteProfileTester rfidWriteProfileTester = new RfidWriteProfileTester();
        rfidWriteProfileTester.setNotificationService(notificationService);
        rfidWriteProfileTester.autonomousModeOn();
        HashMap<String, Integer> value = new HashMap<String, Integer>();
        value.put("peakRSSI", new Integer(0));
        value.put("antenna", new Integer(1));
        rfidWriteProfileTester.notifyTagReport("123", "1", value, new Integer(100));
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {}
        HashMap<String, Integer> value1 = new HashMap<String, Integer>();
        value1.put("peakRSSI", new Integer(1));
        value1.put("antenna", new Integer(2));
        rfidWriteProfileTester.notifyTagReport("123", "1", value1, new Integer(101));
        HashMap<String, Integer> value2 = new HashMap<String, Integer>();
        value2.put("peakRSSI", new Integer(2));
        value2.put("antenna", new Integer(2));
        rfidWriteProfileTester.notifyTagReport("123", "1", value2, new Integer(102));
        HashMap<String, Integer> value3 = new HashMap<String, Integer>();
        value3.put("peakRSSI", new Integer(3));
        value3.put("antenna", new Integer(3));
        rfidWriteProfileTester.notifyTagReport("123", "1", value3, new Integer(103));
        rfidWriteProfileTester.autonomousModeOff();
    }
}

