/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.serial.connection;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.serial.connection.SerialPortListener;
import org.eclipse.soda.dk.serial.connection.service.SerialConnectionService;

public class SerialConnection
extends StreamConnection
implements ConnectionService,
SerialConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.serial.connection.SerialConnection";
    private static final String PREFIX = EscObject.getStaticString((String)"serialconnection.prefix", (String)"COM");
    protected static final char[] TOSTRING_NAME = "SerialConnection[".toCharArray();
    private static final int[] DATABITS_TABLE = new int[]{-1, -1, -1, -1, -1, 5, 6, 7, 8};
    private static final int[] STOP_TABLE = new int[]{1, 3, 2};
    private static final int[] PARITY_TABLE;
    private SerialPort port = null;
    private String portName;
    private long receivedTotalTimeout = 1000L;
    private SerialPortListener serialPortListener = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        PARITY_TABLE = nArray;
    }

    public static String getPortName(int portNumber) {
        return String.valueOf(PREFIX) + String.valueOf(portNumber);
    }

    public SerialConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
        int portNumber = this.getInt("comport", 1);
        this.portName = SerialConnection.getPortName(portNumber);
    }

    public SerialConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public SerialConnection(int portNumber, int baudRate, int dataBits, int parity, int stopBits, int hardwareFlowControl, int softwareFlowControl, int readTotalTimeout, int readIntervalTimeout, int writeTotalTimeout) throws IllegalArgumentException {
        this(SerialConnection.getPortName(portNumber), baudRate, dataBits, parity, stopBits, hardwareFlowControl, softwareFlowControl, readTotalTimeout, readIntervalTimeout, writeTotalTimeout);
    }

    public SerialConnection(String portName, int baudRate, int dataBits, int parity, int stopBits, int hardwareFlowControl, int softwareFlowControl, int readTotalTimeout, int readIntervalTimeout, int writeTotalTimeout) throws IllegalArgumentException {
        this.portName = portName;
        Hashtable<String, Number> table = new Hashtable<String, Number>();
        table.put("baudrate", SerialConnection.createInteger((int)baudRate));
        table.put("databits", SerialConnection.createInteger((int)dataBits));
        table.put("parity", SerialConnection.createInteger((int)parity));
        table.put("stopbits", SerialConnection.createInteger((int)stopBits));
        table.put("hardwareflowcontrol", SerialConnection.createInteger((int)hardwareFlowControl));
        table.put("softwareflowcontrol", SerialConnection.createInteger((int)softwareFlowControl));
        table.put("readtotaltimeout", SerialConnection.createNumber((long)readTotalTimeout));
        table.put("readintervaltimeout", SerialConnection.createNumber((long)readIntervalTimeout));
        table.put("writetotaltimeout", SerialConnection.createNumber((long)writeTotalTimeout));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public void changeBaudRate(int baudRate) throws RuntimeException {
        this.getConfigurationService().getProperties().put("baudrate", SerialConnection.createInteger((int)baudRate));
        try {
            this.port.setSerialPortParams(this.getInt("baudrate", 19200), DATABITS_TABLE[this.getInt("databits", 8)], STOP_TABLE[this.getInt("stopbits", 0)], PARITY_TABLE[this.getInt("parity", 0)]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.port != null) {
            this.port.removeEventListener();
            Exception exception = null;
            try {
                this.port.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.port = null;
            this.handleError(exception, 1002, this.toString());
        }
    }

    public String getOutputName() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(super.getOutputName());
        buffer.append(',');
        buffer.append(this.portName);
        return buffer.toString();
    }

    public long getReceivedTotalTimeout() {
        return this.receivedTotalTimeout;
    }

    public String getType() {
        return "serial";
    }

    public synchronized void open() throws IOException {
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.portName);
            CommPort commPort = commPortIdentifier.open(this.toString(), 1000);
            if (commPort instanceof SerialPort) {
                boolean hardware;
                boolean software;
                this.port = (SerialPort)commPort;
                this.port.setSerialPortParams(this.getInt("baudrate", 19200), DATABITS_TABLE[this.getInt("databits", 8)], STOP_TABLE[this.getInt("stopbits", 0)], PARITY_TABLE[this.getInt("parity", 0)]);
                int flowControl = 0;
                boolean bl = software = this.getInt("softwareflowcontrol", 0) == 1;
                if (software) {
                    flowControl = flowControl | 4 | 8;
                }
                boolean bl2 = hardware = this.getInt("hardwareflowcontrol", 0) == 1;
                if (hardware) {
                    flowControl = flowControl | 1 | 2;
                }
                if (flowControl != 0) {
                    this.port.setFlowControlMode(flowControl);
                }
                this.setReceivedTotalTimeout(this.getLong("readtotaltimeout", 1000L));
                this.port.enableReceiveTimeout((int)this.getReceivedTotalTimeout());
                this.serialPortListener = new SerialPortListener(this.port);
                this.setInputStream(this.port.getInputStream());
                this.setOutputStream(this.port.getOutputStream());
                super.open();
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes) throws IOException {
        int count = super.read(bytes);
        if (count == 0) {
            SerialPortListener serialPortListener = this.serialPortListener;
            synchronized (serialPortListener) {
                try {
                    this.serialPortListener.wait(this.getReceivedTotalTimeout());
                }
                catch (Exception exception) {}
            }
            count = super.read(bytes);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = super.read(bytes, offset, length);
        if (count == 0) {
            SerialPortListener serialPortListener = this.serialPortListener;
            synchronized (serialPortListener) {
                try {
                    this.serialPortListener.wait(this.getReceivedTotalTimeout());
                }
                catch (Exception exception) {}
            }
            count = super.read(bytes, offset, length);
        }
        return count;
    }

    public void setReceivedTotalTimeout(long timeout) {
        this.receivedTotalTimeout = timeout;
    }
}

