/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Os;
import org.eclipse.soda.dk.tcpip.connection.service.TcpipConnectionService;

public class TcpipConnection
extends StreamConnection
implements ConnectionService,
TcpipConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.tcpip.connection.TcpipConnection";
    public static final String[] TO_STRING_CONFIGURATION_KEYS = new String[]{"id", "host", "remoteport"};
    private Socket port = null;

    public TcpipConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    public TcpipConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public TcpipConnection(Socket port) {
        this.port = port;
    }

    public TcpipConnection(String targetHost, int targetPort) {
        this(targetHost, targetPort, -1);
    }

    public TcpipConnection(String targetHost, int targetPort, int localPort) {
        this(targetHost, targetPort, localPort, 100);
    }

    public TcpipConnection(String targetHost, int targetPort, int localPort, int timeout) {
        this(targetHost, targetPort, localPort, timeout, -1, -1, -1);
    }

    public TcpipConnection(String targetHost, int targetPort, int localPort, int timeout, int sendBufferSize, int receiveBufferSize) {
        this(targetHost, targetPort, localPort, timeout, sendBufferSize, receiveBufferSize, 0);
    }

    public TcpipConnection(String targetHost, int targetPort, int localPort, int timeout, int sendBufferSize, int receiveBufferSize, int linger) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("remotehost", targetHost);
        table.put("remoteport", TcpipConnection.createInteger((int)targetPort));
        table.put("readtimeout", TcpipConnection.createInteger((int)timeout));
        table.put("localport", TcpipConnection.createInteger((int)localPort));
        table.put("readsize", TcpipConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", TcpipConnection.createInteger((int)sendBufferSize));
        table.put("linger", TcpipConnection.createInteger((int)linger));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public TcpipConnection(String localHost, int localPort, String targetHost, int targetPort, int timeout, int sendBufferSize, int receiveBufferSize, int linger) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (localHost != null) {
            table.put("localhost", localHost);
        }
        table.put("localport", TcpipConnection.createInteger((int)localPort));
        table.put("remotehost", targetHost);
        table.put("remoteport", TcpipConnection.createInteger((int)targetPort));
        table.put("readtimeout", TcpipConnection.createInteger((int)timeout));
        table.put("readsize", TcpipConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", TcpipConnection.createInteger((int)sendBufferSize));
        table.put("linger", TcpipConnection.createInteger((int)linger));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.port != null) {
            Exception exception = null;
            try {
                this.port.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.port = null;
            this.handleError(exception, 1002, this.toString());
        }
    }

    public void exit() throws IOException {
        try {
            this.close();
        }
        catch (Exception exception) {}
        this.port = null;
    }

    public Socket getPort() {
        return this.port;
    }

    public boolean isOpen() {
        return this.port != null;
    }

    public synchronized void open() throws IOException {
        if (this.port == null) {
            String targetAddress = this.getString("remotehost", null);
            if (targetAddress == null) {
                targetAddress = this.getString("host", "localhost");
            }
            int targetPortNumber = this.getInt("remoteport", 23);
            int localPortNumber = this.getInt("localport", -1);
            int timeout = this.getInt("readtimeout", 1000);
            int receiveBufferSize = this.getInt("readsize", -1);
            int sendBufferSize = this.getInt("writesize", -1);
            int linger = this.getInt("linger", -1);
            if (localPortNumber >= 0) {
                String localAddressName = this.getString("localhost", null);
                InetAddress localAddress = localAddressName == null ? InetAddress.getLocalHost() : InetAddress.getByName(localAddressName);
                this.port = new Socket(targetAddress, targetPortNumber, localAddress, localPortNumber);
            } else {
                this.port = new Socket(targetAddress, targetPortNumber);
            }
            this.port.setTcpNoDelay(true);
            if (timeout >= 0) {
                this.port.setSoTimeout(timeout);
            }
            if (linger >= 0) {
                if (linger == 0) {
                    this.port.setSoLinger(false, 0);
                } else {
                    this.port.setSoLinger(true, linger);
                }
            }
            if (receiveBufferSize > 0 && !Os.isNeutrino()) {
                this.port.setReceiveBufferSize(receiveBufferSize);
            }
            if (sendBufferSize > 0 && !Os.isNeutrino()) {
                this.port.setSendBufferSize(sendBufferSize);
            }
        }
        this.setInputStream(this.port.getInputStream());
        this.setOutputStream(this.port.getOutputStream());
        super.open();
    }

    public void setPort(Socket port) {
        this.port = port;
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        if (this.port == null) {
            buffer.append(this.getString("host", "localhost"));
            buffer.append(':');
            buffer.append(this.getInt("remoteport", 23));
        } else {
            buffer.append(this.port);
        }
    }
}

