/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.multiplex.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import org.eclipse.soda.dk.multiplex.connection.ChannelBinding;
import org.eclipse.soda.dk.nls.Os;
import org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipMultiplexConnection;

public class SocketChannelBinding
extends ChannelBinding {
    private InetSocketAddress remoteAddress;
    private SocketChannel socketChannel;

    public SocketChannelBinding(String id) {
        super(id);
    }

    public synchronized void close() {
        if (this.getState() > 1) {
            try {
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                }
            }
            catch (IOException e) {
                this.handleError(e, 1);
            }
            this.socketChannel = null;
            this.setState(1);
        }
    }

    private TcpipMultiplexConnection getConnection() {
        return (TcpipMultiplexConnection)this.getListener();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public boolean isReconnectable() {
        return this.getState() != 0 && this.remoteAddress != null;
    }

    public void open() {
        if (this.getState() < 2) {
            if (this.socketChannel != null) {
                if (this.socketChannel.isOpen()) {
                    this.setState(3);
                } else if (this.socketChannel.isConnectionPending()) {
                    this.setState(2);
                } else {
                    this.socketChannel = null;
                }
            }
            if (this.getState() < 2) {
                if (this.remoteAddress == null) {
                    this.handleError(new IllegalStateException(), 1);
                } else {
                    try {
                        int receiveBufferSize = this.getInt("readsize", -1);
                        int sendBufferSize = this.getInt("writesize", -1);
                        int linger = this.getInt("linger", -1);
                        this.socketChannel = SocketChannel.open();
                        this.socketChannel.configureBlocking(false);
                        Socket socket = this.socketChannel.socket();
                        socket.setTcpNoDelay(true);
                        if (linger >= 0) {
                            if (linger == 0) {
                                socket.setSoLinger(false, 0);
                            } else {
                                socket.setSoLinger(true, linger);
                            }
                        }
                        if (receiveBufferSize > 0 && !Os.isNeutrino()) {
                            socket.setReceiveBufferSize(receiveBufferSize);
                        }
                        if (sendBufferSize > 0 && !Os.isNeutrino()) {
                            socket.setSendBufferSize(sendBufferSize);
                        }
                        this.setState(2);
                        this.getConnection().connect(this);
                    }
                    catch (IOException e) {
                        this.handleError(e, 1);
                    }
                }
            }
        }
    }

    public void setRemoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void start() {
        if (this.getState() == 2) {
            try {
                this.socketChannel.finishConnect();
                this.setState(3);
            }
            catch (IOException e) {
                this.setState(this.isReconnectable() ? 1 : 0);
                this.handleError(e, 1014);
            }
        }
        if (this.getState() == 3) {
            this.setState(4);
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        SocketAddress remoteSocketAddress;
        Socket socket;
        super.toStringInfo(buffer);
        if (this.socketChannel != null && (socket = this.socketChannel.socket()) != null && (remoteSocketAddress = socket.getRemoteSocketAddress()) != null) {
            buffer.append(",remoteAddr=");
            buffer.append(remoteSocketAddress);
        }
    }
}

