/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.server.multiplex.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.tcpip.multiplex.connection.SocketChannelBinding;
import org.eclipse.soda.dk.tcpip.multiplex.connection.TcpipMultiplexConnection;
import org.eclipse.soda.dk.tcpip.server.multiplex.connection.service.TcpipServerMultiplexConnectionService;

public class TcpipServerMultiplexConnection
extends TcpipMultiplexConnection
implements ConnectionService,
TcpipServerMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.tcpip.server.multiplex.connection.TcpipServerMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "TcpipServerMultiplexConnection[".toCharArray();
    private ServerSocketChannel serverChannel;

    private static ConfigurationService createConfiguration(int port, int queueLength, int linger) {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        table.put("port", TcpipServerMultiplexConnection.createInteger((int)port));
        table.put("queuelength", TcpipServerMultiplexConnection.createInteger((int)queueLength));
        table.put("linger", TcpipServerMultiplexConnection.createInteger((int)linger));
        return new EscConfiguration(table);
    }

    public TcpipServerMultiplexConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public TcpipServerMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public TcpipServerMultiplexConnection(int port) {
        this(port, -1);
    }

    public TcpipServerMultiplexConnection(int port, int queueLength) {
        this(port, queueLength, -1);
    }

    public TcpipServerMultiplexConnection(int port, int queueLength, int timeout) {
        this(port, queueLength, timeout, -1);
    }

    public TcpipServerMultiplexConnection(int port, int queueLength, int timeout, int linger) {
        super(TcpipServerMultiplexConnection.createConfiguration(port, queueLength, linger));
    }

    public synchronized void close() throws IOException {
        if (this.serverChannel != null) {
            Throwable exception = null;
            try {
                this.serverChannel.close();
                this.serverChannel = null;
            }
            catch (Exception exception2) {
                this.report(exception, 1002, this.toString());
            }
        }
        super.close();
    }

    private void initServerSocket() throws IOException {
        int port = this.getInt("port", 8901);
        int queueLength = this.getInt("queuelength", -1);
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        InetSocketAddress endpoint = new InetSocketAddress(port);
        if (queueLength != -1) {
            serverSocket.bind(endpoint, queueLength);
        } else {
            serverSocket.bind(endpoint);
        }
        this.serverChannel.register(this.selector, 16);
    }

    public synchronized void open() throws IOException {
        super.open();
        if (this.serverChannel == null) {
            this.initServerSocket();
        }
    }

    protected void processAccept(MultiplexConnectionListener listener, SelectionKey key) throws IOException {
        block5: {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
            SocketChannel socketChannel = serverSocketChannel.accept();
            SocketChannelBinding channel = null;
            try {
                socketChannel.configureBlocking(false);
                Socket socket = socketChannel.socket();
                socket.setTcpNoDelay(true);
                int linger = this.getInt("linger", -1);
                if (linger >= 0) {
                    if (linger == 0) {
                        socket.setSoLinger(false, 0);
                    } else {
                        socket.setSoLinger(true, linger);
                    }
                }
                channel = this.createChannel(this.createChannelId());
                channel.setSocketChannel(socketChannel);
                channel.open();
                socketChannel.register(this.selector, 1);
                channel.start();
            }
            catch (IOException e) {
                this.handleError(e, 1015, channel);
                if (channel == null) break block5;
                channel.exit();
            }
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        if (this.serverChannel != null) {
            buffer.append(this.serverChannel);
        } else {
            int port = this.getInt("port", 8901);
            buffer.append(port);
        }
    }
}

