/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;

public class ConsoleSynchronization
implements TestSynchronizationService {
    protected synchronized void printEvent(boolean error, String message, String detail) {
        PrintStream out = error ? System.err : System.out;
        String timestamp = Nls.formatTimestamp((long)System.currentTimeMillis());
        out.print(timestamp);
        out.print(' ');
        out.println(message);
        if (detail != null) {
            out.println(detail);
        }
        out.flush();
    }

    public synchronized boolean requestConfirmation(String prompt, String testName) throws InterruptedException {
        System.out.println();
        Object[] parms1 = new Object[]{testName};
        System.out.println(Nls.format((String)TestAgent.DefaultResourceBundle.getString(Integer.toString(7008)), (Object[])parms1));
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        boolean confirm = false;
        try {
            boolean cancel;
            do {
                Object[] parms2 = new Object[]{prompt};
                System.out.print(Nls.format((String)TestAgent.DefaultResourceBundle.getString(Integer.toString(7007)), (Object[])parms2));
                System.out.flush();
                line = reader.readLine();
                confirm = TestAgent.DefaultResourceBundle.getString(Integer.toString(7009)).equalsIgnoreCase(line);
                cancel = TestAgent.DefaultResourceBundle.getString(Integer.toString(7010)).equalsIgnoreCase(line);
                if (confirm || cancel) continue;
                System.out.println(TestAgent.DefaultResourceBundle.getString(Integer.toString(7011)));
            } while (!confirm && !cancel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println();
        return confirm;
    }
}

