/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent.framework;

import java.io.IOException;
import java.util.Dictionary;
import junit.framework.TestCase;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.framework.TestContext;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;

public abstract class ConfiguredTestCase
extends TestCase
implements ConfigurationService {
    private TestContext context = TestAgent.getTestContext();

    public static void assertEquals(boolean expected, boolean actual) {
        ConfiguredTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        ConfiguredTestCase.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message, boolean expected, boolean actual) {
        ConfiguredTestCase.assertEquals((String)message, (Object)(expected ? Boolean.TRUE : Boolean.FALSE), (Object)(actual ? Boolean.TRUE : Boolean.FALSE));
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (new Double(expected).compareTo(new Double(actual)) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            ConfiguredTestCase.failNotEquals((String)message, (Object)new Double(expected), (Object)new Double(actual));
        }
    }

    protected ConfiguredTestCase() {
    }

    protected ConfiguredTestCase(String name) {
        super(name);
    }

    public boolean getBoolean(String key, boolean defaultBoolean) {
        return this.getConfigurationService().getBoolean(key, defaultBoolean);
    }

    public ConfigurationService getConfigurationService() {
        ConfigurationService configurationService = this.context.getConfigurationService();
        ConfiguredTestCase.assertNotNull((String)TestAgent.DefaultResourceBundle.getString(Integer.toString(7001)), (Object)configurationService);
        return configurationService;
    }

    public TestContext getContext() {
        return this.context;
    }

    public float getFloat(String key, float defaultFloat) {
        return this.getConfigurationService().getFloat(key, defaultFloat);
    }

    public int getInt(String key, int defaultInt) {
        return this.getConfigurationService().getInt(key, defaultInt);
    }

    public long getLong(String key, long defaultLong) {
        return this.getConfigurationService().getLong(key, defaultLong);
    }

    public Object getObject(String key, Object defaultObject) {
        return this.getConfigurationService().getObject(key, defaultObject);
    }

    public Dictionary getProperties() {
        return this.getConfigurationService().getProperties();
    }

    public String getString(String key, String defaultString) {
        return this.getConfigurationService().getString(key, defaultString);
    }

    public TestSynchronizationService getSynchronizationService() {
        TestSynchronizationService synchronizationService = this.context.getSynchronizationService();
        ConfiguredTestCase.assertNotNull((String)TestAgent.DefaultResourceBundle.getString(Integer.toString(7002)), (Object)synchronizationService);
        return synchronizationService;
    }

    public boolean requestConfirmation(String prompt) throws InterruptedException, IOException {
        return this.getSynchronizationService().requestConfirmation(prompt, this.toString());
    }

    public String toString() {
        return String.valueOf(this.context.getTestAgent().getDescription()) + ": " + super.toString();
    }
}

