/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testagent.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.testagent.util.Delay;

public class NotificationProbe
implements NotificationListener {
    private ArrayList receivedKeys;
    private ArrayList receivedData;
    private int markIndex;

    public NotificationProbe() {
        this.clear();
    }

    private static boolean contains(Dictionary received, Dictionary data) {
        Enumeration e = data.keys();
        while (e.hasMoreElements()) {
            Object dataKey = e.nextElement();
            Object value = data.get(dataKey);
            Object receivedValue = received.get(dataKey);
            if (receivedValue == value || value != null && value.equals(receivedValue)) continue;
            return false;
        }
        return true;
    }

    public static Dictionary toData(Object dataKey, Object dataValue) {
        Hashtable<Object, Object> data = new Hashtable<Object, Object>(1);
        ((Dictionary)data).put(dataKey, dataValue);
        return data;
    }

    public synchronized void clear() {
        this.clearMark();
        this.receivedKeys = new ArrayList();
        this.receivedData = new ArrayList();
    }

    public synchronized void clearMark() {
        this.markIndex = 0;
    }

    private boolean contains(int receivedIndex, Dictionary data) {
        Dictionary received = (Dictionary)this.receivedData.get(receivedIndex);
        return NotificationProbe.contains(received, data);
    }

    public int countKeyPublished(String topicKey, Object dataKey, Object dataValue, long duration) {
        return this.countKeyPublished(topicKey, NotificationProbe.toData(dataKey, dataValue), duration);
    }

    public int countKeyPublished(String topicKey, Dictionary data, long duration) {
        Delay.milliseconds(duration);
        return this.countKeyPublished(topicKey, data);
    }

    public int countKeyPublished(String topicKey, Object dataKey, Object dataValue) {
        return this.countKeyPublished(topicKey, NotificationProbe.toData(dataKey, dataValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countKeyPublished(String topicKey, Dictionary data) {
        int result = 0;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.markIndex;
            while (i < this.receivedKeys.size()) {
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey) && this.contains(i, data)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public int countKeyPublished(String topicKey, long duration) {
        Delay.milliseconds(duration);
        return this.countKeyPublished(topicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countKeyPublished(String topicKey) {
        int result = 0;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.markIndex;
            while (i < this.receivedKeys.size()) {
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey)) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllPublishedData(String topicKey) {
        ArrayList data = new ArrayList();
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.markIndex;
            while (i < this.receivedKeys.size()) {
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey)) {
                    data.add(this.receivedData.get(i));
                }
                ++i;
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllPublishedValues(String topicKey, String dataKey) {
        ArrayList values = new ArrayList();
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.markIndex;
            while (i < this.receivedKeys.size()) {
                Dictionary data;
                Object value;
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey) && (value = (data = (Dictionary)this.receivedData.get(i)).get(dataKey)) != null) {
                    values.add(value);
                }
                ++i;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getFirstPublishedData(String topicKey) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.markIndex;
            while (i < this.receivedKeys.size()) {
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey)) {
                    return (Dictionary)this.receivedData.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public Object getFirstPublishedValue(String topicKey, String dataKey) {
        Dictionary data = this.getFirstPublishedData(topicKey);
        return data.get(dataKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary getLastPublishedData(String topicKey) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.receivedKeys.size() - 1;
            while (i >= this.markIndex) {
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey)) {
                    return (Dictionary)this.receivedData.get(i);
                }
                --i;
            }
        }
        return null;
    }

    public Object getLastPublishedValue(String topicKey, String dataKey) {
        Dictionary data = this.getLastPublishedData(topicKey);
        return data.get(dataKey);
    }

    public synchronized void notificationReceived(String externalKey, Dictionary data) {
        this.receivedKeys.add(externalKey);
        this.receivedData.add(data);
        this.notifyAll();
    }

    public synchronized void setMark() {
        this.markIndex = this.receivedKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitKeyPublished(String topicKey, Dictionary data, int expectedCount, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        int count = 0;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (now < limitTime) {
                count = this.countKeyPublished(topicKey, data);
                if (count >= expectedCount) {
                    return count;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitKeyPublished(String topicKey, int expectedCount, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        int count = 0;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (now < limitTime) {
                count = this.countKeyPublished(topicKey);
                if (count >= expectedCount) {
                    return count;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String waitKeyPublished(String[] topicKeys, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        String receivedKey = null;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (now < limitTime) {
                receivedKey = this.wasKeyPublished(topicKeys);
                if (receivedKey != null) {
                    return receivedKey;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
        return receivedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasDataPublished(Dictionary data, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (true) {
                if (now >= limitTime) {
                    return false;
                }
                boolean wasPublished = this.wasDataPublished(data);
                if (wasPublished) {
                    return true;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasDataPublished(Dictionary data) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.receivedData.size() - 1;
            while (true) {
                if (i < this.markIndex) {
                    return false;
                }
                if (this.contains(i, data)) {
                    return true;
                }
                --i;
            }
        }
    }

    public boolean wasKeyPublished(String topicKey, Object dataKey, Object dataValue, int duration) throws InterruptedException {
        return this.wasKeyPublished(topicKey, NotificationProbe.toData(dataKey, dataValue), duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasKeyPublished(String topicKey, Dictionary data, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (true) {
                if (now >= limitTime) {
                    return false;
                }
                boolean wasPublished = this.wasKeyPublished(topicKey, data);
                if (wasPublished) {
                    return true;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
    }

    public boolean wasKeyPublished(String topicKey, Object dataKey, Object dataValue) {
        return this.wasKeyPublished(topicKey, NotificationProbe.toData(dataKey, dataValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasKeyPublished(String topicKey, Dictionary data) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.receivedKeys.size() - 1;
            while (true) {
                if (i < this.markIndex) {
                    return false;
                }
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey) && this.contains(i, data)) {
                    return true;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasKeyPublished(String topicKey) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.receivedKeys.size() - 1;
            while (true) {
                if (i < this.markIndex) {
                    return false;
                }
                String receivedKey = (String)this.receivedKeys.get(i);
                if (topicKey.equals(receivedKey)) {
                    return true;
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String wasKeyPublished(String[] topicKeys) {
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            int i = this.receivedKeys.size() - 1;
            while (i >= this.markIndex) {
                String receivedKey = (String)this.receivedKeys.get(i);
                int j = 0;
                while (j < topicKeys.length) {
                    if (topicKeys[j].equals(receivedKey)) {
                        return receivedKey;
                    }
                    ++j;
                }
                --i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasKeyPublished(String topicKey, int duration) throws InterruptedException {
        long now = System.currentTimeMillis();
        long limitTime = now + (long)duration;
        NotificationProbe notificationProbe = this;
        synchronized (notificationProbe) {
            while (true) {
                if (now >= limitTime) {
                    return false;
                }
                boolean wasPublished = this.wasKeyPublished(topicKey);
                if (wasPublished) {
                    return true;
                }
                long time = limitTime - now;
                this.wait(time);
                now = System.currentTimeMillis();
            }
        }
    }

    public boolean wasValuePublished(Object dataKey, Object dataValue, int duration) throws InterruptedException {
        return this.wasDataPublished(NotificationProbe.toData(dataKey, dataValue), duration);
    }

    public boolean wasValuePublished(Object dataKey, Object dataValue) {
        return this.wasDataPublished(NotificationProbe.toData(dataKey, dataValue));
    }
}

