/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.test.managed;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.ConfigurableObject;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.transport.test.service.TransportTestService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public abstract class TransportTestManaged
extends BaseBundleActivator
implements ManagedService {
    private TransportTestService transportTest = null;
    private TransportService transport = null;
    private Dictionary managedProperties = null;
    private boolean factoryConnection = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void activate() {
        Hashtable properties = this.createManagedProperties();
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        stringArray[1] = ((Object)((Object)this)).getClass().getName();
        this.addExportedServices(stringArray, (Object)this, properties);
    }

    public Hashtable createManagedProperties() {
        Hashtable properties = this.createProperties();
        properties.put("service.pid", ((Object)((Object)this)).getClass().getName());
        return properties;
    }

    public Hashtable createProperties() {
        Bundle bundle = this.getBundle();
        Hashtable properties = ConfigurableObject.createPropertiesFromHeaders((Dictionary)bundle.getHeaders());
        return properties;
    }

    public abstract TransportTestService createService(TransportService var1);

    public void createTransportTest(Dictionary properties, TransportService transport) {
        TransportTestService transportTest;
        TransportTestService transportTestOld = this.getTransportTest();
        if (transportTestOld != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.dk.transport.test.service.TransportTestService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.removeExportedService(clazz.getName());
            try {
                transportTestOld.exit();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setTransport(null);
        }
        if ((transportTest = this.createService(null)) != null) {
            transportTest.setConfigurationInformation(properties);
            try {
                transportTest.start();
            }
            catch (Exception exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setTransportTest(transportTest);
            String[] names = this.getExportedServiceNames();
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            this.addExportedServices(names, transportTest, serviceProperties);
        }
    }

    protected void deactivate() {
        TransportService transport = this.getTransport();
        if (transport != null) {
            transport.exit();
            this.setTransport(null);
        }
    }

    public ConnectionService getDefaultConnection() {
        return null;
    }

    public String[] getExportedServiceNames() {
        return BaseBundleActivator.NO_SERVICES;
    }

    public Dictionary getManagedProperties() {
        return this.managedProperties;
    }

    public String getServiceName() {
        return TransportService.SERVICE_NAME;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public TransportTestService getTransportTest() {
        return this.transportTest;
    }

    protected void handleAcquiredImportedService(Object service) {
        if (service instanceof TransportService) {
            this.createTransportTest(this.getManagedProperties(), (TransportService)service);
        }
    }

    protected void handleReleasedImportedService(Object service) {
        TransportService transportOld = this.getTransport();
        if (transportOld != null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.soda.dk.transport.service.TransportService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.removeExportedService(clazz.getName());
            transportOld.exit();
            this.setTransport(null);
        }
    }

    public boolean isFactoryConnection() {
        return this.factoryConnection;
    }

    public boolean isFactoryConnection(Dictionary properties) {
        if (properties == null) {
            return false;
        }
        Object value = properties.get("connection");
        return "factory".equals(value);
    }

    public void log(int severity, String message) {
        this.log(severity, message, null);
    }

    public void log(int severity, String message, Throwable exception) {
        LogService logService = EscObject.getDefaultLogService();
        logService.log(severity, message, exception);
    }

    protected boolean requiresAllImportedServices() {
        return false;
    }

    public void setFactoryConnection(boolean factoryConnection) {
        this.factoryConnection = factoryConnection;
    }

    public void setManagedProperties(Dictionary managedProperties) {
        this.managedProperties = managedProperties;
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }

    public void setTransportTest(TransportTestService transportTest) {
        this.transportTest = transportTest;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.setManagedProperties(properties);
        this.setFactoryConnection(this.isFactoryConnection(properties));
        this.createTransportTest(properties, null);
    }

    public void updateProperties(Dictionary table, Dictionary from) {
        if (from != null) {
            Enumeration enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = from.get(key);
                table.put(key, value);
            }
        }
    }
}

