/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.multiplex.connection;

import java.net.DatagramPacket;
import org.eclipse.soda.dk.multiplex.connection.ChannelBinding;
import org.eclipse.soda.dk.udp.multiplex.connection.RemoteAddress;

public class DatagramChannelBinding
extends ChannelBinding {
    private RemoteAddress remoteAddress;
    private boolean reconnectable;
    private byte[] receiveData;
    private int receiveDataOffset;
    private int receiveDataLength;

    public DatagramChannelBinding(String id) {
        super(id);
    }

    public synchronized void close() {
        if (this.getState() > 1) {
            this.setState(1);
        }
    }

    public RemoteAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isReconnectable() {
        return this.getState() != 0 && this.reconnectable;
    }

    public void open() {
        if (this.getState() < 2) {
            if (this.remoteAddress == null) {
                this.handleError(new IllegalStateException(), 1);
            } else {
                this.setState(2);
            }
        }
        this.start();
    }

    public int receiveData(byte[] bytes, int offset, int length) {
        int count;
        int n = count = this.receiveDataLength > length ? length : this.receiveDataLength;
        if (count > 0) {
            System.arraycopy(this.receiveData, this.receiveDataOffset, bytes, offset, count);
            this.receiveDataLength -= count;
            this.receiveDataOffset += count;
            if (this.receiveDataLength == 0) {
                this.receiveData = null;
            }
        }
        return count;
    }

    public void setReceiveData(DatagramPacket packet) {
        this.receiveData = packet.getData();
        this.receiveDataLength = packet.getLength();
        this.receiveDataOffset = packet.getOffset();
    }

    public void setReconnectable(boolean reconnectable) {
        this.reconnectable = reconnectable;
    }

    public void setRemoteAddress(RemoteAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void start() {
        if (this.getState() == 2) {
            this.setState(3);
        }
        if (this.getState() == 3) {
            this.setState(4);
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        if (this.remoteAddress != null) {
            buffer.append(",remoteAddr=");
            buffer.append(this.remoteAddress);
        }
    }
}

