/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.multiplex.connection;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.MultiplexConnection;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.udp.multiplex.connection.DatagramChannelBinding;
import org.eclipse.soda.dk.udp.multiplex.connection.RemoteAddress;
import org.eclipse.soda.dk.udp.multiplex.connection.service.UdpMultiplexConnectionService;

public class UdpMultiplexConnection
extends MultiplexConnection
implements ConnectionService,
UdpMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.udp.multiplex.connection.UdpMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "UdpMultiplexConnection[".toCharArray();
    protected DatagramSocket datagramSocket;
    private Map channelBindings = Collections.synchronizedMap(new HashMap());

    public UdpMultiplexConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    public UdpMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UdpMultiplexConnection(String localHost, int localPort, String targetHost, int targetPort) {
        this(localHost, localPort, targetHost, targetPort, -1, -1);
    }

    public UdpMultiplexConnection(String localHost, int localPort, String targetHost, int targetPort, int sendBufferSize, int receiveBufferSize) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("localhost", localHost);
        table.put("localport", UdpMultiplexConnection.createInteger((int)localPort));
        table.put("remotehost", targetHost);
        table.put("remoteport", UdpMultiplexConnection.createInteger((int)targetPort));
        table.put("readsize", UdpMultiplexConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", UdpMultiplexConnection.createInteger((int)sendBufferSize));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public void channelChanged(ChannelService channel, int newState, int oldState) {
        if (newState > 1 && oldState <= 1) {
            this.channelBindings.put(this.getRemoteAddress(channel), channel);
        }
        super.channelChanged(channel, newState, oldState);
        if (newState <= 1 && oldState > 1) {
            this.channelBindings.remove(this.getRemoteAddress(channel));
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        Exception exception = null;
        try {
            Iterator iterator = this.getChannels().values().iterator();
            while (iterator.hasNext()) {
                ChannelService channel = (ChannelService)iterator.next();
                channel.exit();
            }
            this.datagramSocket.close();
        }
        catch (Exception e) {
            exception = e;
        }
        this.report(exception, 1002, this.toString());
    }

    protected DatagramChannelBinding createChannel(String channelId) {
        DatagramChannelBinding channel = new DatagramChannelBinding(channelId);
        channel.setListener((ChannelListener)this);
        return channel;
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    private DatagramChannelBinding getChannel(RemoteAddress remoteAddress) {
        return (DatagramChannelBinding)((Object)this.channelBindings.get(remoteAddress));
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramSocket;
    }

    private RemoteAddress getRemoteAddress(ChannelService channel) {
        return ((DatagramChannelBinding)channel).getRemoteAddress();
    }

    private void initDatagramSocket() throws IOException {
        int localPortNumber = this.getInt("localport", 0);
        String localAddress = this.getString("localhost", "localhost");
        int receiveBufferSize = this.getInt("readsize", -1);
        int sendBufferSize = this.getInt("writesize", -1);
        this.datagramSocket = new DatagramSocket(localPortNumber, InetAddress.getByName(localAddress));
        if (receiveBufferSize > 0) {
            this.datagramSocket.setReceiveBufferSize(receiveBufferSize);
        }
        if (sendBufferSize > 0) {
            this.datagramSocket.setSendBufferSize(sendBufferSize);
        }
    }

    public synchronized void open() throws IOException {
        if (this.datagramSocket == null) {
            this.initDatagramSocket();
        }
        super.open();
        String targetAddress = this.getString("remotehost", "remotehost");
        int targetPortNumber = this.getInt("remoteport", -1);
        if (targetPortNumber != -1) {
            this.openChannel(this.createChannelId(), targetAddress, targetPortNumber, true);
        }
    }

    public ChannelService openChannel(String channelSpec) throws IOException {
        int pos = channelSpec.indexOf(58);
        if (pos == -1) {
            throw new IllegalArgumentException(channelSpec);
        }
        String host = channelSpec.substring(0, pos);
        int port = Integer.parseInt(channelSpec.substring(pos + 1));
        return this.openChannel(this.createChannelId(), host, port, true);
    }

    protected ChannelService openChannel(String channelId, String targetAddress, int targetPortNumber, boolean reconnectable) throws IOException {
        DatagramChannelBinding channel = this.createChannel(channelId);
        channel.setRemoteAddress(new RemoteAddress(targetAddress, targetPortNumber));
        channel.setReconnectable(reconnectable);
        channel.open();
        return channel;
    }

    protected DatagramChannelBinding processAccept(MultiplexConnectionListener listener, RemoteAddress remoteAddress) {
        return null;
    }

    public void processEvents() throws Exception {
        if (this.datagramSocket != null) {
            int packetSize = this.datagramSocket.getReceiveBufferSize();
            DatagramPacket packet = new DatagramPacket(new byte[packetSize], packetSize);
            this.datagramSocket.receive(packet);
            RemoteAddress remoteAddress = new RemoteAddress(packet.getAddress(), packet.getPort());
            DatagramChannelBinding channel = this.getChannel(remoteAddress);
            MultiplexConnectionListener listener = this.getConnectionListener();
            if (channel == null) {
                channel = this.processAccept(listener, remoteAddress);
            }
            if (channel != null) {
                channel.setReceiveData(packet);
                listener.processInput((ChannelService)channel);
            }
        }
    }

    public int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        DatagramChannelBinding datagramChannel = (DatagramChannelBinding)channel;
        return datagramChannel.receiveData(bytes, offset, length);
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        buffer.append(this.getString("remotehost", "remotehost"));
        buffer.append(':');
        buffer.append(this.getInt("remoteport", -1));
    }

    public void write(ChannelService channel, byte[] bytes, int offset, int count) throws IOException {
        DatagramChannelBinding datagramChannel = (DatagramChannelBinding)channel;
        if (datagramChannel != null && datagramChannel.getState() > 3) {
            RemoteAddress remoteAddress = datagramChannel.getRemoteAddress();
            DatagramPacket packet = new DatagramPacket(bytes, offset, count, remoteAddress.getAddress(), remoteAddress.getPort());
            this.datagramSocket.send(packet);
        }
    }
}

