/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.server.multiplex.connection;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.udp.multiplex.connection.RemoteAddress;
import org.eclipse.soda.dk.udp.multiplex.connection.UdpChannelBinding;
import org.eclipse.soda.dk.udp.multiplex.connection.UdpMultiplexConnection;
import org.eclipse.soda.dk.udp.server.multiplex.connection.service.UdpServerMultiplexConnectionService;

public class UdpServerMultiplexConnection
extends UdpMultiplexConnection
implements ConnectionService,
UdpServerMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.udp.server.multiplex.connection.UdpServerMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "UdpServerMultiplexConnection[".toCharArray();

    public UdpServerMultiplexConnection(ConfigurationService configuration) {
        this.setConfigurationService(configuration);
    }

    public UdpServerMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UdpServerMultiplexConnection(int localPort) {
        this(null, localPort);
    }

    public UdpServerMultiplexConnection(String localHost, int localPort) {
        this(localHost, localPort, -1);
    }

    public UdpServerMultiplexConnection(String localHost, int localPort, int maxChannels) {
        this(localHost, localPort, maxChannels, -1, -1);
    }

    public UdpServerMultiplexConnection(String localHost, int localPort, int maxChannels, int sendBufferSize, int receiveBufferSize) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        if (localHost != null) {
            table.put("localhost", localHost);
        }
        table.put("localport", UdpServerMultiplexConnection.createInteger((int)localPort));
        table.put("readsize", UdpServerMultiplexConnection.createInteger((int)receiveBufferSize));
        table.put("writesize", UdpServerMultiplexConnection.createInteger((int)sendBufferSize));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    protected UdpChannelBinding processAccept(MultiplexConnectionListener listener, RemoteAddress remoteAddress) {
        int maxChannels = this.getInt("maxchannels", -1);
        if (maxChannels == -1 || this.getChannels().size() < maxChannels) {
            UdpChannelBinding channel = this.createChannel(this.createChannelId());
            channel.setRemoteAddress(remoteAddress);
            channel.setReconnectable(false);
            channel.open();
            return channel;
        }
        return null;
    }
}

