/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.osgi.service.cm.ConfigurationException;

public abstract class BaseManagedServiceFactoryAdvisor
implements IManagedServiceFactoryAdvisor {
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String SHOULD_HAVE_OVERRIDDEN_METHOD_KEY = "Common.ShouldHaveOverriddenMethod";
    protected static final String[] NO_SERVICES = new String[0];

    protected final String[] basicGetImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        Set serviceNames = this.collectImportedServiceNames(pid, oldProperties, properties, manager);
        String[] result = this.toStringArray(serviceNames);
        return result;
    }

    protected final String[] basicGetOptionalImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        Set serviceNames = this.collectOptionalImportedServiceNames(pid, oldProperties, properties, manager);
        String[] result = this.toStringArray(serviceNames);
        return result;
    }

    private Set collectImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        HashSet serviceNames = new HashSet(13);
        this.collectImportedServiceNames(pid, oldProperties, properties, manager, serviceNames);
        return serviceNames;
    }

    protected void collectImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager, Set serviceNames) {
    }

    private Set collectOptionalImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        HashSet serviceNames = new HashSet(13);
        this.collectOptionalImportedServiceNames(pid, oldProperties, properties, manager, serviceNames);
        return serviceNames;
    }

    protected void collectOptionalImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager, Set serviceNames) {
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
    }

    public void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
    }

    public String[] getImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        String[] serviceNames = this.basicGetImportedServiceNames(pid, oldProperties, properties, manager);
        return serviceNames;
    }

    public String[] getOptionalImportedServiceNames(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        String[] serviceNames = this.basicGetOptionalImportedServiceNames(pid, oldProperties, properties, manager);
        return serviceNames;
    }

    public void handleAcquiredOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        this.warnShouldHaveOverriddenMethod("handleAcquiredOptionalImportedService(String, Object, String, Object, IBundleActivationManager)");
    }

    public void handleReleasedOptionalImportedService(String pid, Object object, String importedServiceName, Object importedService, IBundleActivationManager manager) {
        this.warnShouldHaveOverriddenMethod("handleReleasedOptionalImportedService(String, Object, String, Object, IBundleActivationManager)");
    }

    private String[] toStringArray(Set setOfStrings) {
        int size = setOfStrings.size();
        if (size == 0) {
            return NO_SERVICES;
        }
        Object[] result = new String[size];
        setOfStrings.toArray(result);
        Arrays.sort(result);
        return result;
    }

    public void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
    }

    private void warnShouldHaveOverriddenMethod(String method) {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        BaseManagedServiceFactoryAdvisor source = this;
        String pattern = Messages.getString(SHOULD_HAVE_OVERRIDDEN_METHOD_KEY);
        String warning = MessageFormatter.format(pattern, method);
        utility.warn(component, source, warning, null, null);
    }
}

