/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.framework;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.ProxyServiceHandlerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceAdvisor;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public abstract class ManagedServiceBundleActivator
extends BaseBundleActivator
implements ManagedService {
    private static final String CHECK_METADATA_EXISTS_PROPERTY = "org.eclipse.soda.sat.core.framework.check.metadata.exists";
    private static final String CREATE_MANAGED_SERVICE_PROXY_PROPERTY = "org.eclipse.soda.sat.core.framework.create.ms.proxy";
    private static final String DEFAULT_CHECK_METADATA_EXISTS = Boolean.FALSE.toString();
    private static final String DEFAULT_CREATE_MANAGED_SERVICE_PROXY = Boolean.FALSE.toString();
    private static final boolean CHECK_METADATA_EXISTS = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.check.metadata.exists", DEFAULT_CHECK_METADATA_EXISTS));
    private static final boolean CREATE_MANAGED_SERVICE_PROXY = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.create.ms.proxy", DEFAULT_CREATE_MANAGED_SERVICE_PROXY));
    private static final String FAILED_TO_FIND_METADATA_RESOURCE_KEY = "ManagedServiceBundleActivator.FailedToFindMetaDataResource";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    protected static final String CONFIGURATION_ADMIN_SERVICE_NAME;
    protected static final String MANAGED_SERVICE_SERVICE_NAME;
    private IManagedServiceActivationManager managedServiceActivationManager;
    private String pid;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONFIGURATION_ADMIN_SERVICE_NAME = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MANAGED_SERVICE_SERVICE_NAME = clazz2.getName();
    }

    protected void activate() {
        this.registerManagedService();
    }

    private void addExportedManagedServiceProxyService() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> interfaceType = clazz;
        ProxyServiceHandlerAdapter handler = new ProxyServiceHandlerAdapter(){

            public Object createService() {
                return ManagedServiceBundleActivator.this.createManagedService();
            }
        };
        Dictionary properties = this.createManagedServiceProperties();
        this.addExportedProxyService(interfaceType, handler, properties);
    }

    private void checkMetaDataResourceExists() {
        if (!CHECK_METADATA_EXISTS) {
            return;
        }
        Bundle bundle = this.getBundle();
        URL url = bundle.getResource("META-INF/METADATA.XML");
        if (url != null) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = bundle.getSymbolicName();
        String warning = Messages.getString(FAILED_TO_FIND_METADATA_RESOURCE_KEY);
        utility.warn(component, source, warning, null, null);
    }

    protected void collectImportedServiceNames(Set serviceNames) {
        super.collectImportedServiceNames(serviceNames);
        serviceNames.add(CONFIGURATION_ADMIN_SERVICE_NAME);
    }

    protected abstract IManagedServiceAdvisor createAdvisor();

    protected final String createDefaultPid() {
        Class<?> clazz = this.getClass();
        String name = clazz.getName();
        return name;
    }

    private ManagedService createManagedService() {
        this.checkMetaDataResourceExists();
        this.startManagedServiceActivationManager();
        ManagedService service = this.getManagedService();
        return service;
    }

    private IManagedServiceActivationManager createManagedServiceActivationManager() {
        IManagedServiceAdvisor advisor = this.createAdvisor();
        FactoryUtility utility = FactoryUtility.getInstance();
        IManagedServiceActivationManager manager = utility.createManagedServiceActivationManager(advisor);
        return manager;
    }

    private Dictionary createManagedServiceProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>(11);
        String pid = this.getPid();
        ((Dictionary)properties).put("service.pid", pid);
        return properties;
    }

    protected String createPid() {
        String pid = this.createDefaultPid();
        return pid;
    }

    protected void deactivate() {
        this.unregisterManagedService();
        this.stopManagedServiceActivationManager();
    }

    private ManagedService getManagedService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedServiceActivationManager getManagedServiceActivationManager() {
        ManagedServiceBundleActivator managedServiceBundleActivator = this;
        synchronized (managedServiceBundleActivator) {
            if (this.managedServiceActivationManager == null) {
                IManagedServiceActivationManager manager = this.createManagedServiceActivationManager();
                this.setManagedServiceActivationManager(manager);
            }
            return this.managedServiceActivationManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getPid() {
        ManagedServiceBundleActivator managedServiceBundleActivator = this;
        synchronized (managedServiceBundleActivator) {
            if (this.pid == null) {
                String pid = this.createPid();
                this.setPid(pid);
            }
            return this.pid;
        }
    }

    protected boolean isProxyService() {
        return CREATE_MANAGED_SERVICE_PROXY;
    }

    private void registerManagedService() {
        boolean proxy = this.isProxyService();
        if (proxy) {
            this.addExportedManagedServiceProxyService();
        } else {
            ManagedService service = this.createManagedService();
            Dictionary properties = this.createManagedServiceProperties();
            this.addExportedService(MANAGED_SERVICE_SERVICE_NAME, service, properties);
        }
    }

    private void setManagedServiceActivationManager(IManagedServiceActivationManager managedServiceActivationManager) {
        this.managedServiceActivationManager = managedServiceActivationManager;
    }

    private void setPid(String pid) {
        this.pid = pid;
    }

    private void startManagedServiceActivationManager() {
        BundleContext context = this.getBundleContext();
        IManagedServiceActivationManager manager = this.getManagedServiceActivationManager();
        manager.start(context);
    }

    private void stopManagedServiceActivationManager() {
        IManagedServiceActivationManager manager = this.getManagedServiceActivationManager();
        manager.stop();
        this.setManagedServiceActivationManager(null);
    }

    private void unregisterManagedService() {
        this.removeExportedService(MANAGED_SERVICE_SERVICE_NAME);
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        IManagedServiceActivationManager manager = this.getManagedServiceActivationManager();
        manager.updated(properties);
    }
}

