/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleUninstallManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.FrameworkManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.service.BundleUninstallService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
extends BaseBundleActivator {
    private static final String BUNDLE_ADDED_PROPERTY = "Activator.BundleAddedProperty";
    private static final String BUNDLE_REMOVED_PROPERTY = "Activator.BundleRemovedProperty";
    private static final String LOG_SERVICE_NAME;
    private static final String PACKAGE_ADMIN_SERVICE_NAME;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_SERVICE_NAME = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_ADMIN_SERVICE_NAME = clazz2.getName();
    }

    protected void activate() {
        this.addExportedBundleDependencyService();
        this.addExportedBundleUninstallService();
    }

    private void addExportedBundleDependencyService() {
        this.startupBundleDependencyManager();
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        boolean started = manager.isStarted();
        if (!started) {
            return;
        }
        this.addExportedService(BundleDependencyService.SERVICE_NAME, manager, null);
    }

    private void addExportedBundleUninstallService() {
        BundleUninstallManager manager = BundleUninstallManager.getInstance();
        this.addExportedService(BundleUninstallService.SERVICE_NAME, manager, null);
    }

    private void addSystemProperties() {
        Properties properties = this.getProperties();
        boolean empty = properties.isEmpty();
        if (empty) {
            return;
        }
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            this.addSystemProperty(key, value);
        }
    }

    private void addSystemProperty(Object key, Object value) {
        Properties sysProps = System.getProperties();
        boolean exists = sysProps.containsKey(key);
        if (exists) {
            return;
        }
        sysProps.put(key, value);
        String pattern = Messages.getString(BUNDLE_ADDED_PROPERTY);
        String symbolicName = this.getBundleSymbolicName();
        Object[] values = new Object[]{symbolicName, key, value};
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logInfo(message);
    }

    protected void deactivate() {
        this.shutdownBundleDependencyManager();
    }

    protected String[] getImportedServiceNames() {
        return new String[]{PACKAGE_ADMIN_SERVICE_NAME};
    }

    protected String[] getOptionalImportedServiceNames() {
        return new String[]{LOG_SERVICE_NAME};
    }

    private PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.getImportedService(PACKAGE_ADMIN_SERVICE_NAME);
    }

    protected InputStream getPropertiesInputStream() throws IOException {
        return this.getFilePropertiesInputStream();
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (serviceName.equals(LOG_SERVICE_NAME)) {
            LogService logService = (LogService)service;
            LogUtility utility = LogUtility.getInstance();
            utility.setLog(logService);
        } else {
            super.handleAcquiredOptionalImportedService(serviceName, service);
        }
    }

    protected void handleFailedToFindProperties(String filename) {
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (serviceName.equals(LOG_SERVICE_NAME)) {
            LogUtility utility = LogUtility.getInstance();
            utility.setLog(null);
        } else {
            super.handleReleasedOptionalImportedService(serviceName, service);
        }
    }

    private boolean isBundleDependencyServiceEnabled() {
        String trueValue = Boolean.TRUE.toString();
        String property = System.getProperty("org.eclipse.soda.sat.core.bds.status", trueValue);
        Boolean wrapper = Boolean.valueOf(property);
        boolean status = wrapper;
        return status;
    }

    private void removeSystemProperties() {
        Properties properties = this.getProperties();
        boolean empty = properties.isEmpty();
        if (empty) {
            return;
        }
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeSystemProperty(key);
        }
    }

    private void removeSystemProperty(String key) {
        Properties sysProps = System.getProperties();
        Object value = sysProps.remove(key);
        if (value == null) {
            return;
        }
        String pattern = Messages.getString(BUNDLE_REMOVED_PROPERTY);
        String symbolicName = this.getBundleSymbolicName();
        Object[] values = new Object[]{symbolicName, key};
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logInfo(message);
    }

    private void shutdownBundleDependencyManager() {
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        manager.shutdown(bundleContext);
        manager.setPackageAdmin(null);
    }

    private void shutdownBundleUninstallManager() {
        BundleUninstallManager manager = BundleUninstallManager.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        manager.shutdown(bundleContext);
    }

    private void shutdownFrameworkManager() {
        FrameworkManager manager = FrameworkManager.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        manager.shutdown(bundleContext);
    }

    protected void start() throws Exception {
        this.addSystemProperties();
        this.startupBundleUninstallManager();
        this.startupFrameworkManager();
    }

    private void startupBundleDependencyManager() {
        boolean status = this.isBundleDependencyServiceEnabled();
        if (!status) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        PackageAdmin admin = this.getPackageAdmin();
        manager.setPackageAdmin(admin);
        BundleContext bundleContext = this.getBundleContext();
        manager.startup(bundleContext);
    }

    private void startupBundleUninstallManager() {
        BundleUninstallManager manager = BundleUninstallManager.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        manager.startup(bundleContext);
    }

    private void startupFrameworkManager() {
        FrameworkManager manager = FrameworkManager.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        manager.startup(bundleContext);
    }

    protected void stop() throws Exception {
        this.shutdownFrameworkManager();
        this.shutdownBundleUninstallManager();
        this.removeSystemProperties();
    }
}

