/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.interfaces.BundleDependencyListener;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleActivationManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class BundleDependencyManager
extends BundleManager
implements BundleDependencyService {
    private static final String BUNDLE_ACTIVATION_MANAGER_ID_IS_NOT_UNIQUE_KEY = "BundleDependencyManager.BundleActivationManagerIdIsNotUnique";
    private static final String FAILED_TO_COMPUTE_UNIQUE_ID_FOR_BUNDLE_ACTIVATION_MANAGER_KEY = "BundleDependencyManager.FailedToComputeUniqueIdForBundleActivationManager";
    private static final String LOG_ID_NOT_UNIQUE_PROPERTY = "org.eclipse.soda.sat.core.framework.log.id.not.unique";
    private static final String DEFAULT_LOG_ID_NOT_UNIQUE = Boolean.FALSE.toString();
    private static final boolean LOG_ID_NOT_UNIQUE = Boolean.valueOf(System.getProperty("org.eclipse.soda.sat.core.framework.log.id.not.unique", DEFAULT_LOG_ID_NOT_UNIQUE));
    private static final int UNINSTALLABLE_CONTAINER_CAPACITY = 35;
    private static final BundleDependencyManager INSTANCE = new BundleDependencyManager();
    private IDependencyTracker dependencyTracker;
    private IDependencyTracker.IXmlProvider xmlProvider;
    private List listeners;
    private PackageAdmin packageAdmin;
    private List uninstallableBundles;
    private Map bundleActivationManagers;

    public static BundleDependencyManager getInstance() {
        return INSTANCE;
    }

    private BundleDependencyManager() {
        this.setDependencyTracker(this.createDependencyTracker(251));
        this.setListeners(new ArrayList(10));
        this.setUninstallableBundles(new ArrayList(35));
        this.setBundleActivationManagers(new HashMap(101));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleActivationManager(BundleActivationManager bundleActivationManager) {
        Assertion.checkArgumentIsNotNull(bundleActivationManager, "bundleActivationManager");
        String id = bundleActivationManager.getId();
        if (id == null) {
            return;
        }
        Map map = this.getBundleActivationManagers();
        String key = id;
        Map map2 = map;
        synchronized (map2) {
            Object value = map.get(key);
            if (value != null) {
                boolean match;
                boolean bl = match = bundleActivationManager == value;
                if (match) {
                    return;
                }
                String uniqueId = this.computeUniqueIdForBundleActivationManager(id);
                this.logBundleActivationManagerIdIsNotUnique(id, uniqueId);
                if (uniqueId == null) {
                    return;
                }
                key = uniqueId;
            }
            map.put(key, bundleActivationManager);
        }
        boolean match = id.equals(key);
        if (match) {
            return;
        }
        bundleActivationManager.setId(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleDependencyListener(BundleDependencyListener listener) {
        List listeners;
        Assertion.checkArgumentIsNotNull(listener, "listener");
        List list = listeners = this.getListeners();
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUninstallableBundle(Bundle bundle) {
        List uninstallableBundles;
        boolean uninstallable = this.isRegisteredAsUninstallable(bundle);
        if (uninstallable) {
            return;
        }
        List list = uninstallableBundles = this.getUninstallableBundles();
        synchronized (list) {
            uninstallableBundles.add(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeUniqueIdForBundleActivationManager(String id) {
        Map map = this.getBundleActivationManagers();
        int tries = 1;
        int maxTries = 5;
        long delayMs = 100L;
        do {
            Object value;
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            long now = System.currentTimeMillis();
            String uniqueId = String.valueOf(id) + '-' + now;
            Map map2 = map;
            synchronized (map2) {
                value = map.get(uniqueId);
            }
            if (value != null) continue;
            return uniqueId;
        } while (++tries < maxTries);
        return null;
    }

    private String convertBundleToXml(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        int size = symbolicName.length() + 12;
        StringBuffer buffer = new StringBuffer(size);
        this.printXmlOn(buffer, symbolicName);
        String xml = buffer.toString();
        return xml;
    }

    private IDependencyTracker createDependencyTracker(int size) {
        FactoryUtility utility = FactoryUtility.getInstance();
        IDependencyTracker tracker = utility.createDependencyTracker(size, size);
        return tracker;
    }

    private IDependencyTracker.IXmlProvider createXmlProvider() {
        return new IDependencyTracker.IXmlProvider(){

            public String convertDependentToXml(Object dependent, int indent) {
                Bundle bundle = (Bundle)dependent;
                return BundleDependencyManager.this.convertBundleToXml(bundle);
            }

            public String convertPrerequisiteToXml(Object prerequisite, int indent) {
                Bundle bundle = (Bundle)prerequisite;
                return BundleDependencyManager.this.convertBundleToXml(bundle);
            }
        };
    }

    private void depopulate() {
        IDependencyTracker tracker = this.getDependencyTracker();
        tracker.removeAll();
    }

    public List getAllDependentsOf(Bundle bundle) {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        List dependents = dependencyTracker.getAllDependents(bundle);
        return dependents;
    }

    public List getAllPrerequisitesOf(Bundle bundle) {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        List prerequisites = dependencyTracker.getAllPrerequisites(bundle);
        return prerequisites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBundleActivationManager getBundleActivationManager(String id) {
        IBundleActivationManager value;
        Map map;
        Assertion.checkArgumentIsNotNull(id, "id");
        Map map2 = map = this.getBundleActivationManagers();
        synchronized (map2) {
            value = (IBundleActivationManager)map.get(id);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBundleActivationManagerIds() {
        Set keys;
        Map map;
        Map map2 = map = this.getBundleActivationManagers();
        synchronized (map2) {
            keys = map.keySet();
        }
        int size = keys.size();
        ArrayList ids = new ArrayList(size);
        ids.addAll(keys);
        Collections.sort(ids);
        return ids;
    }

    private Map getBundleActivationManagers() {
        return this.bundleActivationManagers;
    }

    public Collection getBundles() {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        List bundles = dependencyTracker.getValues();
        return bundles;
    }

    private IDependencyTracker getDependencyTracker() {
        return this.dependencyTracker;
    }

    public List getDependentsOf(Bundle bundle) {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        List dependents = dependencyTracker.getDependents(bundle);
        return dependents;
    }

    private String[] getImportedPackages(Bundle bundle) {
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] packages = utility.getImportPackages(bundle, false);
        return packages;
    }

    private List getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getListenersIterator() {
        Collection clone;
        ArrayList listeners;
        ArrayList arrayList = listeners = (ArrayList)this.getListeners();
        synchronized (arrayList) {
            clone = (Collection)listeners.clone();
        }
        Iterator iterator = clone.iterator();
        return iterator;
    }

    private PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    public List getPrerequisitesOf(Bundle bundle) {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        List prerequisites = dependencyTracker.getPrerequisites(bundle);
        return prerequisites;
    }

    private String[] getRequireBundles(Bundle bundle) {
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] symbolicNames = utility.getRequireBundles(bundle, false);
        return symbolicNames;
    }

    public List getUnacquiredImportedServiceNames(String id) {
        IBundleActivationManager manager = this.getBundleActivationManager(id);
        if (manager == null) {
            return null;
        }
        String[] names = manager.getUnacquiredImportedServiceNames();
        List<String> list = Arrays.asList(names);
        return list;
    }

    public List getUnacquiredOptionalImportedServiceNames(String id) {
        IBundleActivationManager manager = this.getBundleActivationManager(id);
        if (manager == null) {
            return null;
        }
        String[] names = manager.getUnacquiredOptionalImportedServiceNames();
        List<String> list = Arrays.asList(names);
        return list;
    }

    private List getUninstallableBundles() {
        return this.uninstallableBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDependencyTracker.IXmlProvider getXmlProvider() {
        BundleDependencyManager bundleDependencyManager = this;
        synchronized (bundleDependencyManager) {
            if (this.xmlProvider == null) {
                IDependencyTracker.IXmlProvider xmlProvider = this.createXmlProvider();
                this.setXmlProvider(xmlProvider);
            }
            return this.xmlProvider;
        }
    }

    protected void handleBundleResolved(Bundle bundle) {
        this.registerImportedPackageDependencies(bundle);
        this.registerRequireBundleDependencies(bundle);
    }

    protected void handleBundleUninstalled(Bundle bundle) {
        this.uninstallPrerequisiteBundles(bundle);
    }

    protected void handleBundleUnresolved(Bundle bundle) {
        boolean remove;
        boolean bl = remove = !this.hasUninstallablePrerequisites(bundle);
        if (!remove) {
            return;
        }
        IDependencyTracker tracker = this.getDependencyTracker();
        tracker.removeDependent(bundle);
    }

    protected void handleManagerShutdown() {
        this.depopulate();
    }

    protected void handleManagerStarted() {
        this.populate();
    }

    private boolean hasUninstallablePrerequisites(Bundle bundle) {
        List uninstallableBundles = this.getUninstallableBundles();
        boolean empty = uninstallableBundles.isEmpty();
        if (empty) {
            return false;
        }
        List prerequisites = this.getPrerequisitesOf(bundle);
        Iterator iterator = prerequisites.iterator();
        boolean found = false;
        while (!found && iterator.hasNext()) {
            Object prerequisite = iterator.next();
            found = uninstallableBundles.contains(prerequisite);
        }
        return found;
    }

    private boolean isBundleActive(Bundle bundle) {
        int state = bundle.getState();
        boolean active = state == 32;
        return active;
    }

    public boolean isRegisteredAsUninstallable(Bundle bundle) {
        Assertion.checkArgumentIsNotNull(bundle, "bundle");
        List uninstallableBundles = this.getUninstallableBundles();
        boolean result = uninstallableBundles.contains(bundle);
        return result;
    }

    private void logBundleActivationManagerIdIsNotUnique(String id, String uniqueId) {
        String message;
        if (!LOG_ID_NOT_UNIQUE) {
            return;
        }
        if (uniqueId == null) {
            String pattern = Messages.getString(FAILED_TO_COMPUTE_UNIQUE_ID_FOR_BUNDLE_ACTIVATION_MANAGER_KEY);
            message = MessageFormatter.format(pattern, id);
        } else {
            Object[] values = new Object[]{id, uniqueId};
            String pattern = Messages.getString(BUNDLE_ACTIVATION_MANAGER_ID_IS_NOT_UNIQUE_KEY);
            message = MessageFormatter.format(pattern, values);
        }
        LogUtility.logInfo(this, message);
    }

    private void populate() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle[] bundles = bundleContext.getBundles();
        int count = bundles.length;
        if (count == 0) {
            return;
        }
        int i = 0;
        while (i < count) {
            Bundle bundle = bundles[i];
            this.handleBundleResolved(bundle);
            ++i;
        }
    }

    private void printIndentOn(StringBuffer buffer, int level) {
        Assertion.checkRange(level, "level", 0L, Integer.MAX_VALUE);
        String indent = "  ";
        int i = 0;
        while (i < level) {
            buffer.append(indent);
            ++i;
        }
    }

    private void printXmlOn(StringBuffer buffer, Object object) {
        buffer.append("<![CDATA[");
        buffer.append(object);
        buffer.append("]]>");
    }

    public void register(Bundle importer, Bundle exporter) {
        Assertion.checkArgumentIsNotNull(importer, "importer");
        Assertion.checkArgumentIsNotNull(exporter, "exporter");
        boolean recursive = importer.equals(exporter);
        if (recursive) {
            return;
        }
        this.registerDependency(importer, exporter);
    }

    private void registerDependency(Bundle dependent, Bundle prerequisite) {
        IDependencyTracker tracker = this.getDependencyTracker();
        boolean added = tracker.add(dependent, prerequisite);
        if (!added) {
            return;
        }
        Iterator iterator = this.getListenersIterator();
        while (iterator.hasNext()) {
            BundleDependencyListener listener = (BundleDependencyListener)iterator.next();
            listener.registered(dependent, prerequisite);
        }
    }

    private boolean registerImportedPackageDependencies(Bundle dependent) {
        boolean result = true;
        String[] packages = this.getImportedPackages(dependent);
        int i = 0;
        while (i < packages.length) {
            String packageName = packages[i];
            boolean registered = this.registerImportedPackageDependency(packageName, dependent);
            if (!registered) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean registerImportedPackageDependency(String packageName, Bundle dependent) {
        PackageAdmin admin = this.getPackageAdmin();
        ExportedPackage[] exportedPackages = admin.getExportedPackages(packageName);
        if (exportedPackages == null) {
            return false;
        }
        int i = 0;
        while (i < exportedPackages.length) {
            Bundle[] importingBundles;
            ExportedPackage exportedPackage = exportedPackages[i];
            Bundle prerequisite = exportedPackage.getExportingBundle();
            if (prerequisite != null && (importingBundles = exportedPackage.getImportingBundles()) != null) {
                int j = 0;
                while (j < importingBundles.length) {
                    Bundle importingBundle = importingBundles[j];
                    boolean match = importingBundle.equals(dependent);
                    if (match) {
                        this.register(dependent, prerequisite);
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean registerRequireBundleDependencies(Bundle dependent) {
        boolean result = true;
        String[] symbolicNames = this.getRequireBundles(dependent);
        int i = 0;
        while (i < symbolicNames.length) {
            String symbolicName = symbolicNames[i];
            boolean registered = this.registerRequireBundleDependency(symbolicName, dependent);
            if (!registered) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private boolean registerRequireBundleDependency(String symbolicName, Bundle dependent) {
        PackageAdmin admin = this.getPackageAdmin();
        RequiredBundle[] requiredBundles = admin.getRequiredBundles(symbolicName);
        if (requiredBundles == null) {
            return false;
        }
        int i = 0;
        while (i < requiredBundles.length) {
            RequiredBundle requiredBundle = requiredBundles[i];
            Bundle[] requiringBundles = requiredBundle.getRequiringBundles();
            if (requiringBundles != null) {
                int j = 0;
                while (j < requiringBundles.length) {
                    Bundle requiringBundle = requiringBundles[j];
                    boolean match = requiringBundle.equals(dependent);
                    if (match) {
                        Bundle prerequisite = requiredBundle.getBundle();
                        this.register(dependent, prerequisite);
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleActivationManager(BundleActivationManager bundleActivationManager) {
        Map map;
        Assertion.checkArgumentIsNotNull(bundleActivationManager, "bundleActivationManager");
        String key = bundleActivationManager.getId();
        if (key == null) {
            return;
        }
        Map map2 = map = this.getBundleActivationManagers();
        synchronized (map2) {
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleDependencyListener(BundleDependencyListener listener) {
        List listeners;
        Assertion.checkArgumentIsNotNull(listener, "listener");
        List list = listeners = this.getListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUninstallableBundle(Bundle bundle) {
        List uninstallableBundles;
        Assertion.checkArgumentIsNotNull(bundle, "bundle");
        List list = uninstallableBundles = this.getUninstallableBundles();
        synchronized (list) {
            uninstallableBundles.remove(bundle);
        }
    }

    private void setBundleActivationManagers(Map bundleActivationManagers) {
        this.bundleActivationManagers = bundleActivationManagers;
    }

    private void setDependencyTracker(IDependencyTracker dependencyTracker) {
        this.dependencyTracker = dependencyTracker;
    }

    private void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    private void setUninstallableBundles(List uninstallableBundles) {
        this.uninstallableBundles = uninstallableBundles;
    }

    private void setXmlProvider(IDependencyTracker.IXmlProvider xmlProvider) {
        this.xmlProvider = xmlProvider;
    }

    public String toXml() {
        String xml = this.toXml(0);
        return xml;
    }

    public String toXml(int indent) {
        IDependencyTracker.IXmlProvider xmlProvider = this.getXmlProvider();
        String result = this.toXml(indent, xmlProvider);
        return result;
    }

    private String toXml(int indent, IDependencyTracker.IXmlProvider xmlProvider) {
        IDependencyTracker dependencyTracker = this.getDependencyTracker();
        String xml = dependencyTracker.toXml(null, indent + 1, xmlProvider);
        int size = xml.length() + 25;
        StringBuffer buffer = new StringBuffer(size);
        String newline = System.getProperty("line.separator");
        this.printIndentOn(buffer, indent);
        buffer.append("<bundleDependencyService>");
        buffer.append(xml);
        buffer.append(newline);
        this.printIndentOn(buffer, indent);
        buffer.append("</bundleDependencyService>");
        buffer.append(newline);
        String result = buffer.toString();
        return result;
    }

    private void uninstallBundle(Bundle bundle) {
        block4: {
            boolean active = this.isBundleActive(bundle);
            if (!active) {
                return;
            }
            boolean uninstallable = this.isRegisteredAsUninstallable(bundle);
            if (!uninstallable) {
                return;
            }
            try {
                bundle.uninstall();
            }
            catch (BundleException exception) {
                exception.printStackTrace();
                Throwable nested = exception.getNestedException();
                if (nested == null) break block4;
                nested.printStackTrace();
            }
        }
    }

    private void uninstallPrerequisiteBundles(Bundle bundle) {
        IDependencyTracker tracker = this.getDependencyTracker();
        List prerequisiteBundles = tracker.removeWithPrerequisites(bundle);
        Iterator iterator = prerequisiteBundles.iterator();
        while (iterator.hasNext()) {
            Bundle prerequisiteBundle = (Bundle)iterator.next();
            this.uninstallBundle(prerequisiteBundle);
        }
    }

    public void unregister(Bundle importer, Bundle exporter) {
        Assertion.checkArgumentIsNotNull(importer, "impoter");
        Assertion.checkArgumentIsNotNull(exporter, "exporter");
        boolean recursive = importer.equals(exporter);
        if (recursive) {
            return;
        }
        this.unregisterDependency(importer, exporter);
    }

    private void unregisterDependency(Bundle importer, Bundle exporter) {
        IDependencyTracker tracker = this.getDependencyTracker();
        boolean removed = tracker.remove(importer, exporter);
        if (!removed) {
            return;
        }
        Iterator iterator = this.getListenersIterator();
        while (iterator.hasNext()) {
            BundleDependencyListener listener = (BundleDependencyListener)iterator.next();
            listener.unregistered(importer, exporter);
        }
    }
}

